/*
  $Id: sock.h,v 1.2 1996/08/18 16:09:19 luik Exp $

  sock.h - socket for omirrd C header file.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SOCK_H_INCLUDED
#define SOCK_H_INCLUDED

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef IPPORT_OMIRR
#define	IPPORT_OMIRR	808	/* default port */
#endif

#define SERVICE_OMIRR	"omirr"	/* service for getservbyname(3N) */

/* sock.c */
extern int sockServer(char *service, int port);
extern int sockClient(char *host, char *service, int port, struct sockaddr_in *sock_addrp);
extern int sockClientNonBlocking(char *host, char *service, int port, struct sockaddr_in *sock_addrp);
extern int sockConnect(int s, struct sockaddr_in *sock_addrp);
extern int sockAccept(int sockfd, struct sockaddr_in *sock_addrp, int *sock_addr_lenp);
extern int sockReservedPort(struct sockaddr_in *sock_addrp);
extern const char *sockHostname(struct sockaddr_in *sock_addrp);

#ifdef	__cplusplus
}
#endif

#endif /* defined(SOCK_H_INCLUDED) */
