/*
  $Id: fileop.h,v 1.1 1996/08/20 14:55:33 luik Exp $

  fileop.h - definitions of system call wrappers which catch EINTR
  error and retry.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef FILEOP_H_INCLUDED
#define FILEOP_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

/* fileop.c */
extern int Chmod(const char *path, mode_t mode);
extern int Chown(const char *path, uid_t owner, gid_t group);
extern int Link(const char *path, const char *newpath);
extern int Lstat(const char *path, struct stat *buf);
extern int Mkdir(const char *path, mode_t mode);
extern int Mknod(const char *path, mode_t mode, dev_t dev);
extern int Readlink(const char *path, void *buf, size_t bufsiz);
extern int Rename(const char *path, const char *newpath);
extern int Rmdir(const char *path);
extern int Stat(const char *path, struct stat *buf);
extern int Symlink(const char *link, const char *path);
extern int Unlink(const char *path);
extern int Utime(const char *path, struct utimbuf *times);

#ifdef	__cplusplus
}
#endif

#endif /* defined(FILEOP_H_INCLUDED) */
