/*
  $Id: conn.h,v 1.6 1997/01/17 01:50:25 luik Exp $

  conn.h - definitions for omirrd socket connections module.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef CONN_H_INCLUDED
#define CONN_H_INCLUDED

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct ConnEntry_ *ConnEntry;

#include "cf.h"
#include "request.h"

typedef enum ConnState_ {
    CONN_DEAD,
    CONN_CONNECTING,		/* connect(3N) in progress */
    CONN_CONNECTED,		/* connect(3N) finished */
    CONN_ACTIVE			/* both connected and accepted */
} ConnState;


typedef struct ConnEntry_ {	/* declarations and definitions */
    char *name;			/* hostname as specified in config file */
    char *hostname;		/* official hostname */
    void *cmds;			/* ptr to command data (CfCmd) */
    int masterfd;		/* socket used for master role (from connect) */
    struct sockaddr_in mastersock_addr;	/* sockaddr_in for masterfd socket */
    int slavefd;		/* socket used for slave role (from accept) */
    void *slave_op;		/* data for slave operations */
    ConnState state;		/* current state of connection */
    time_t retry_time;		/* abs. time when connect should be retried */
    int retry_interval;		/* current retry interval */
    ConnEntry next;		/* linked list */
} ConnEntryRec;


/* CONN_OWN_HOST is used for c_conn pointer in CfCmdRec to signal an
   entry for the own host (where no ConnEntry exists for).  */
#define CONN_OWN_HOST ((ConnEntry) -1)


/* conn.c */
extern ConnEntry connAddEntry(char *name);
extern void connRemoveEntry(ConnEntry e);
extern void connDoConnectionsToServers(CfCmd cmds);
extern void connConnectToServer(ConnEntry e);
extern void connTerminateConnection(ConnEntry e);
extern void connDoTerminateConnectionsToServers(void);
extern void connAcceptClient(int sockfd);
extern void connWriteMessage(ReqRequest r);
extern void connSyncToServer(ConnEntry e);
extern void connDoSyncsToServers(void);
extern void connProcessRedoStore(ConnEntry e);
#ifdef DEBUG
extern void connDebugConnections(FILE *f);
#endif

#ifdef	__cplusplus
}
#endif

#endif /* defined(CONN_H_INCLUDED) */
