/*
 Network Security MONintor
 (c)Copyright 1998-99 Tibor Koleszar
*/
#include "config.h"


/*****************************************************************************/
/*    Converts config string into a normal                                   */
/*    "string=string" format. (eg: "     Name = Foo.com" -> "name=Foo.com")  */
/*****************************************************************************/
void new_string (char *new, char *old) 
{
 int ii=0,j=0, first=1;
 char *s;

 if (old[0] != '#') 
 { 
   s = strtok(old, "#");
   if (s[0] != 0) ii=0;
   while (ii<strlen(s)) 
   {
    if (s[ii] != 9 && s[ii] != 10) 
    { 
     if (!(first && s[ii]==32)) 
     {
      if (first) { old[j]=tolower(s[ii]); if (s[ii]=='=') { first=0; while (s[ii+1]==32) ii++; } } 
      else old[j]=s[ii];
      j++;
     }
    }
    ii++;
    }
 }
 old[j]=0;
}

/*****************************************************************************/
/*    Cuts everything in a string before the "=" sign                        */
/*    (eg: "name=Foo.com" -> "Foo.com")                                      */
/*****************************************************************************/
char *cut_str (char *str) 
{
 char *s;
 s = strtok(str, "="); s = strtok(NULL, "=");
 strcpy(str, s);
 return str;
}

/*****************************************************************************/
/*   Reads the config file and fill the struct and checks the errors         */
/*                                                                           */
/*****************************************************************************/
void read_config (char *configfile) 
{
 FILE *conf;
 unsigned int t;
 char s[2048], *dummy, notdef[1024];

 hostnum = 0;
 if ((conf = fopen (configfile, "rt")) == NULL )
 {
  fprintf(stderr, "NSMON FATAL: No config file found\n");
  exit(0);
 }
 logfilename[0] = 0;
 strcpy(logfilename, "/var/log/nsmon.log");
 servername[0] = 0;
 username[0] = 0;
 LOCK_DIR[0] = 0;
 gateway[0] = 0;
 while (!feof(conf)) 
 {
  fgets(s, 1024, conf);  
  if (!feof(conf)) 
  {
   new_string(s, s);
   if (!strncmp(s, "logfile=", 8)) { strcpy(logfilename, cut_str(s)); }
   if (!strncmp(s, "lock=", 5)) { strcpy(LOCK_DIR, cut_str(s)); }
   if (!strncmp(s, "servername=", 11)) { strcpy(servername, cut_str(s)); }
   if (!strncmp(s, "username=", 9)) { strcpy(username, cut_str(s)); }
   if (!strncmp(s, "gateway=", 8)) { strcpy(gateway, cut_str(s)); }
   if (!strncmp(s, "checkhost{",10)) 
   {
    hosts[hostnum].name[0] = 0;
    hosts[hostnum].email[0] = 0;
    hosts[hostnum].smtpserver[0] = 0;
    hosts[hostnum].stime = 1;
    hosts[hostnum].pingtest = 1;
    hosts[hostnum].portchecktime = 1;
    hosts[hostnum].portchecknum = 0;
    hosts[hostnum].pingtimeout = 10;
    while (strstr(s, "}")==NULL) 
    {
     fgets(s, 1024, conf);
     new_string(s, s);
     if (!strncmp(s, "name=", 5)) { strcpy(hosts[hostnum].name, cut_str(s)); }
     if (!strncmp(s, "email=", 6)) { strcpy(hosts[hostnum].email, cut_str(s)); }
     if (!strncmp(s, "smtpserver=", 11)) { strcpy(hosts[hostnum].smtpserver, cut_str(s)); }
     if (!strncmp(s, "pingtimeout=", 12)) { hosts[hostnum].pingtimeout = atoi(cut_str(s));}
     if (!strncmp(s, "sendalarmtime=", 14)) { hosts[hostnum].stime = atoi(cut_str(s));}
     if (!strncmp(s, "pingtest=", 9)) { hosts[hostnum].pingtest = atoi(cut_str(s)); }
     if (!strncmp(s, "portchecktime=", 14)) { hosts[hostnum].portchecktime = atoi(cut_str(s)); }
     if (!strncmp(s, "portcheck=", 10)) 
     { 
      if (strstr(s, "(") != NULL)  
      while (strstr(s, ")") == NULL) 
      {
       fgets(s, 1024, conf);
       new_string(s, s);
       if (strstr(s, ")") == NULL) 
       {
        dummy = strtok(s, "=");
        hosts[hostnum].portnum[hosts[hostnum].portchecknum] = atoi(dummy);
        strcpy(hosts[hostnum].portname[hosts[hostnum].portchecknum], strtok(NULL, "="));
        hosts[hostnum].portchecknum++;
       }
      }
     }
    }
    notdef[0] = 0;
    if (hosts[hostnum].name[0] == 0) strcat(notdef, "	* name\n");
    if (hosts[hostnum].email[0] == 0) strcat(notdef, "	* email\n");
    if (gateway[0] == 0) strcat(notdef, "	* gateway\n");
    if (sscanf(gateway, "%d.%d.%d.%d", &t, &t, &t, &t) < 4) strcat(notdef, "	* gateway is not in 123.123.123.123 format\n");
    if (hosts[hostnum].smtpserver[0] == 0) strcat(notdef, "	* smtpserver\n");
    if (hosts[hostnum].pingtimeout != 0 && hosts[hostnum].pingtest == 1) strcat(notdef, "	* pingtimeout\n");
    if (hosts[hostnum].pingtest != 1 && hosts[hostnum].pingtimeout == 0) strcat(notdef, "	* pingcommand\n");
    if (hosts[hostnum].stime == 1) strcat(notdef, "	* sendalarmtime\n");
    if (notdef[0] != 0) 
    {
     fprintf(stderr, "The following  problems were detected:\nAt %s :\nNo filed defined or field is bad at:\n%s", hosts[hostnum].name, notdef);
     exit(0);
    } 
    hostnum++;
   }
  }
 }
 notdef[0] = 0;
 if (servername[0] == 0) strcat(notdef, "	* servername\n");
 if (username[0] == 0) strcat(notdef, "	* username\n");
 if (LOCK_DIR[0] == 0) strcat(notdef, "	* lock\n");
 if (logfilename[0] == 0) strcat(notdef, "	* logfile\n");
 if (hostnum == 0) strcat(notdef, "	* checkhost\n");
 if (notdef[0] != 0) {
    fprintf(stderr, "The following GLOBAL problems were detected:\nNo filed defined or field is bad at:\n%s", notdef);
    exit(0);
 } 
 fclose(conf); 
}


/*****************************************************************************/
/*   Log that string into the log file and sign it with a date               */
/*                                                                           */
/*****************************************************************************/
void logit(char *s) {
 FILE *f;
 time_t t;
 char s2[1024], s3[1024];
 t = time(NULL);
 f = fopen(logfilename, "at");
 if (f == NULL) { fprintf(stderr, "FATAL Error while loggig into %s. (errno = %d)\n", logfilename, errno); exit(0);}
 sprintf(s2, "%s", ctime(&t));
 s2[strlen(s2)-1]=0;
 sprintf(s3, "%s	%s", s2, s);
 fprintf(f, "%s\n", s3);
 fclose(f);  
}

