/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glibtop.h>
#include <glibtop/netload.h>
#include <glibtop/close.h>
#include "config.h"
#include "proc.h"

glibtop_netload netload;

procinfo t_procinfos[] = {
/*{ ID, Name,            data pointer           }, */

  {  0, "Packet in",     &netload.packets_in    },
  {  1, "Packet out",    &netload.packets_out   },
  {  2, "Packet in/out", &netload.packets_total },
/* In this applet, byte and packet infos give the same result
  {  3, "Byte in",       &netload.bytes_in      },
  {  4, "Byte out",      &netload.bytes_out     },
  {  5, "Byte in/out",   &netload.bytes_total   },
*/
  {  6, "Collision",     &netload.collisions    },
  {  7, "Error",         &netload.errors_total  },
  { -1, "<null>",        NULL                   },
};
procinfo *procinfos = t_procinfos;

void proc_update(const char *device)
{
	glibtop_get_netload(&netload, device);
}

int proc_get_stat(int iid)
{
	int i;
	for (i=0; procinfos[i].iid != -1; ++i)
	{
		if (iid == procinfos[i].iid)
			return *procinfos[i].value;
	}
	g_error("invalid procinfo id: %d",iid);
	return -1;
}

char *proc_get_name(int iid)
{
	int i;
	for (i=0; procinfos[i].iid != -1; ++i)
	{
		if (iid == procinfos[i].iid)
			return procinfos[i].name;
	}
	g_error("invalid procinfo id: %d",iid);
	return NULL;
}

