!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  pktpriv.inc
!* Purpose: Definitions for packet driver interface
!* Entries: None
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Magic constants for the ethernet interface. The boot rom is presently
! unable to handle anything else than ethernet. Therefore, the default
! class is set to CL_ETHERNET (see below).
!
ETH_ALEN	equ	6			 ! Bytes in one ethernet addr
ETH_FLEN	equ	4			 ! Bytes in FCS
ETH_HLEN	equ	14			 ! Total bytes in header
ETH_DATA_MIN	equ	46			 ! Min. bytes in payload
ETH_DATA_MAX	equ	1500			 ! Max. bytes in payload
ETH_FRAME_MIN	equ	ETH_DATA_MIN + ETH_HLEN	 ! Min. bytes in frame w/o FCS
ETH_FRAME_MAX	equ	ETH_DATA_MAX + ETH_HLEN	 ! Max. bytes in frame w/o FCS
ETH_BUF_SIZE	equ	ETH_FRAME_MAX + ETH_FLEN ! Buffer size includes FCS


!
!**************************************************************************
!
! Miscellaneous equates:
!
PKTINT		equ	$79		! redirected packet driver interrupt
TYPENUM		equ	4		! number of type table entries


!
!**************************************************************************
!
! Packet driver interface classes:
!
CL_NONE		equ	0
CL_ETHERNET	equ	1
CL_PRONET_10	equ	2
CL_IEEE8025	equ	3
CL_OMNINET	equ	4
CL_APPLETALK	equ	5
CL_SERIAL_LINE	equ	6
CL_STARLAN	equ	7
CL_ARCNET	equ	8
CL_AX25		equ	9
CL_KISS		equ	10
CL_IEEE8023	equ	11
CL_FDDI 	equ	12
CL_INTERNET_X25 equ	13
CL_LANSTAR	equ	14
CL_SLFP 	equ	15
CL_NETROM	equ	16
CL_DEFAULT	equ	CL_ETHERNET	! default class (do not change)


!
!**************************************************************************
!
! Packet driver interface types:
!
TYPE_TC500	equ	1
TYPE_PC2000	equ	10
TYPE_WD8003	equ	14
TYPE_PC8250	equ	15
TYPE_ANY	equ	$FFFF
TYPE_DEFAULT	equ	TYPE_ANY	! default type (do not change)


!
!**************************************************************************
!
! Packet driver error return codes:
!
ERR_NO_ERROR		equ	0
ERR_BAD_HANDLE		equ	1	! invalid handle number
ERR_NO_CLASS		equ	2	! no interfaces of specified class
ERR_NO_TYPE		equ	3	! no interfaces of specified type
ERR_NO_NUMBER		equ	4	! no interfaces of specified number
ERR_BAD_TYPE		equ	5	! bad packet type specified
ERR_NO_MULTICAST	equ	6	! interface does not support multicast
ERR_CANT_TERMINATE	equ	7	! packet driver cannot terminate
ERR_BAD_MODE		equ	8	! invalid receiver mode
ERR_NO_SPACE		equ	9	! insufficient space
ERR_TYPE_INUSE		equ	10	! type not released
ERR_BAD_COMMAND		equ	11	! command not implemented
ERR_CANT_SEND		equ	12	! cant send packet (hardware error)
ERR_CANT_SET		equ	13	! cant change hardware address
ERR_BAD_ADDRESS		equ	14	! bad hardware address
ERR_CANT_RESET		equ	15	! couldnt reset interface


!
!**************************************************************************
!
! Packet driver function call numbers. These names and numbers are the
! same as in Appendix B of the packet driver specification:
!
DRIVER_INFO		equ	1	! get information about the interface
ACCESS_TYPE		equ	2	! set packet access type
RELEASE_TYPE		equ	3	! release packet access type
SEND_PKT		equ	4	! send a packet
TERMINATE		equ	5	! terminate packet driver
GET_ADDRESS		equ	6	! get hardware address
RESET_INTERFACE		equ	7	! reset the interface
GET_PARAMETERS		equ	10	! get several driver parameters
AS_SEND_PKT		equ	11	! send packet with upcall
SET_RCV_MODE		equ	20	! set receive mode
GET_RCV_MODE		equ	21	! get receive mode
SET_MULTICAST_LIST	equ	22	! set multicast address list
GET_MULTICAST_LIST	equ	23	! get multicast address list
GET_STATISTICS		equ	24	! get transfer statistics
SET_ADDRESS		equ	25	! set hardware address

