/*
 * makerom.h  -  Main include file for makerom program
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MAKEROM_H_
#define _MAKEROM_H_


/*
 * Size of I/O buffers
 */
#define BLKSIZE		512



/*
 * Definitions used for reading configuration files
 */

/* Network driver options */
#define HW_IRQ		0x0001
#define IO_ADDR		0x0002
#define BASE_MEM	0x0004
#define AUI_TYPE	0x0008
#define DMA_NUM		0x0010

/* Kernel options */
#define K_MINIMAL	0x0001
#define K_X86		0x0002

/* Network driver types */
#define TYPE_NONE	0
#define TYPE_DOS	1
#define TYPE_PD		2
#define TYPE_NDIS	3
#define TYPE_LINUX	4

/* List for program descriptions */
struct desclist {
	char            *progname;
	char		*filename;
	char            *descript;
	char		*cmdline;
	int		 drivertype;
	int              options;
	struct desclist *next;
};



/*
 * Structure used to hold all definitions for one bootrom specification
 */
#define MAXDRIVERS	8		/* maximum number of driver programs */
#define MAXLOADERS	3		/* maximum number of loader programs */

#define OUT_NONE	0		/* no output file type set */
#define OUT_BINARY	1		/* output file as binary */
#define OUT_FLASH	2		/* output file as flash loader */
#define OUT_IHEX	3		/* output file as Intel hex */
#define OUT_MHEX	4		/* output file as Motorola hex */
#define OUT_THEX	5		/* output file as Tektronix hex */

#define OUT_MIN		1		/* lowest usable output file type */
#define OUT_MAX		5		/* highest usable output file type */

struct bootdef {
	char *name;			/* name of bootrom description */
	char *kernelname;		/* name of kernel file */
	char *loadernames[MAXLOADERS];	/* names of loader binaries */
	char *outnames[MAXLOADERS];	/* names of output files */
	int outtypes[MAXLOADERS];	/* types of output files */
	int loadernum;			/* number of loader programs */
	char *drivernames[MAXDRIVERS];	/* names of driver programs */
	char *driverargs[MAXDRIVERS];	/* command lines of driver programs */
	int drivertypes[MAXDRIVERS];	/* types of driver programs */
	int drivernum;			/* number of driver programs */
	int use_int18;			/* nonzero if we should use int 18h */
};



/*
 * Global variables
 */
extern char *drtype[];			/* array of names with driver types */
extern char *kerneldir;			/* directory with kernel binaries */
extern char *loaderdir;			/* directory with loader binaries */
extern char *netdrvdir;			/* directory with network drivers */
extern char *utilsdir;			/* utilities directory */
extern struct desclist *kerneldesc;	/* list of kernel descriptions */
extern struct desclist *netdrvdesc;	/* list of network driver descriptions */



/*
 * Data area which holds the EXE program loader
 */
extern unsigned char execom_data[];
extern unsigned int execom_data_size;



/*
 * External routines
 */
extern int doread __P((unsigned char *buf, unsigned int bufsize, int infile));
extern int dowrite __P((unsigned char *buf, unsigned int bufsize, int outfile));
extern struct bootdef *getdb __P((char *name));
extern struct bootdef *getuser __P((void));
extern void pass1 __P((struct bootdef *bp, int tempfile));
extern void pass2 __P((struct bootdef *bp, int kernfile, int loader));
extern void makeflash __P((char *outname, int tempfile));
extern void makeihex __P((char *outname, int tempfile));
extern void makemhex __P((char *outname, int tempfile));
extern void makethex __P((char *outname, int tempfile));
extern unsigned long freeze __P((int infile, int outfile));


#endif

