/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  netinit.c
 * Purpose: Initialize the network module
 * Entries: init_net, if_config
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <general.h>
#include <net.h>
#include <romlib.h>
#include "./netpriv.h"
#include "./udp.h"
#include "./ip.h"
#include "./arp.h"



/*
 **************************************************************************
 * 
 * Global variables for the network library
 *
 */
unsigned char     myhwaddr[ETH_ALEN];		/* my own hardware addr	*/
         t_ipaddr myipaddr;			/* my own IP address	*/
         t_ipaddr mynetmask;			/* my own netmask	*/
         char    *net_module_name;		/* name of init module	*/

/* Broadcast hardware address */
unsigned char bcasthw[ETH_ALEN] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };



/*
 **************************************************************************
 * 
 * Interface configuration: sets all IP addresses which are related to
 * a specific interface.
 */
void if_config(myip, netmask)
t_ipaddr myip;
t_ipaddr netmask;
{
  /* Adjust netmask if none given */
  if (netmask == IP_ANY) {
	if (IN_CLASS_A(myip))
		netmask = IP_CLASS_A;
	else if (IN_CLASS_B(myip))
		netmask = IP_CLASS_B;
	else if (IN_CLASS_C(myip))
		netmask = IP_CLASS_C;
  }

  /* Now set the interface values */
  myipaddr  = myip;
  mynetmask = netmask;
}



/*
 **************************************************************************
 * 
 * Get hardware address
 */
void get_hw_addr(hwaddr)
unsigned char *hwaddr;
{
  memcpy(hwaddr, myhwaddr, ETH_ALEN);
}



/*
 **************************************************************************
 * 
 * Network intialization:
 */
void init_net()
{
  /* Initialize the different network layer modules */
  init_packet();
  if (!init_arp() || !init_udp()) {
	printf("\nERROR: init_%s\n", net_module_name);
	fatal();
  }
}

