#ifndef __NWNET_I_H__
#define __NWNET_I_H__

#include "config.h"

#include <ncp/nwnet.h>
#include "private/list.h"
/*
#include <unicode.h>
*/
typedef u_int16_t unicode;

#ifdef HAVE_WCHAR_H
#include <wchar.h>
#else
int	 wcscmp(const wchar_t*, const wchar_t*);
int      wcsncmp(const wchar_t*, const wchar_t*, size_t);
int	 wcscasecmp(const wchar_t*, const wchar_t*);
int	 wcsncasecmp(const wchar_t*, const wchar_t*, size_t);
wchar_t* wcscpy(wchar_t*, const wchar_t*);
size_t   wcslen(const wchar_t*);
wchar_t* wcsdup(const wchar_t*);
#endif

#ifdef HAVE_ICONV_H
#include <iconv.h>
#endif

typedef struct {
#define MY_ICONV_INTERNAL	0
#define MY_ICONV_LIBC		1
	int	type;
	union {
#ifdef HAVE_ICONV_H
		iconv_t h;
#endif
		int (*proc)(const char** fa, size_t* fl, char** ta, size_t* tl);
	} lowlevel;
} *my_iconv_t;

my_iconv_t my_iconv_open(const char* a, const char* b);
int my_iconv_close(my_iconv_t handle);
int my_iconv(my_iconv_t, const char** fa, size_t* fl, char** ta, size_t* tl);

typedef struct NWDSConnection {
	struct {
		wchar_t	*tree_name;
			      } dck;
	struct list_head	conns;
	struct list_head	contexts;
} *NWDS_HANDLE;

struct RDNInfo {
	struct RDNEntry*	end;
	size_t			depth;
};

#define DCK_RDN		6	/* internal flag for NWDSGetContext */

struct __NWDSContextHandle {
	struct {
		nuint32		flags;
		nuint32		confidence;
		struct {
		NWCONN_HANDLE	conn;
		u_int32_t	state;
		              } last_connection;
		char*		local_charset;
		nuint32		name_form;
		size_t		transports;
		nuint32*	transport_types;
		struct RDNInfo	rdn;
		wchar_t*	namectx;
		      } dck;
	struct {
		my_iconv_t	to;
		my_iconv_t	from;
		      } xlate;
	NWDS_HANDLE		ds_connection;
	struct list_head	context_ring;
};

#endif	/* __NWNET_I_H__ */

