/*
 *  abbrev.c
 *
 *  Abbreviates object name
 *  NWDSAbbreviate API demo
 *
 *  Copyright (C) 1999 by Petr Vandrovec
 *
 */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <wchar.h>

#include <libintl.h>
#define _(X) gettext(X)

#include <ncp/nwnet.h>

static char *progname;

static void
usage(void)
{
	fprintf(stderr, _("usage: %s [options]\n"), progname);
}

static void
help(void)
{
	printf(_("\n"
	         "usage: %s [options]\n"), progname);
	printf(_("\n"
	       "-h              Print this help text\n"
	       "-v flag         Context DCK_FLAGS value\n"
	       "-o object_name  Name of object\n"
	       "-c context_name Name of current context\n"
	       "\n"));
}

int main(int argc, char *argv[]) {
	NWDSCCODE dserr;
	NWDSContextHandle ctx;
	char* objectname = "[Root]";
	char* context = "OrgUnit.Org.Country";
	char canoned[1000];
	int opt;
	u_int32_t ctxflag = 0;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	progname = argv[0];

	NWCallsInit(NULL, NULL);
	NWDSInitRequester();
	
	dserr = NWDSCreateContextHandle(&ctx);
	if (dserr) {
		fprintf(stderr, "NWDSCretateContextHandle failed with %s\n", strnwerror(dserr));
		return 123;
	}
	while ((opt = getopt(argc, argv, "h?o:c:v:")) != EOF)
	{
		switch (opt)
		{
		case 'o':
			objectname = optarg;
			break;
		case 'c':
			context = optarg;
			break;
		case 'v':
			ctxflag = strtoul(optarg, NULL, 0);
			break;
		case 'h':
		case '?':
			help();
			goto finished;
		default:
			usage();
			goto finished;
		}
	}

	ctxflag |= DCV_XLATE_STRINGS;
	
	dserr = NWDSSetContext(ctx, DCK_FLAGS, &ctxflag);
	if (dserr) {
		fprintf(stderr, "NWDSSetContext(DCK_FLAGS) failed: %s\n",
			strnwerror(dserr));
		return 123;
	}
	dserr = NWDSSetContext(ctx, DCK_NAME_CONTEXT, context);
	if (dserr) {
		fprintf(stderr, "NWDSSetContext(DCK_NAME_CONTEXT) failed: %s\n",
			strnwerror(dserr));
		return 122;
	}
	
	dserr = NWDSAbbreviateName(ctx, objectname, canoned);
	if (dserr) {
		fprintf(stderr, "NWDSAbbreviateName failed with %s\n", 
			strnwerror(dserr));
	} else {
		printf("Abbreviated: '%s'\n", canoned);
	}

	dserr =  NWDSFreeContext(ctx);
	if (dserr) {
		fprintf(stderr, "NWDSFreeContext failed with %s\n", strnwerror(dserr));
		return 121;
	}
finished:
	return 0;
}
	
