/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_info_var (const char *var)
{
	char temp[1024];

	config_getvalue(var, temp, 1024);
	fprintf(outsock, "%s\n", temp);
}

void mserver_info_file (const char *filevar)
{
	FILE *tfile;
	char temp[1024];

	config_getvalue(filevar, temp, 1024);

	tfile = fopen(temp, "r");

	if (tfile == NULL)
	{
		fprintf(outsock, "ERROR: Can not open %s file: %s\n", filevar, temp);
	}
	else
	{
		fprintf(outsock, "BEGIN\n");

		while (fgets(temp, 1024, tfile))
		{
			fprintf(outsock, "%s", temp);
		}
		fclose(tfile);

		fprintf(outsock, "\nEND\n");
	}
}
