/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_cinfo (const char *cname)
{
	char value[1024];

	fprintf (outsock,"BEGIN\n");

	if (!find_cname(cname))
	{
		fprintf(outsock, "ERROR: Unknown connection!\n");
		return;
	}

	fprintf(outsock, "NAME: %s\n", cname);

	config_getvalue_cname_specified("info", value, cname, 1024);
	fprintf(outsock, "INFO: %s\n", value);

	config_getvalue_cname_specified("script", value, cname, 1024);
	fprintf(outsock, "SCRIPT: %s\n", value);

	config_getvalue_cname_specified("kill", value, cname, 1024);
	fprintf(outsock, "KILL: %s\n", value);

	config_getvalue_cname_specified("ipallow", value, cname, 1024);
	fprintf(outsock, "VALID ADDRESSES: %s\n", value);

	config_getvalue_cname_specified("userallow", value, cname, 1024);
	fprintf(outsock, "VALID USERS: %s\n", value);
	
	config_getvalue_cname_specified("userallow_connect", value, cname, 1024);
	fprintf(outsock, "VALID USERS (CONNECT): %s\n", value);

	config_getvalue_cname_specified("userallow_disconnect", value, cname, 1024);
	fprintf(outsock, "VALID USERS (DISCONNECT): %s\n", value);

	config_getvalue_cname_specified("userallow_config", value, cname, 1024);
	fprintf(outsock, "VALID USERS (CONFIG): %s\n", value);

	fprintf(outsock,"END\n");
}
