#include "links.h"

void sig_intr(struct terminal *t)
{
	exit_prog(t, NULL, NULL);
}

void sig_terminate(struct terminal *t)
{
	terminate = 1;
}

void sig_tstp(struct terminal *t)
{
	block_itrm(0);
#ifdef SIGSTOP
	raise(SIGSTOP);
#endif
}

void sig_cont(struct terminal *t)
{
	unblock_itrm(0);
	redraw_terminal_cls(t);
}

void handle_basic_signals(struct terminal *term)
{
	install_signal_handler(SIGHUP, (void (*)(void *))sig_intr, term, 0);
	install_signal_handler(SIGINT, (void (*)(void *))sig_intr, term, 0);
	install_signal_handler(SIGTERM, (void (*)(void *))sig_terminate, term, 0);
#ifdef SIGTSTP
	install_signal_handler(SIGTSTP, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTIN
	install_signal_handler(SIGTTIN, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTOU
	install_signal_handler(SIGTTOU, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGCONT
	install_signal_handler(SIGCONT, (void (*)(void *))sig_cont, term, 0);
#endif
}

int attach_terminal(int in, int out, void *info, int len)
{
	struct terminal *term;
	int fd[2];
	if (c_pipe(fd)) {
		mem_free(info);
		error("ERROR: can't create pipe for internal communication");
		return -1;
	}
	fcntl(fd[0], F_SETFL, O_NONBLOCK);
	fcntl(fd[1], F_SETFL, O_NONBLOCK);
	handle_trm(in, out, out, fd[1], info, len);
	mem_free(info);
	if ((term = init_term(fd[0], out, win_func))) {
		handle_basic_signals(term);
		return fd[1];
	}
	close(fd[0]);
	close(fd[1]);
	return -1;
}

int ac;
unsigned char **av;

unsigned char *path_to_exe;

void init()
{
	void *info;
	int len;
	unsigned char *u;
	set_sigcld();
	if ((assume_cp = get_cp_index("ISO-8859-1")) == -1) assume_cp = 0;
	init_home();
	load_config();
	u = parse_options(ac - 1, av + 1);
	if (!u) {
		terminate = 1;
		return;
	}
	if (!((info = create_session_info(0, u, &len)) && attach_terminal(get_input_handle(), 1, info, len) != -1)) terminate = 1;
}

void terminate_all_subsystems()
{
	destroy_all_sessions();
	abort_all_downloads();
	destroy_all_terminals();
	check_bottom_halves();
	free_all_itrms();
	abort_all_connections();
	shrink_memory(1);
	free_history_lists();
	free_term_specs();
	free_types();
	free_conv_table();
	free_blacklist();
	check_bottom_halves();
	end_config();
}

int main(int argc, char *argv[])
{
	path_to_exe = argv[0];
	ac = argc;
	av = (unsigned char **)argv;
	select_loop(init);
	terminate_all_subsystems();

	check_memory_leaks();
	return 0;
}

void shrink_memory(int u)
{
	shrink_dns_cache(u);
	shrink_format_cache(u);
	garbage_collection(u);
	delete_unused_format_cache_entries();
}
