;;; llunf.el --- function overloading facilities
;; Copyright (C) 1998, 1999 Daiki Ueno

;; Author: Daiki Ueno <ueno@ueda.info.waseda.ac.jp>
;; Created: 1999-06-05

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(defmacro llunf-make-obarray (backend)
  `(defvar ,(intern (format "llunf-%s-obarray" backend))
     (make-vector 107 0)))

(defmacro llunf-obarray (backend)
  `(symbol-value (intern-soft (format "llunf-%s-obarray" ,backend))))

(defun llunf-override-function-definition (name backend args function)
  (let ((ref (symbol-name (gensym))))
    (if (symbolp name)
	(setq name (symbol-name name)))
    (put (intern name (llunf-obarray backend)) 'unifiers
	 (nconc (get (intern name (llunf-obarray backend)) 'unifiers)
		(list `(,(intern ref (llunf-obarray backend)) ,@args))))
    (fset (intern ref (llunf-obarray backend)) function)))

(defun llunf-unify-argument-list-function (args unifiers)
  (let ((index 0) 
	(unfs (copy-alist unifiers))
	(len (length args))
	type)
    (setq unfs (remove-if `(lambda (unf) (/= (length (cdr unf)) ,len))
			  unfs))

    (dolist (arg args)
      (if (listp arg)
	  (setq unfs (remove-if-not 
		      `(lambda (unf)
			 (let ((spec (nth ,index (cdr unf))))
			   (or (not (listp spec))
			       (eq (car spec) (car arg)))))
		      unfs)))
      (incf index))
    (if (caar unfs)
	(symbol-function (caar unfs)))))

(defmacro llunf-define-backend (type &optional parents)
  `(llunf-make-obarray ,type))

(defun llunf-find-function (name args backend)
  (let* ((fsym (intern-soft name (llunf-obarray backend)))
	 (unifiers (if fsym (get fsym 'unifiers))))
    (llunf-unify-argument-list-function args unifiers)))

(defun llunf-define-function (name specs function)
  (let ((args (butlast specs))
	(backend (car (last specs))))
    (llunf-override-function-definition name backend args function)
    ))

(provide 'llunf)

;;; llunf.el ends here
