#ifndef __UI_KEYBOARD_H
#define __UI_KEYBOARD_H

typedef struct
{
    gchar *id;
    gchar *description;

    GList *keys;
}
KEYINFO_REC;

typedef struct
{
    KEYINFO_REC *info;

    gchar *key;
    gpointer data;
}
KEY_REC;

extern GList *keyinfos;

void key_bind(gchar *id, gchar *data, gchar *description, gchar *key_default, SIGNAL_FUNC func);
void key_unbind(gchar *id, SIGNAL_FUNC func);

void key_configure_add(gchar *id, gchar *data, gchar *key);
void key_configure_remove(gchar *key);

KEYINFO_REC *key_info_find(gchar *id);
gboolean key_pressed(gchar *key, gpointer data);

void keyboard_save(void);

void ui_keyboard_init(void);
void ui_keyboard_deinit(void);

#endif
