#ifndef __NETWORK_H
#define __NETWORK_H

void net_init(void);
void net_deinit(void);

/* Connect to socket with host name */
gint net_connect(gchar *addr, gint port, IPADDR *my_ip);
/* Connect to socket with ip address */
gint net_connect_ip(IPADDR *ip, gint port, IPADDR *my_ip);
/* Disconnect socket */
void net_disconnect(gint fh);
/* Assume that the other side closes the socket -
   wait for it, or eventually timeout and close it.. */
void net_disconnect_later(gint fh);

/* Listen for connections on a socket */
gint net_listen(IPADDR *my_ip, gint *port);
/* Accept a connection on a socket */
gint net_accept(gint handle, IPADDR *addr, gint *port);

/* Read data from socket */
gint net_receive(gint fh, gchar *buf, gint len);
/* Transmit data (blocking) */
gint net_transmit(gint fh, gchar *data, gint len);
/* Transmit data (nonblocking) */
gint net_transmit_nonblock(gint fh, gchar *data, gint len);

/* Get socket address/port */
gint net_getsockname(gint handle, IPADDR *addr, gint *port);

/* Get IP address for host, returns -1 if failed */
gint net_gethostname(gchar *addr, IPADDR *ip);

gulong net_long2net(gulong num);
gulong net_net2long(gulong num);
gchar *net_ip2host(IPADDR *ip);
IPADDR *net_host2ip(gchar *host);

gint net_geterror(gint handle);
gchar *net_gethosterror(void);

#endif
