#ifndef __MISC_H
#define __MISC_H

gint read_line(gboolean socket, gint handle, GString *output, GString *buffer);

gboolean copyfile(gchar *src, gchar *dest);
gint execute(gchar *cmd); /* returns -1 = error or pid */

gboolean find_substr(gchar *list, gchar *item);

/* You'll need to g_free() only the first element of the returned GList* */
GList *str2list(gchar *list, gchar sep);
gchar *list2str(GList *list, gchar *sep);

GList *glist_find_string(GList *list, gchar *key);
GList *glist_find_icase_string(GList *list, gchar *key);
gchar *stristr(gchar *data, gchar *key);

gchar *convert_home(gchar *path);

gboolean match_wildcards(gchar *mask, gchar *data);

/* count can have these flags: */
#define PARAM_WITHOUT_FLAGS(a) ((a) & 0xfffffff)
/* cmd_get_params() */
#define PARAM_FLAG_OPTCHAN 0x10000000
/* event_get_params(), put rest of the text to last parameter */
#define PARAM_FLAG_GETREST 0x20000000
/* optional arguments (-cmd -cmd2 -cmd3) */
#define PARAM_FLAG_OPTARGS 0x40000000

/* Get count parameters from data */
gchar *event_get_param(gchar **data);
gchar *event_get_params(gchar *data, gint count, ...);

/* Get parameters from data, if channel is TRUE, the first parameter is
   optional channel */
gchar *cmd_get_param(gchar **data);
gchar *cmd_get_params(gchar *data, gint count, ...);

/* hash functions for case-ignored strings */
gint g_istr_equal (gconstpointer v, gconstpointer v2);
guint g_istr_hash (gconstpointer v);

#endif
