/*
 setup-completion.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static gboolean sig_setup_apply(void)
{
    setup_write("completion", completion_options);
    return TRUE;
}

static GtkWidget *create_spin(GtkWidget *box, GtkAdjustment *adj, gchar *prefix, gchar *suffix, SETUP_REC *option)
{
    GtkWidget *hbox, *label, *spin;

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(prefix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    spin = gtk_spin_button_new(adj, 0, 0);
    option->widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    label = gtk_label_new(suffix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    return spin;
}

static gboolean setup_completion(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *vbox, *frame, *spin, *checkbox, *entry;
    GtkAdjustment *adj;

    g_return_val_if_fail(dialog != NULL, FALSE);

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    frame = gtk_frame_new(_("Nick Completion"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Disable automatic nick completion"));
    completion_options[OPTION_COMPLETION_DISABLE_AUTO].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    entry = gui_create_labelentry(vbox, _("Completion character"),
                                  *((gchar **) completion_options[OPTION_COMPLETION_CHAR].data), FALSE);
    gtk_entry_set_max_length(GTK_ENTRY(entry), 1);
    completion_options[OPTION_COMPLETION_CHAR].widget = entry;

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) completion_options[OPTION_COMPLETION_KEEP_PUBLICS].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Remember public messages for"), _("seconds"), &completion_options[OPTION_COMPLETION_KEEP_PUBLICS]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) completion_options[OPTION_COMPLETION_KEEP_OWNPUBLICS].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Remember public messages to you for"), _("seconds"), &completion_options[OPTION_COMPLETION_KEEP_OWNPUBLICS]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) completion_options[OPTION_COMPLETION_KEEP_PRIVATES].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Remember the last"), _("private messages"), &completion_options[OPTION_COMPLETION_KEEP_PRIVATES]);

    setup_finish_init(dialog, completion_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("Nick Completion")));
    return TRUE;
}

void init_completion(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_completion);
}

void deinit_completion(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_completion);
}
