#ifndef __GUI_H
#define __GUI_H

enum
{
    DIALOG_OK,
    DIALOG_ERROR,
    DIALOG_WARNING,
};

void gui_init(void);
void gui_deinit(void);

/* Create dialog with label and close button */
void gui_dialog(gint type, gchar *labeltext, ...);

/* Create dialog with entry field */
GtkWidget *gui_entry_dialog(gchar *labeltext, gchar *defaultentry, gchar *history, GtkSignalFunc okfunc, gpointer data);

/* Create text entry with label */
GtkWidget *gui_create_labelentry(GtkWidget *box, gchar *text, gchar *field, gboolean fill);
GtkWidget *gui_create_tablelabelentry(GtkWidget *table, gint xpos, gint ypos, gchar *text, gchar *field);

gchar *gui_key2str(GdkEventKey *event);

#endif
