/*
Copyright (C) 1997,1998  Ong Lon Voon <rarf@ddns.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-------------------------------------
Email bugs, comments to rarf@ddns.org
-------------------------------------
*/

#include "lib.h"

char * xcrypt(char * key, long len)
{
  char salt[5];
  char buf[BUFLEN];

  sprintf(buf,"%x",len);
  len=strtoul(buf+6,NULL,16);
  *(buf+6)='\0';
  len+=strtoul(buf+4,NULL,16);
  *(buf+4)='\0';
  len+=strtoul(buf+2,NULL,16);
  *(buf+2)='\0';
  len+=strtoul(buf,NULL,16);
  len%=0xff;
  sprintf(salt,"%x",len);
  return((char *)crypt(key,salt));
}

char * strtoupper(char * buf)
{
  for (;*buf!=0;buf++) {
    if (islower(*buf)) {
      *buf=toupper(*buf);
    }
  }
  return(buf);
}

char * strtolower(char * buf)
{
  for (;*buf!=0;buf++) {
    if (isupper(*buf)) {
      *buf=tolower(*buf);
    }
  }
  return(buf);
}

char * strtodomain(char * buf)
{
  char * domain=(char *)malloc(BUFLEN);
  char * token;
  int i;

  i=0;
  token=strtok(buf,".");
  while (token!=NULL) {
    *(domain+i)=strlen(token);
    i++;
    strcpy(domain+i,token);
    i+=strlen(token);
    token=strtok(NULL,".");
  }
  *(domain+i)='\0';
  return domain;
}

/*
unsigned long GetServerAddr (char *Server)
{
  struct hostent *hp;
  struct in_addr addr;

  if (inet_aton(Server,&addr)==0) {
    if ((hp = gethostbyname (Server)) == NULL) {
      perror("server gethostbyname() failed");
      return(0);
    }
    addr=*((struct in_addr *)hp->h_addr);
  }

  return addr.s_addr;
}
*/

int strip(char * buf)
{
  if (strlen(buf)<=0) {
    return(0);
  }
  while ((*(buf+strlen(buf)-1)=='\n')||(*(buf+strlen(buf)-1)=='\r')) {
    *(buf+strlen(buf)-1)='\0';
  }
}

/*
static int GetLine (int fd, char *buf, int len)
{
  int  i;
  int  rc;
  char c;

  for (i = 0; i < len; ++i) {
    if ((rc = read (fd, &c, 1)) == 1) {
      *buf++ = c;
      if (c == '\n')
	break;
    }
    else if (rc == 0) {
      if (i == 1)
	return 0;
      else
	break;
    }
    else {
      return -1;
    }
  }
  
  *buf = 0;
  return i;
}
*/

/*
int ping(char * server, char * payload, int duration)
{
  int fd;
  static struct sockaddr_in serv_addr;
  struct hostent * serv_ent;
  struct in_addr addr;
  int status;
  int len;
  char buf[BUFLEN];

  fd=socket(AF_INET,SOCK_RAW,1);
  if (fd<0) {
perror("client icmp socket() call failed");
    return(-2);
  }
  fcntl(fd,F_SETFL,O_NONBLOCK);

  bzero((void *)&serv_addr,sizeof(serv_addr));
  serv_addr.sin_family=AF_INET;
  serv_ent=gethostbyname(server);
  if (serv_ent==NULL) {
    serv_ent=gethostbyaddr(server,strlen(server),AF_INET);
    if (serv_ent==NULL) {
perror("gethostbyname");
      return(2);
    }
  }
  addr=*((struct in_addr *)serv_ent->h_addr);
  serv_addr.sin_addr.s_addr=addr.s_addr;

  len=sizeof(struct sockaddr_in);
  strncpy(buf,payload,BUFLEN);
  sendto(fd,buf,strlen(buf),0,(struct sockaddr *)&serv_addr,len);
  sleep(duration);
  while (1) {
    status=recvfrom(fd,buf,BUFLEN,0,(struct sockaddr *)&serv_addr,&len);
    if (status==-1) {
      if (errno==EWOULDBLOCK) {
perror("EWOULDBLOCK");
        return(1);
      }
      else {
perror("error");
        return(-1);
      }
    }
    else {
      if (status==(20+strlen(payload))) {
        return(0);
      }
    }
  }
}
*/
