/**************************************************************************** 
** File: ipxrip.c
**
** Author: Mike Borella
**
** Comments: Dump IPX/RIP header information
**
** $Log: ipxrip.c,v $
** Revision 1.2  1998/06/12 21:01:09  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "config.h"
#include "ipxrip.h"

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_ipxrip()
**
** Parse IPX/RIP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_ipxrip(u_char *bp, u_int16_t length)
{
  IPXRIPhdr *rip;
  RIPentry *e;
  int i, numentries;

  /*
   * Check length
   */

  if (length < sizeof(IPXRIPhdr))
    {
      printf("Truncated header, length = %d bytes\n", length);
      return;
    }

  /*
   * Dump header announcement
   */

  printf("-----------------------------------------------------------------\n");
  printf("                        IPX RIP Entries\n");
  printf("-----------------------------------------------------------------\n");

  /*
   * View the packet as an IPX/RIP header
   */

  rip = (IPXRIPhdr *) bp;

  /*
   * Dump header fields
   */
  
  if (!my_args->t)
    {
      printf("Operation               %d ", ntohs(rip->op));
      switch(ntohs(rip->op))
	{
	case 1:
	  printf("(request)\n");
	  break;
	case 2:
	  printf("(response)\n");
	  break;
	default:
	  printf("(unknown)\n");
	  break;
	}

      rip += sizeof(IPXRIPhdr);
      numentries = (length-sizeof(IPXRIPhdr)) / sizeof(RIPentry);
      for (i=1; i<=numentries; i++)
	{
	  printf("RIP entry %d:\n", i);
	  e = (RIPentry *) rip;
	  printf("    network number      %x\n", e->net);
	  printf("    hops                %d\n", e->hops);
	  printf("    ticks               %d\n", e->ticks);
	  if (i < numentries)
	    rip += sizeof(RIPentry);
	}
    } /* if */

}


