/***********************************
 Send various packets to the server
 (c) 1999 Jeremy Wise
 GnomeICU
************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>
#include <string.h>

int preset_status = STATUS_OFFLINE;

/*** Global functions ***/
/*
 * This function is called every 2 minutes
 * so that the server doesn't force disconnect
 */
void Keep_Alive( void )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "Keep_Alive\n" );
#endif

	if( !enable_online_events )
		return;

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_KEEP_ALIVE );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
   
	SOCKWRITE( &(pak.head.ver), sizeof( pak.head ) + 2, "CMD_KEEP_ALIVE" );
}

void Recv_Message( srv_net_icq_pak pak )
{
	RECV_MESSAGE_PTR r_mesg;
	struct tm *msg_time;

#ifdef TRACE_FUNCTION
	g_print( "Recv_Message\n" );
#endif

	msg_time = g_new0( struct tm, 1 );

	r_mesg = ( RECV_MESSAGE_PTR )pak.data;
	last_recv_uin = Chars_2_DW( r_mesg->uin );

	msg_time->tm_year = Chars_2_Word( r_mesg->year ) - 1900;
	msg_time->tm_mon = r_mesg->month - 1;
	msg_time->tm_mday = r_mesg->day;
	msg_time->tm_min = r_mesg->minute;
	msg_time->tm_hour = r_mesg->hour;

	Do_Msg( mktime( msg_time ) + (our_info->c_status * 36), Chars_2_Word( r_mesg->type ), ( r_mesg->len + 2 ), last_recv_uin, MESSAGE_TEXT );
}

/*
 * This is called to remove messages
 * from the server
 */
void snd_got_messages( void )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "snd_got_messages\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_ACK_MESSAGES );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );

	SOCKWRITE( &(pak.head.ver), sizeof( pak.head ) + 2, "CMD_ACK_MESSAGES" );
}

/* Sends contact list */
void snd_contact_list( void )
{
	net_icq_pak pak;
	int num_used;
	int size;
	char *tmp;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "snd_contact_list\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_CONT_LIST );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
	tmp = pak.data;
	tmp++;

	contact = Contacts;
	num_used = 0;

	while( contact != NULL )
	{
		if ( (S_DWORD) ((CONTACT_PTR)contact->data)->uin > 0 )
		{
			DW_2_Chars( tmp, ((CONTACT_PTR)contact->data)->uin );
			tmp += 4;
			num_used++;
		}
		if( num_used == 100 )
		{
			pak.data[0] = num_used;
			size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
			size += sizeof( pak.head ) - 2;
			SOCKWRITE( &( pak.head.ver ), size, "CMD_CONT_LIST" );
			num_used = 0;
			tmp = pak.data;
			tmp++;

		}
		contact = contact->next;
	}

	if( num_used )
	{
		pak.data[0] = num_used;
		size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
		size += sizeof( pak.head ) - 2;

		SOCKWRITE( &( pak.head.ver ), size, "CMD_CONT_LIST" );
	}
}

/* Send second login command to finish logging in */
void snd_login_1( void )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "snd_login_1\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_LOGIN_1 );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
   
	SOCKWRITE( &(pak.head.ver), sizeof( pak.head ) + 2, "CMD_LOGIN_1" );

	if( is_new_user )
		change_info_window( NULL, NULL );
}

/* Called when user goes Offline */
void User_Offline( srv_net_icq_pak pak )
{
	int remote_uin;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "User_Offline\n" );
#endif

	remote_uin = pak.data[3];
	remote_uin <<=8;
	remote_uin += pak.data[2];
	remote_uin <<=8;
	remote_uin += pak.data[1];
	remote_uin <<=8;
	remote_uin += pak.data[0];

	contact = Contacts;
	
	while( contact != NULL )
	{
		if( remote_uin == ((CONTACT_PTR)contact->data)->uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	log_window_add( _("Logout"), remote_uin );

	((CONTACT_PTR)contact->data)->status = STATUS_OFFLINE;
	((CONTACT_PTR)contact->data)->true_status = STATUS_OFFLINE;
	((CONTACT_PTR)contact->data)->last_time = time( NULL );
	((CONTACT_PTR)contact->data)->have_tcp_connection = FALSE;

	Show_Quick_Status();

	if( toggles->applet )
		applet_update( Current_Status, NULL );
}

void User_Online( srv_net_icq_pak pak )
{
	UIN_T remote_uin = 0;
	gint new_status = 0;

	GSList *contact;
	gchar *notify;

#ifdef TRACE_FUNCTION
	g_print( "User_Online\n" );
#endif

/**************************************
dw uin
dw ip
word pord
word zero
dw ip
byte 04/06
dw status
word TCP version
**************************************/

	remote_uin = Chars_2_DW( &pak.data[0] );

	new_status = Chars_2_DW( &pak.data[17] );

	contact = Contacts;

	while( contact != NULL )
	{
		if( remote_uin == ((CONTACT_PTR)contact->data)->uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;
   
	log_window_add( _("Login"), remote_uin );

	if( enable_online_events && ((CONTACT_PTR)contact->data)->online_notify &&
	    !((CONTACT_PTR)contact->data)->ignore_list )
	{
		notify = g_strdup_printf( "%s is online",
		                          ((CONTACT_PTR)contact->data)->nick );
		gtk_widget_show( gnome_message_box_new( _( notify ),
		                 GNOME_MESSAGE_BOX_INFO,
		                 GNOME_STOCK_BUTTON_OK,
		                 NULL ) );
		g_free( notify );
	}

	((CONTACT_PTR)contact->data)->status = new_status;
	((CONTACT_PTR)contact->data)->true_status = Chars_2_DW( &pak.data[17] );
	((CONTACT_PTR)contact->data)->force = pak.data[16];
	((CONTACT_PTR)contact->data)->current_ip = IP_2_DW( &pak.data[4] );
	((CONTACT_PTR)contact->data)->port = Chars_2_DW( &pak.data[8] );
	((CONTACT_PTR)contact->data)->last_time = time( NULL );

	if( !Done_Login )
	{
		((CONTACT_PTR)contact->data)->status = new_status;
		((CONTACT_PTR)contact->data)->current_ip = g_ntohl( Chars_2_DW( &pak.data[4] ) );
		((CONTACT_PTR)contact->data)->port = Chars_2_DW( &pak.data[8] );
		((CONTACT_PTR)contact->data)->last_time = time( NULL );
	}
                                                                                                                                                
	Show_Quick_Status();

	if( toggles->applet )
		applet_update( Current_Status, NULL );
}

void Status_Update( srv_net_icq_pak pak )
{
	gchar buf[64];
	gchar sts[ 64 ];
	UIN_T remote_uin;
	gint new_status;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Status_Update\n" );
#endif

	remote_uin = pak.data[3];
	remote_uin <<=8;
	remote_uin += pak.data[2];
	remote_uin <<=8;
	remote_uin += pak.data[1];
	remote_uin <<=8;
	remote_uin += pak.data[0];

	new_status = pak.data[7];
	new_status <<=8;
	new_status += pak.data[6];
	new_status <<=8;
	new_status += pak.data[5];
	new_status <<=8;
	new_status += pak.data[4];

	contact = Contacts;
	
	while( contact != NULL )
	{
		if( remote_uin == ((CONTACT_PTR)contact->data)->uin )
			break;
		contact = contact->next;
	}
	
	if( contact == NULL )
		return;

	((CONTACT_PTR)contact->data)->true_status = new_status;

	new_status = new_status & 0x01ff;

	if( new_status == STATUS_OCCUPIED_MAC )
		new_status = STATUS_OCCUPIED;
	if( new_status == STATUS_NA_99A )
		new_status = STATUS_NA;

	if ( new_status == STATUS_OFFLINE ) /* this because -1 & 0xFFFF is not -1 */
	{
		strcpy( sts, _("Offline") );
	}
   
	switch ( new_status & 0xffff )
	{
		case STATUS_ONLINE:
			strcpy( sts,  _("Online") );
			break;
		case STATUS_DND:
			strcpy( sts, _("Do Not Disturb") );
			break;
		case STATUS_AWAY:
			strcpy( sts, _("Away") );
			break;
		case STATUS_OCCUPIED:
			strcpy( sts, _("Occupied") );
			break;
		case STATUS_NA:
			strcpy( sts, _("Not Available") );
			break;
		case STATUS_INVISIBLE:
			strcpy( sts, _("Invisible") );
			break;
		case STATUS_FREE_CHAT:
			strcpy( sts, _("Free for Chat") );
			break;
		default:
			strcpy( sts, "" );
			break;
	}

	sprintf( buf, _("Status Change: %s"), sts );
	log_window_add( buf, remote_uin );

	((CONTACT_PTR)contact->data)->status = new_status;

	if( toggles->applet )
		applet_update( Current_Status, NULL );
}


/*
 * Login with UIN and password.
 * Gives IP and Port
 * Does NOT wait for any kind of response
 */
void Login( char *pass, int ip, int port )
{
	net_icq_pak pak;
	int size;
	login_1 s1;
	login_2 s2;
	struct sockaddr_in sin;  /* used to store inet addr stuff  */

#ifdef TRACE_FUNCTION
	g_print( "Login\n" );
#endif

	Connect_Remote( server, remote_port, STDERR );

	our_info->ip = g_strdup_printf( "%u.%u.%u.%u",
	                                (BYTE) (our_ip >> 24),
	                                (BYTE) (our_ip >> 16),
	                                (BYTE) (our_ip >> 8),
	                                (BYTE) (our_ip) );
				         		         		         		         
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_LOGIN );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
	DW_2_Chars( s1.port, port );
	Word_2_Chars( s1.len, strlen( pass ) + 1 );
	DW_2_Chars( s1.time, time( NULL ) );

	DW_2_IP( s2.ip, ip );
	sin.sin_addr.s_addr = g_htonl(IP_2_DW( s2.ip ));
	DW_2_Chars( s2.status, preset_status );

	DW_2_Chars( s2.X1, LOGIN_X1_DEF );
	s2.X2[0] = LOGIN_X2_DEF;
	DW_2_Chars( s2.X3, LOGIN_X3_DEF );
	DW_2_Chars( s2.X4, LOGIN_X4_DEF );
	DW_2_Chars( s2.X5, LOGIN_X5_DEF );
   
	memcpy( pak.data, &s1, sizeof( s1 ) );
	size = sizeof( s1 );
	memcpy( &pak.data[size], pass, Chars_2_Word( s1.len ) );
	size += Chars_2_Word( s1.len );
	memcpy( &pak.data[size], &s2.X1, sizeof( s2.X1 ) );
	size += sizeof( s2.X1 );
	memcpy( &pak.data[size], &s2.ip, sizeof( s2.ip ) );
	size += sizeof( s2.ip );
	memcpy( &pak.data[size], &s2.X2, sizeof( s2.X2 ) );
	size += sizeof( s2.X2 );
	memcpy( &pak.data[size], &s2.status, sizeof( s2.status ) );
	size += sizeof( s2.status );
	memcpy( &pak.data[size], &s2.X3, sizeof( s2.X3 ) );
	size += sizeof( s2.X3 );
	memcpy( &pak.data[size], &s2.X4, sizeof( s2.X4 ) );
	size += sizeof( s2.X4 );
	memcpy( &pak.data[size], &s2.X5, sizeof( s2.X5 ) );
	size += sizeof( s2.X5 );
	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head )- 2, "CMD_LOGIN" );
} 

/*
 * Sends aknowlegment to server
 * Appears that this must be done after
 * everything the server sends us
 */
void ack_srv( DWORD seq )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "ack_srv\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_ACK );
	DW_2_Chars( pak.head.seq2, seq );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );

	SOCKWRITE( &(pak.head.ver), sizeof( pak.head ) + 2, "CMD_ACK" );
}

void Display_Info_Reply( srv_net_icq_pak pak )
{
	char *tmp;
	int len;
	Contact_Member *DestContact;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Display_Info_Reply\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == Chars_2_DW( &pak.data[ 0 ] ) )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		DestContact = &New_Contact;
	else
		DestContact = contact->data;

	if( DestContact->info->nick != NULL )
		g_free( DestContact->info->nick );
	if( DestContact->info->first != NULL )
		g_free( DestContact->info->first );
	if( DestContact->info->last != NULL )
		g_free( DestContact->info->last );
	if( DestContact->info->email != NULL )
		g_free( DestContact->info->email );

	len = Chars_2_Word( &pak.data[4] );
	DestContact->info->nick = (char*)g_malloc( strlen( &pak.data[6] ) + 1 );
	strcpy( DestContact->info->nick, &pak.data[6] );

	if( atoi( DestContact->nick ) == DestContact->uin && DestContact->uin &&
	    strlen( &pak.data[ 6 ] ) && DestContact->lb_index )
	{
		strcpy( DestContact->nick , &pak.data[6] );
		gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
		                    DestContact->lb_index, 1, &pak.data[ 6 ] );
		Save_RC();
	}

	tmp = &pak.data[ 6 + len ];

	len = Chars_2_Word( tmp );
	DestContact->info->first = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->first, tmp+2 );
	tmp += len + 2;
	
	len = Chars_2_Word( tmp );
	DestContact->info->last = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->last, tmp+2 );
	tmp += len + 2;
   
	len = Chars_2_Word( tmp );
	DestContact->info->email = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->email, tmp+2 );
	tmp += len + 2;

	if ( *tmp == 1 )
	{
		DestContact->info->auth = FALSE;
	}
	else
	{
		DestContact->info->auth = TRUE;
	}
}

void Display_Search_Reply(srv_net_icq_pak pak)
{
	gchar *data[6];
	gchar *dsr_uin = NULL;
	gchar *titles[] = { 
	  _("UIN"), 
	  _("Nick"),
	  _("F. Name"),
	  _("L. Name"),
	  _("E-mail"),
	  _("Authorization")
	};

	gchar *tmp;
	gint len;
	gint row;

#ifdef TRACE_FUNCTION
	g_print( "Display_Search_Reply\n" );
#endif

	/* UIN */
	data[ 0 ] = dsr_uin = g_strdup_printf( "%u", Chars_2_DW( &pak.data[ 0 ] ) );
	len = Chars_2_Word( &pak.data[4] );

	/* Nick Name */
	data[ 1 ] = &pak.data[ 6 ];
	tmp = &pak.data[ 6 + len ];
	len = Chars_2_Word( tmp );
	
	/* First Name */
	data[ 2 ] = tmp + 2;
	tmp += len + 2;
	len = Chars_2_Word( tmp );
	
	/* Last Name */
	data[ 3 ] = tmp + 2;
	tmp += len + 2;
	len = Chars_2_Word( tmp );
	
	/* E-Mail Address */
	data[ 4 ] = tmp + 2;
	tmp += len + 2;

	/* Authorization */
	data[ 5 ] =  ( *tmp == 1 ) 
	  ? _("No auth needed") 
	  : _("Must request auth");

	if( !found_list )
	{
		found_list = gtk_clist_new_with_titles( 6, titles );
	}
	
	row = gtk_clist_append( GTK_CLIST( found_list ), data );

	g_free(dsr_uin);

	gtk_clist_set_row_data( GTK_CLIST( found_list ), row,
				GUINT_TO_POINTER(Chars_2_DW( &pak.data[ 0 ] )) );
}

GSList *Do_Msg( const time_t msg_time, DWORD type, char *data, UIN_T uin, int message_type )
{
	gchar sender[50];
	gchar *tmp;

	GSList *contact = NULL;

	struct tm *msg_tm;
	gchar *msg_time_str;

	gchar *newnick;

	STORED_MESSAGE_PTR new_stored_message = NULL;

#ifdef TRACE_FUNCTION
	g_print( "Do_Msg\n" );
#endif

	contact = Contacts;
	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin &&
		    ((CONTACT_PTR)contact->data)->ignore_list )
			return NULL;
		contact = contact->next;
	}

	/* Mask off the 0x8xxx that's been causing problems */
	type &= 0xFF;

	switch( type )
	{
		case USER_ADDED_MESS:
			tmp = strchr( data, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}

			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );

			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}
		
			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}
	
			*tmp = '\0';
			tmp++;
			data = tmp;
			Do_Msg( time( NULL ), 0, data, uin, MESSAGE_USER_ADD );
			break;
		case AUTH_REQ_MESS:
			tmp = strchr( data, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}

			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}

			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}
	
			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}
	
			*tmp = '\0';
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
	
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return NULL;
			}
			*tmp = '\0';
			tmp ++;
			data = tmp;
			Do_Msg( time( NULL ), 0, data, uin, MESSAGE_AUTH_REQ );
			break;

		case URL_MESS:
			Do_Msg( time( NULL ), 0, data, uin, MESSAGE_URL );
			break;

		case AUTH_MESS:
			Do_Msg( time( NULL ), 0, data, uin, MESSAGE_USER_AUTHD );
			break;
			
		default:
			switch( message_type )
			{
				case MESSAGE_USER_AUTHD:
					gnomeicu_event( EV_AUTH );
					break;
				case MESSAGE_FILE_REQ:
					gnomeicu_event( EV_FILEREQ );
					break;
				case MESSAGE_CHAT_REQ:
					gnomeicu_event( EV_CHATREQ );
					break;
				case MESSAGE_URL:
					gnomeicu_event( EV_URLRECV );
					break;
				case MESSAGE_AUTH_REQ:
					gnomeicu_event( EV_AUTHREQ );
					break;
				case MESSAGE_USER_ADD:
					gnomeicu_event( EV_LISTADD );
					break;
				case MESSAGE_CONT_LIST:
					gnomeicu_event( EV_CONTLIST );
					break;
				case MESSAGE_TEXT:
				default:
					gnomeicu_event( EV_MSGRECV );
			}
			if( uin != 0 )
			{
				contact = Contacts;
				
				while( contact != NULL )
				{
					if( uin == ((CONTACT_PTR)contact->data)->uin )
						break;
					contact = contact->next;
				}

				if( contact == NULL )
				{
					newnick = g_strdup_printf( "%d", uin );
					Add_User( uin, newnick, FALSE );
					g_free( newnick );
				}

				contact = Contacts;
				
				while( contact != NULL )
				{
					if( uin == ((CONTACT_PTR)contact->data)->uin )
						break;
					contact = contact->next;
				}

				strcpy( sender, ((CONTACT_PTR)contact->data)->nick );

				if( message_type == MESSAGE_CHAT_REQ && Current_Status == STATUS_FREE_CHAT )
					return contact;

				if( ((CONTACT_PTR)contact->data)->read_next &&
				    GTK_IS_WIDGET( ((CONTACT_PTR)contact->data)->read_next ) &&
				    GTK_WIDGET_VISIBLE( ((CONTACT_PTR)contact->data)->read_next )
				    && message_type == MESSAGE_TEXT )
					gtk_widget_set_sensitive( ((CONTACT_PTR)contact->data)->read_next, TRUE );
		
				((CONTACT_PTR)contact->data)->need_update = 1;

				/* Add to personal history file */
				if( uin > 0 )
					add_incoming_to_history( uin, data );

				log_window_add(_("Received Message"), uin);

				msg_tm = localtime( &msg_time );

				msg_time_str = g_strdup_printf( "%d:%02d%s, %02d/%02d/%04d\n",
				                                (msg_tm->tm_hour>0?msg_tm->tm_hour%12:12),
				                                msg_tm->tm_min,
				                                (msg_tm->tm_hour<12?"AM":"PM"),
				                                msg_tm->tm_mon+1, msg_tm->tm_mday, msg_tm->tm_year+1900);

				new_stored_message = g_new0( stored_message, 1 );
				new_stored_message->type = message_type;
				new_stored_message->message = g_strdup_printf( "%s%s", msg_time_str, data );
				((CONTACT_PTR)contact->data)->stored_messages = g_slist_append( ((CONTACT_PTR)contact->data)->stored_messages, new_stored_message );

				if( toggles->applet )
					applet_update( Current_Status, NULL );
				Show_Quick_Status();
			}
	}
	return contact;
}

GSList *Do_Chat( DWORD type, char *data, UIN_T uin, DWORD seq )
{
	char sender[50];

	GSList *contact;

	STORED_MESSAGE_PTR new_stored_message = NULL;

#ifdef TRACE_FUNCTION
	g_print( "Do_Chat\n" );
#endif

	contact = Contacts;

	if( uin != 0 )
	{
		while( contact != NULL )
		{
			if( uin == ((CONTACT_PTR)contact->data)->uin )
				break;
			contact = contact->next;
		}

		if( contact == NULL )
		{
			Contacts = g_slist_append( Contacts, g_new0( Contact_Member, 1 ) );
			contact = g_slist_last( Contacts );
			sprintf( ((CONTACT_PTR)contact->data)->nick, "%u", uin );
			Add_User( uin, ((CONTACT_PTR)contact->data)->nick, FALSE );
		}

		contact = Contacts;

		while( contact != NULL )
		{
			if( uin == ((CONTACT_PTR)contact->data)->uin )
				break;
			contact = contact->next;
		}

		strcpy( sender, ((CONTACT_PTR)contact->data)->nick );
		if( Current_Status == STATUS_FREE_CHAT )
			return contact;

		/* Add to personal history file */
		if( uin > 0 )
			add_incoming_to_history( uin, data );

		log_window_add( _("Received Chat Request"), uin );

		((CONTACT_PTR)contact->data)->chat_reason = (char*)g_malloc( strlen( data ) + 1 );
		strcpy( ((CONTACT_PTR)contact->data)->chat_reason, data );

		((CONTACT_PTR)contact->data)->chat_seq = seq;

		new_stored_message = g_new0( stored_message, 1 );
		new_stored_message->type = MESSAGE_CHAT_REQ;
		new_stored_message->message = g_strdup( data );
		((CONTACT_PTR)contact->data)->stored_messages = g_slist_append( ((CONTACT_PTR)contact->data)->stored_messages, new_stored_message );

		if( toggles->applet )
			applet_update( Current_Status, NULL );
		Show_Quick_Status();

		gnomeicu_event( EV_CHATREQ );
	}

	return contact;
}

GSList *Do_File( DWORD type, char *data, UIN_T uin, DWORD seq )
{
	char sender[50];

	GSList *contact;

	STORED_MESSAGE_PTR new_stored_message = NULL;

#ifdef TRACE_FUNCTION
	g_print( "Do_File\n" );
#endif

	contact = Contacts;

	if( uin != 0 )
	{
		while( contact != NULL )
		{
			if( uin == ((CONTACT_PTR)contact->data)->uin )
				break;
			contact = contact->next;
		}

		if( contact == NULL )
		{
			Contacts = g_slist_append( Contacts, g_new0( Contact_Member, 1 ) );
			contact = g_slist_last( Contacts );
			sprintf( ((CONTACT_PTR)contact->data)->nick, "%u", uin );
			Add_User( uin, ((CONTACT_PTR)contact->data)->nick, FALSE );
		}

		contact = Contacts;

		while( contact != NULL )
		{
			if( uin == ((CONTACT_PTR)contact->data)->uin )
				break;
			contact = contact->next;
		}

		strcpy( sender, ((CONTACT_PTR)contact->data)->nick );

		/* Add to personal history file */
		if( uin > 0 )
			add_incoming_to_history( uin, data );

		log_window_add( _("Received File Request"), uin );

		((CONTACT_PTR)contact->data)->file_seq = seq;

		new_stored_message = g_new0( stored_message, 1 );
		new_stored_message->type = MESSAGE_FILE_REQ;
		new_stored_message->message = g_strdup( data );
		((CONTACT_PTR)contact->data)->stored_messages = g_slist_append( ((CONTACT_PTR)contact->data)->stored_messages, new_stored_message );

		if( toggles->applet )
			applet_update( Current_Status, NULL );
		Show_Quick_Status();

		gnomeicu_event( EV_CHATREQ );
	}

	return contact;
}

void Display_Ext_Info_Reply( srv_net_icq_pak pak )
{
	char *tmp;
	int len;
	Contact_Member *DestContact;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Display_Ext_Info_Reply\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == Chars_2_DW( &pak.data[ 0 ] ) )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		DestContact = &New_Contact;
	else
		DestContact = contact->data;

	if( DestContact->info->city != NULL )
		g_free( DestContact->info->city );
	if( DestContact->info->state != NULL )
		g_free( DestContact->info->state );
	if( DestContact->info->phone != NULL )
		g_free( DestContact->info->phone );
	if( DestContact->info->homepage != NULL )
		g_free( DestContact->info->homepage );
	if( DestContact->info->about != NULL )
		g_free( DestContact->info->about );

	DestContact->info->uin = DestContact->uin;

	len = Chars_2_Word( &pak.data[4] );
	DestContact->info->city = (char*)g_malloc( strlen( &pak.data[6] ) + 1 );
	strcpy( DestContact->info->city, &pak.data[6] );
	tmp = &pak.data[6 + len ];

	tmp += 2; /* Bypass COUNTRY_CODE */
	tmp += 1; /* Bypass COUNTRY_STATUS */

	len = Chars_2_Word( tmp );
	DestContact->info->state = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->state, tmp+2 );
	tmp += len + 2;

	DestContact->info->age = Chars_2_Word( tmp );
	tmp += 2;

	if( tmp[0] == 0x00 )
	{
		DestContact->info->sex = NOT_SPECIFIED;
	}
	else if( tmp[0] == 0x01 )
	{
		DestContact->info->sex = FEMALE;
	}
	else if( tmp[0] == 0x02 )
	{
		DestContact->info->sex = MALE;
	}
	tmp += 1;

	len = Chars_2_Word( tmp );
	DestContact->info->phone = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->phone, tmp+2 );
	tmp += len + 2;

	len = Chars_2_Word( tmp );
	DestContact->info->homepage = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->homepage, tmp+2 );
	tmp += len + 2;

	len = Chars_2_Word( tmp );
	DestContact->info->about = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->about, tmp+2 );

	if( contact != NULL )
		dump_personal_info( DestContact->uin );
	else
	{
		start_new_info = FALSE;
		show_info_new( DestContact->uin );
	}
}


/*
 * Sends Invisible List that makes you
 * permanantly invisible to certain users
 */
void snd_invis_list( void )
{
	net_icq_pak pak;
	int num_used;
	int size;
	char *tmp;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "snd_invis_list\n" );
#endif
	
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_INVIS_LIST );
	Word_2_Chars( pak.head.seq, seq_num );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	
	tmp = pak.data;
	tmp ++;

	contact = Contacts;
	num_used = 0;

	while( contact != NULL )
	{
		if( (S_DWORD) ((CONTACT_PTR)contact->data)->uin > 0 )
		{
			if( ((CONTACT_PTR)contact->data)->invis_list )
			{
				DW_2_Chars( tmp, ((CONTACT_PTR)contact->data)->uin );
				tmp += 4;
				num_used ++;
			}
		}
		contact = contact->next;
	}

	if( num_used )
	{
		pak.data[ 0 ] = num_used;
		size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
		size += sizeof( pak.head ) - 2;

		SOCKWRITE( &(pak.head.ver), size, "CMD_INVIS_LIST" );
		seq_num ++;
	}
}

/*
 * Sends Visible List that allows certain
 * users to see you if you are invisible
 */
void snd_vis_list( void )
{
	net_icq_pak pak;
	int num_used;
	int size;
	char *tmp;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "snd_vis_list\n" );
#endif
	
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_VIS_LIST );
	Word_2_Chars( pak.head.seq, seq_num );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	
	tmp = pak.data;
	tmp ++;

	contact = Contacts;
	num_used = 0;

	while( contact != NULL )
	{
		if( (S_DWORD) ((CONTACT_PTR)contact->data)->uin > 0 )
		{
			if( ((CONTACT_PTR)contact->data)->vis_list )
			{
				DW_2_Chars( tmp, ((CONTACT_PTR)contact->data)->uin );
				tmp += 4;
				num_used ++;
			}
		}
		contact = contact->next;
	}

	if( num_used )
	{
		pak.data[ 0 ] = num_used;
		size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
		size += sizeof( pak.head ) - 2;

		SOCKWRITE( &(pak.head.ver), size, "CMD_VIS_LIST" );
		seq_num ++;
	}
}

void Meta_User( BYTE *data, DWORD len, WORD seq )
{
	WORD subcmd;
	int len_str;
	Contact_Member *DestContact;
	
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Meta_User\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->info_seq == seq )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		DestContact = &New_Contact;
	else
		DestContact = contact->data;

	if( DestContact->info == NULL )
		DestContact->info = g_new0( USER_INFO_STRUCT, 1 );

	if( DestContact->info->window != NULL && GTK_IS_CLIST( DestContact->info->window ) )
	{
		subcmd = Chars_2_Word( data );
		switch( subcmd )
		{
			case META_SRV_GEN:
				data += 2;
				if( *data != 0xA )
					break;
				data++;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->nick = g_strdup( data );
				gtk_clist_set_text( GTK_CLIST( DestContact->info->window ),
				                    0, 1, DestContact->info->nick );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->first = g_strdup( data );
				gtk_clist_set_text( GTK_CLIST( DestContact->info->window ),
				                    0, 2, DestContact->info->first );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->last = g_strdup( data );
				gtk_clist_set_text( GTK_CLIST( DestContact->info->window ),
				                    0, 3, DestContact->info->last );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->email = g_strdup( data );
				gtk_clist_set_text( GTK_CLIST( DestContact->info->window ),
				                    0, 4, DestContact->info->email );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				/* Other Email */
				DestContact->info->email2 = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				/* Old Email */
				DestContact->info->email3 = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->city = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->state = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->phone = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->fax = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->street = g_strdup( data );
				data += len_str;
				len_str = Chars_2_Word( data );
				data += 2;
				DestContact->info->cellular = g_strdup( data );
				data += len_str;
				if( ((glong)Chars_2_DW( data )) > 0 )
					DestContact->info->zip = Chars_2_DW( data );
				data += 4;
				DestContact->info->country = Chars_2_Word( data );
				data += 2;
				/*if( ((gschar)*data)>>1 != -50 )
					Time zone = g_strdup_printf( "(GMT %+d)", ((gschar)*data)>>1 );*/
				break;
				case 0x00F0:
				case 0x00FA:
				case 0x010E:
					break;
				default:
					return;
		}

		return;
	}

	if( DestContact->info->nick != NULL )
	{
		g_free( DestContact->info->nick );
		DestContact->info->nick = NULL;
	}
	if( DestContact->info->first != NULL )
	{
		g_free( DestContact->info->first );
		DestContact->info->first = NULL;
	}
	if( DestContact->info->last != NULL )
	{
		g_free( DestContact->info->last );
		DestContact->info->last = NULL;
	}
	if( DestContact->info->email != NULL )
	{
		g_free( DestContact->info->email );
		DestContact->info->email = NULL;
	}
	if( DestContact->info->city != NULL )
	{
		g_free( DestContact->info->city );
		DestContact->info->city = NULL;
	}
	if( DestContact->info->state != NULL )
	{
		g_free( DestContact->info->state );
		DestContact->info->state = NULL;
	}
	if( DestContact->info->phone != NULL )
	{
		g_free( DestContact->info->phone );
		DestContact->info->phone = NULL;
	}
	if( DestContact->info->homepage != NULL )
	{
		g_free( DestContact->info->homepage );
		DestContact->info->homepage = NULL;
	}
	if( DestContact->info->about != NULL )
	{
		g_free( DestContact->info->about );
		DestContact->info->about = NULL;
	}

	subcmd = Chars_2_Word( data );
	switch( subcmd )
	{
		case META_SRV_PASS:
		/* data[2] == 0xA ? "successful" : "unsuccessful" */
			break;
		case META_SRV_MORE:
			data += 2;
			if( *data != 0x0A )
				break;
			data++;
			if( Chars_2_Word( data ) != (WORD) -1 )
				DestContact->info->age = Chars_2_Word( data );
			else
				DestContact->info->age = 0;
			data += 2;
			if( *data == 1 )
				DestContact->info->sex = FEMALE;
			else if( *data == 2 )
				DestContact->info->sex = MALE;
			else
				DestContact->info->sex = NOT_SPECIFIED;
			data++;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->homepage = g_strdup( data );
			data += len_str;
			if( ( *(data+1) > 0 ) && ( *(data+1) < 12 ) )
			{
				DestContact->info->birth_year = 1900 + *(data);
				DestContact->info->birth_month = *(data+1);
				DestContact->info->birth_day = *(data+2);
			}
			data += 3;
			/* Languages = *data, *(data+1), *(data+2) */
			break;
		case META_SRV_ABOUT:
			data += 2;
			if( *data != 0xA )
				break;
			data++;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->about = g_strdup( data );
			break;
		case META_SRV_WORK:
			data += 2;
			if( *data != 0xA )
				break;
			data++;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_city = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_state = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_phone = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_fax = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_address = g_strdup( data );
			data += len_str;
			data += 6; /* Skip unknown data */
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->company_name = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->department = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->job_pos = g_strdup( data );
			data += len_str;
			data += 2; /* Skip unknown data */
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->work_homepage = g_strdup( data );
			data += len_str;
			break;
		case META_SRV_GEN:
			data += 2;
			if( *data != 0xA )
				break;
			data++;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->nick = g_strdup( data );
			if( atoi( DestContact->nick ) == DestContact->uin )
			{
				strcpy( DestContact->nick, DestContact->info->nick );
				gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
				                    DestContact->lb_index, 1, DestContact->nick );
			}

			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->first = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->last = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->email = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			/* Other Email */
			DestContact->info->email2 = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			/* Old Email */
			DestContact->info->email3 = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->city = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->state = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->phone = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->fax = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->street = g_strdup( data );
			data += len_str;
			len_str = Chars_2_Word( data );
			data += 2;
			DestContact->info->cellular = g_strdup( data );
			data += len_str;
			if( ((glong)Chars_2_DW( data )) > 0 )
				DestContact->info->zip = Chars_2_DW( data );
			data += 4;
			DestContact->info->country = Chars_2_Word( data );
			data += 2;
			/*if( ((gschar)*data)>>1 != -50 )
				Time zone = g_strdup_printf( "(GMT %+d)", ((gschar)*data)>>1 );*/
			break;
			case 0x00F0:
			case 0x00FA:
			case 0x010E:
				break;
			default:
				return;
	}

	if( contact != NULL )
		dump_personal_info( DestContact->uin );
	else
	{
		start_new_info = FALSE;
		show_info_new( DestContact->uin );
	}
}
