/*******************************
 Change personal information
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

/*** Local function declarations ***/
static void changed( GtkWidget *widget, GnomePropertyBox *pb );
static gint clear_window( GtkWidget *widget, gpointer data );
static void apply_changes( GtkWidget *widget, gpointer data );

/*** Global functions ***/
void change_info_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *table;
	GtkWidget *button;
	GtkWidget *scrollbar;
	GtkAdjustment *adj, *adj2;

	gchar *string;
	GList *gender = NULL;
	GList *months = NULL;

	if( our_info->window == NULL )
		our_info->window = gnome_property_box_new();
	else
		return;

	gtk_window_set_title( GTK_WINDOW( our_info->window ), _("GnomeICU: User Information") );

	gtk_signal_connect( GTK_OBJECT( our_info->window ), "apply",
	                    (GtkSignalFunc)apply_changes, NULL );

	gtk_signal_connect( GTK_OBJECT( our_info->window ), "destroy",
	                    (GtkSignalFunc)clear_window, NULL );

	adj = (GtkAdjustment *) gtk_adjustment_new( (float)our_info->birth_day,
	                                            1.0F, 31.0F, 1.0F, 10.0F,
	                                            0.0F );

	adj2 = (GtkAdjustment *) gtk_adjustment_new( (float)( our_info->birth_year + 1900 ),
	                                             1900.0F, 1999.0F, 1.0F, 100.0F,
	                                             0.0F );

	gender = g_list_prepend( gender, _("Not specified") );
	gender = g_list_prepend( gender, _("Female") );
	gender = g_list_prepend( gender, _("Male") );

	months = g_list_prepend( months, _("December") );
	months = g_list_prepend( months, _("November") );
	months = g_list_prepend( months, _("October") );
	months = g_list_prepend( months, _("September") );
	months = g_list_prepend( months, _("August") );
	months = g_list_prepend( months, _("July") );
	months = g_list_prepend( months, _("June") );
	months = g_list_prepend( months, _("May") );
	months = g_list_prepend( months, _("April") );
	months = g_list_prepend( months, _("March") );
	months = g_list_prepend( months, _("February") );
	months = g_list_prepend( months, _("January") );

/** General Tab **/

	table = gtk_table_new( 5, 7, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
	gnome_property_box_append_page( GNOME_PROPERTY_BOX( our_info->window ), table,
	                                gtk_label_new( _("General") ) );

	label = gtk_label_new( _("UIN:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Nick:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );
		
	label = gtk_label_new( _("F. Name:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("L. Name:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 1, 2, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );
		
	label = gtk_label_new( _("Sex:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Age:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 2, 3, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Birthday:") );
	gtk_misc_set_alignment( GTK_MISC( label ) , 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	our_info->w_uin = gtk_entry_new();
	string = g_strdup_printf( "%u", our_info->uin );
	gtk_entry_set_text( GTK_ENTRY( our_info->w_uin ), string );
	g_free( string );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_uin,
	                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_uin ), FALSE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_uin ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_uin );

	our_info->w_nick = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_nick ), our_info->nick );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_nick,
	                  4, 7, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_nick ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_nick ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_nick );

	our_info->w_first = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_first ), our_info->first );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_first,
	                  1, 3, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_first ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_first ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_first );

	our_info->w_last = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_last ), our_info->last );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_last,
	                  4, 7, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_last ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_last ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_last );

	our_info->w_sex = gtk_combo_new();
	gtk_combo_set_popdown_strings( GTK_COMBO( our_info->w_sex ), gender );
	if( our_info->sex == MALE )
		gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ),
		                    _("Male") );
	else if( our_info->sex == FEMALE )
		gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ),
		                    _("Female") );
	else
		gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ),
		                    _("Not specified") );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_sex,
	                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ),
	                        FALSE );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( our_info->w_sex )->entry ),
	                    "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_sex );

	our_info->w_age = gtk_entry_new();
	string = g_strdup_printf( "%d", ( our_info->age % 1000 ) );
	gtk_entry_set_text( GTK_ENTRY( our_info->w_age ), string );
	g_free( string );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_age,
	                  4, 7, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_age ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_age ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_age );

	our_info->w_auth = gtk_check_button_new_with_label( _("Require Auth") );
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( our_info->w_auth ), our_info->auth );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_auth,
	                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_signal_connect( GTK_OBJECT( our_info->w_auth ), "toggled", changed, our_info->window );
	gtk_widget_show( our_info->w_auth );

	hbox = gtk_hbox_new( 0, FALSE );
	gtk_table_attach( GTK_TABLE( table ), hbox, 1, 7, 4, 5, GTK_FILL, GTK_FILL,
	                  5, 5 );

	our_info->w_birth_month = gtk_combo_new();
	gtk_widget_set_usize( GTK_COMBO( our_info->w_birth_month )->entry, 85, 0 );
	gtk_combo_set_popdown_strings( GTK_COMBO( our_info->w_birth_month ), months );

	switch( our_info->birth_month )
	{
		case 1:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("January") );
			break;
		case 2:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("February") );
			break;
		case 3:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("March") );
			break;
		case 4:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("April") );
			break;
		case 5:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("May") );
			break;
		case 6:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("June") );
			break;
		case 7:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("July") );
			break;
		case 8:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("August") );
			break;
		case 9:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("September") );
			break;
		case 10:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("October") );
			break;
		case 11:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("November") );
			break;
		case 12:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("December") );
			break;
		default:
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ), _("January") );
	}

	gtk_box_pack_start( GTK_BOX( hbox ), our_info->w_birth_month, FALSE, FALSE, 0 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ),
	                        FALSE );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( our_info->w_birth_month )->entry ),
	                    "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_birth_month );

	our_info->w_birth_day = gtk_spin_button_new( adj, 0, 0 );
	gtk_spin_button_set_wrap( GTK_SPIN_BUTTON( our_info->w_birth_day ), FALSE );
	gtk_spin_button_set_shadow_type( GTK_SPIN_BUTTON( our_info->w_birth_day ),
	                                 GTK_SHADOW_IN );
	gtk_widget_set_usize( our_info->w_birth_day, 55, 0 );
	gtk_box_pack_start( GTK_BOX( hbox ), our_info->w_birth_day, FALSE, FALSE, 0 );
	gtk_widget_show( our_info->w_birth_day );

	our_info->w_birth_year = gtk_spin_button_new( adj2, 0, 0 );
	gtk_spin_button_set_wrap( GTK_SPIN_BUTTON( our_info->w_birth_year ), FALSE );
	gtk_spin_button_set_shadow_type( GTK_SPIN_BUTTON( our_info->w_birth_year ),
	                                 GTK_SHADOW_IN );
	gtk_widget_set_usize( our_info->w_birth_year, 55, 0 );
	gtk_box_pack_start( GTK_BOX( hbox ), our_info->w_birth_year, FALSE, FALSE, 0 );
	gtk_widget_show( our_info->w_birth_year );

	gtk_widget_show( hbox );

	gtk_widget_show( table );

/** Internet Tab **/
	table = gtk_table_new( 6, 2, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
	gnome_property_box_append_page( GNOME_PROPERTY_BOX( our_info->window ), table,
	                                gtk_label_new( _("Internet") ) );

	label = gtk_label_new( _("IP:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Port:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Email:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Other Email:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Old Email:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	our_info->w_ip = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_ip ), our_info->ip );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_ip,
	                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_ip ), FALSE );
	gtk_widget_show( our_info->w_ip );

	our_info->w_port = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_port ), our_info->port );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_port,
	                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_port ), FALSE );
	gtk_widget_show( our_info->w_port );

	our_info->w_email = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_email ), our_info->email );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_email,
	                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_widget_set_usize( our_info->w_email, 200, 0 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_email ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_email ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_email );

	our_info->w_email2 = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_email2 ), our_info->email2 );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_email2,
	                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_widget_set_usize( our_info->w_email2, 200, 0 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_email2 ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_email2 ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_email2 );

	our_info->w_email3 = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_email3 ), our_info->email3 );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_email3,
	                  1, 2, 4, 5, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_widget_set_usize( our_info->w_email3, 200, 0 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_email3 ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_email3 ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_email3 );

	our_info->w_hide_email = gtk_check_button_new_with_label( _("Hide Email") );
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( our_info->w_hide_email ), our_info->hide_email );
	gtk_table_attach( GTK_TABLE( table ), our_info->w_hide_email,
	                  1, 2, 5, 6, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_signal_connect( GTK_OBJECT( our_info->w_hide_email ), "toggled", changed, our_info->window );
	gtk_widget_show( our_info->w_hide_email );

	gtk_widget_show( table );

/** Location Tab **/
	table = gtk_table_new( 9, 2, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
	gnome_property_box_append_page( GNOME_PROPERTY_BOX( our_info->window ), table,
	                          gtk_label_new( _("Location") ) );

	label = gtk_label_new( _("Phone:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Fax:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Cellular:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Street:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("City:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("State:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 5, 6, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Zip:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 6, 7, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Country:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 7, 8, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("Time Zone:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 8, 9, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	our_info->w_phone = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_phone ), our_info->phone );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_phone,
	                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_phone ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_phone ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_phone );

	our_info->w_fax = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_fax ), our_info->fax );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_fax,
	                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_fax ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_fax ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_fax );

	our_info->w_cellular = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_cellular ), our_info->cellular );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_cellular,
	                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_cellular ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_cellular ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_cellular );

	our_info->w_street = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_street ), our_info->street );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_street,
	                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_street ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_street ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_street );

	our_info->w_city = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_city ), our_info->city );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_city,
	                  1, 2, 4, 5, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_city ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_city ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_city );

	our_info->w_state = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_state ), our_info->state );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_state,
	                  1, 2, 5, 6, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_state ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_state ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_state );

	our_info->w_zip = gtk_entry_new();

	string = g_strdup_printf( "%u", our_info->zip );
	gtk_entry_set_text( GTK_ENTRY( our_info->w_zip ), string );
	g_free( string );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_zip,
	                  1, 2, 6, 7, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_zip ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_zip ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_zip );

	our_info->w_country = gtk_combo_new();
	gtk_widget_set_usize( our_info->w_country, 300, 0 );
	gtk_combo_set_popdown_strings( GTK_COMBO( our_info->w_country ), get_country_codes() );
	gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_country )->entry ),
	                    Get_Country_Name( our_info->country ) );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_country,
	                  1, 2, 7, 8, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( our_info->w_country )->entry ),
	                        FALSE );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( our_info->w_country )->entry ),
	                    "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_country );

	our_info->w_c_status = gtk_combo_new();
	gtk_widget_set_usize( our_info->w_c_status, 300, 0 );
	gtk_combo_set_popdown_strings( GTK_COMBO( our_info->w_c_status ), get_time_zones() );

	gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( our_info->w_c_status )->entry ),
	                    Get_Time_Zone_String( our_info->c_status ) );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_c_status,
	                  1, 2, 8, 9, GTK_FILL, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( our_info->w_c_status )->entry ),
	                        FALSE );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( our_info->w_c_status )->entry ),
	                    "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_c_status );

	gtk_widget_show( table );

/** About Tab **/
	table = gtk_table_new( 3, 3, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
	gnome_property_box_append_page( GNOME_PROPERTY_BOX( our_info->window ), table,
	                                gtk_label_new( _("About") ) );

	label = gtk_label_new( _("Home Page:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( _("About:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 1 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
	gtk_widget_show( label );

	our_info->w_homepage = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( our_info->w_homepage ), our_info->homepage );

	gtk_table_attach( GTK_TABLE( table ), our_info->w_homepage,
	                  1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5 );
	gtk_entry_set_editable( GTK_ENTRY( our_info->w_homepage ), TRUE );
	gtk_signal_connect( GTK_OBJECT( our_info->w_homepage ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_homepage );

	button = gtk_button_new_with_label( _("View") );
	gtk_table_attach( GTK_TABLE( table ), button,
	                  2, 3, 0, 1, GTK_FILL, 0, 0, 0 );

	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( display_url_from_entry ),
	                    our_info->w_homepage );

	gtk_widget_show( button );

	hbox = gtk_hbox_new( FALSE, 0 );
	our_info->w_about = gtk_text_new( NULL, NULL );
	gtk_text_set_word_wrap( GTK_TEXT( our_info->w_about ), TRUE );
	gtk_text_set_editable( GTK_TEXT( our_info->w_about ), TRUE );

	gtk_box_pack_start( GTK_BOX( hbox ), our_info->w_about, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( our_info->w_about ), "changed", changed, our_info->window );
	gtk_widget_show( our_info->w_about );

	scrollbar = gtk_vscrollbar_new( GTK_TEXT( our_info->w_about )->vadj );
	gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
	gtk_widget_show( scrollbar );

	if( our_info->about != NULL )
	{
		gtk_text_freeze( GTK_TEXT( our_info->w_about ) );
		gtk_text_insert( GTK_TEXT( our_info->w_about ), NULL, NULL, NULL,
		                 our_info->about, -1 );
		gtk_text_thaw( GTK_TEXT( our_info->w_about ) );
	}

	gtk_table_attach( GTK_TABLE( table ), hbox,
	                  0, 3, 2, 3, GTK_FILL | GTK_EXPAND,
	                  GTK_FILL | GTK_EXPAND, 5, 5 );

	gtk_widget_show( hbox );
	gtk_widget_show( table );

	gtk_widget_show( our_info->window );
}

void changed( GtkWidget *widget, GnomePropertyBox *pb )
{
	gnome_property_box_changed( pb );
}

gint clear_window( GtkWidget *widget, gpointer data )
{
	our_info->window = NULL;
	return TRUE;
}

void apply_changes( GtkWidget *widget, gpointer data )
{
	g_free( our_info->nick );
	our_info->nick = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_nick ) ) );

	g_free( our_info->first );
	our_info->first = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_first ) ) );

	g_free( our_info->last );
	our_info->last = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_last ) ) );

	if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ) ), _("Male") ) )
		our_info->sex = MALE;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_sex )->entry ) ), _("Female") ) )
		our_info->sex = FEMALE;
	else
		our_info->sex = NOT_SPECIFIED;

	our_info->age = atoi( gtk_entry_get_text( GTK_ENTRY( our_info->w_age ) ) );

	our_info->auth = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON( our_info->w_auth ) );

	our_info->birth_year = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( our_info->w_birth_year ) ) - 1900;

	our_info->birth_day = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( our_info->w_birth_day ) );

	if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("January") ) )
		our_info->birth_month = 1;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("February") ) )
		our_info->birth_month = 2;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("March") ) )
		our_info->birth_month = 3;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("April") ) )
		our_info->birth_month = 4;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("May") ) )
		our_info->birth_month = 5;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("June") ) )
		our_info->birth_month = 6;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("July") ) )
		our_info->birth_month = 7;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("August") ) )
		our_info->birth_month = 8;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("September") ) )
		our_info->birth_month = 9;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("October") ) )
		our_info->birth_month = 10;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("November") ) )
		our_info->birth_month = 11;
	else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_birth_month )->entry ) ), _("December") ) )
		our_info->birth_month = 12;

	g_free( our_info->email );
	our_info->email = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_email ) ) );

	g_free( our_info->email2 );
	our_info->email2 = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_email2 ) ) );

	g_free( our_info->email3 );
	our_info->email3 = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_email3 ) ) );

	our_info->hide_email = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( our_info->w_hide_email ));

	g_free( our_info->phone );
	our_info->phone = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_phone ) ) );

	g_free( our_info->fax );
	our_info->fax = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_fax ) ) );

	g_free( our_info->cellular );
	our_info->cellular = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_cellular ) ) );

	g_free( our_info->street );
	our_info->street = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_street ) ) );

	g_free( our_info->city );
	our_info->city = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_city ) ) );

	g_free( our_info->state );
	our_info->state = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_state ) ) );

	our_info->zip = atoi( gtk_entry_get_text( GTK_ENTRY( our_info->w_zip ) ) );

	our_info->country = Get_Country_Code( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_country )->entry ) ) );

	our_info->c_status = Get_Time_Zone( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( our_info->w_c_status )->entry ) ) );

	g_free( our_info->homepage );
	our_info->homepage = g_strdup( gtk_entry_get_text( GTK_ENTRY( our_info->w_homepage ) ) );

	g_free( our_info->about );
	our_info->about = gtk_editable_get_chars( GTK_EDITABLE( our_info->w_about ), 0, -1 );

	Update_User_Info();
}
