/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */
#ifndef UTIL_H
#define UTIL_H

extern char *short_path(char *path, int depth);
/* print to console */
extern void printc(char *text);
extern void printcn(char *text);
extern void printcf(char *fmt, ...);

extern GtkWidget* hbox_new_with_label(gchar *text, GtkWidget *widg, gboolean exp);
extern gchar *pixmap_file(char *fn);
extern void qprintf(char *fmt, ...);
extern GList* g_list_free_all(GList *list);

extern int g_quiet;

#define FINFO() qprintf("%s(%d):  %s(", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#define FUNCPRINT(fmt, args...) {FINFO(); qprintf(fmt, ##args); qprintf(")\n"); }
/* this wrapper is for calling gtk/gdk functions from within threads */
#define T(x) {gdk_threads_enter(); {x} gdk_threads_leave();}

#endif /* UTIL_H */
