
/*

    File: dns.h
    
    Copyright (C) 1999 by Wolfgang Zekoll  <wzk@quietsche-entchen.de>

    This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This source is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DNRD_DNS_H_
#define _DNRD_DNS_H_


	/* Internet DNS is the only class we support. */

#define	DNS_CLASS_INET			1


	/* Here's where the packet's first field starts. */
	
#define	PACKET_DATABEGIN		12


typedef union _packetflags {
    unsigned short	flags;

    struct {
	unsigned short int rcode:4;
	unsigned short int unused:3;
	unsigned short int recursion_avail:1;
	unsigned short int want_recursion:1;
	unsigned short int truncated:1;
	unsigned short int authorative:1;
	unsigned short int opcode:4;
	unsigned short int question:1;
    } b;
} pflag_t;


typedef struct _rr {
    pflag_t	  flags;
    char	  name[300];
    
    unsigned int  type;
    unsigned int  class;

    unsigned long ttl;
    int		  len;
    char	  data[300];
} rr_t;


typedef struct _header {
    unsigned short int	id;
    pflag_t	u;

    short int	qdcount;
    short int	ancount;
    short int	nscount;
    short int	arcount;	/* Till here it would fit perfectly to a real
    				 * DNS packet if we had big endian. */

    char	*here;		/* For packet parsing. */
    char	*packet;	/* The actual data packet ... */
    int		len;		/* ... with this size in bytes. */

    char	*rdata;		/* For packet assembly. */
} dnsheader_t;


int free_packet(dnsheader_t *x);

/* static dnsheader_t *decode_header(void *packet, int len); */

dnsheader_t *parse_packet(unsigned char *packet, int len);
int get_dnsquery(dnsheader_t *x, rr_t *query);
unsigned char *parse_query(rr_t *query, unsigned char *msg, int len);

#endif /* _DNRD_DNS_H_ */

