/* Darxite - the only FTP or HTTP system you'll ever need
   Copyright (C) 1999 Ashley Montanaro <hell@ukgateway.net>.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef DAEMON_GLOBAL_H
#define DAEMON_GLOBAL_H

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#ifndef SINGLETHREAD
#   include <pthread.h>
#endif
#include <sys/time.h>
#include <unistd.h>
#include <setjmp.h>

#include "error.h"
#include <darxite.h>

#define PROG_NAME	"Darxite"
#define VERSION		"0.4"
#define AUTHORS		"Ashley Montanaro"

#define FOREVER			65535
#define RESP_TIMEOUT    30

#define MAX_MIRRORS 	100

// this funky stuff is to allow the program to be multithreaded
// or not, dependent on the options set at compile-time
#ifdef SINGLETHREAD
#   define SPAWN_THREAD(x,y,z) 	(x(z))
#   define DETACH_THREAD(x)		
#   define WAIT_FOR_THREAD(x)
#   define CANCEL_THREAD(x)
#   define GET_THREAD_ID()		0
#   define SET_THREAD_ID(x,y)
#   define SET_CANCEL_TYPE(x,y)
#   define SET_CLEANUP(x,y)
#   define UNSET_CLEANUP(x)
#   define INIT_MUTEX(x)		
#   define LOCK_MUTEX(x)		
#   define UNLOCK_MUTEX(x)		
#   define THREAD_ID(x)			
#   define MUTEX(x)
#   define ONCE_ID(x)		
#   define ONCE(x,y)
#   define PTHREAD_CANCEL_ASYNCHRONOUS 0
#else
// Arguments are: function name, thread id, function argument
#   define SPAWN_THREAD(x,y,z) 	(pthread_create(&(y), NULL, (void *)(x), (z)))
#   define DETACH_THREAD(x)	(pthread_detach(x))
#   define WAIT_FOR_THREAD(x) 	(pthread_join(x, NULL))
#   define CANCEL_THREAD(x)	(pthread_cancel(x))
#   define GET_THREAD_ID()	(pthread_self())
#   define SET_THREAD_ID(x,y)	((x) = (y))
#   define SET_CANCEL_TYPE(x, y) (pthread_setcanceltype(x, y))
#   define SET_CLEANUP(x,y)	pthread_cleanup_push(x, y)
#   define UNSET_CLEANUP(x)	pthread_cleanup_pop(x)
#   define INIT_MUTEX(x)	(pthread_mutex_init(&(x), NULL))
#   define LOCK_MUTEX(x)	(pthread_mutex_lock(&(x)))
#   define UNLOCK_MUTEX(x)	(pthread_mutex_unlock(&(x)))
#   define THREAD_ID(x)		pthread_t x;
#   define MUTEX(x)		pthread_mutex_t x;
#   define ONCE_ID(x)		pthread_once_t x = PTHREAD_ONCE_INIT;
#   define ONCE(x, y)		pthread_once(&x, y);
#endif

// these are ORed together, so make sure they're powers of 2!
enum Event {
    NO_EVENT = 0,
    FILE_COMPLETION_EVENT = 1,
    CONFIG_CHANGE_EVENT = 2,
    ERROR_EVENT = 4,
    REDIRECT_EVENT = 8,
    EXIT_EVENT = 16,
    NEW_FILE_EVENT = 32,
};

struct _serverInfo;

typedef struct _serverInfo {
    char Name[256];
    char UserName[256];
    char Password[256];
    char DefaultPath[256];
    char Flags[20];
    BOOL AddedToFile;
    BOOL SupportsFileResume;
    char Comment[256];
    char Alias[256];
    unsigned int IpAddress;
    struct _serverInfo *Mirrors[MAX_MIRRORS];
    int MirrorCount;
    struct _serverInfo *Next;
    struct _serverInfo *Prev;
} ServerInfo;

ServerInfo *FirstServer;
ServerInfo *DummyServer; // blank server for file:// "transfers"
int ServerCount;


typedef struct _fileInfo {
    char Id[4];
    char Path[256];
    char LocalPath[256];
    char SpooledPath[256];
    char Activity[256];
    char Flags[20];
    char Protocol[10];
    char LogIn[256];
    char Password[256];
    ServerInfo *Server;		  // the nominal server it's connected to
    ServerInfo *ActualServer; // the mirror it's connected to
    BOOL Upload; // if it's an upload
    BOOL Complete;
    BOOL Started;
    BOOL Starting; // ie. looking up host etc. but not ready for transfer
    BOOL Paused;
    BOOL WouldTransfer; // if FileCount > MaxSimDownloads
    BOOL GotHeader; // if it's an HTTP file and we've had the header
    BOOL IsMassiveMaster; // if the file's running a massive download
    int TotalSize; // get -> remote file size, put -> local file size
    int CurrentSize; // get -> local file size, put -> remote file size
    int StartOffset; // offset from the start of file for massive download
    int RxTxOverall; // bytes received/sent this session
    int NextMirror; // -1 means not a mirror, the original
    time_t TimeOfLastRxTx; // the time we last received/sent some data
    time_t StartTime, FinishTime;
    FILE *LocalFile;
    THREAD_ID(ThreadId)
    struct _clientInfo *Client; // the client to notify when the file's done
    struct _sockInfo *ControlSocket;
    struct _sockInfo *DataSocket;
    struct _massiveFileList *MassiveFiles; // massive files dependent on this
    struct _fileInfo *MassiveMaster; // "master" file for the massive dl
    struct _fileInfo *Next;
    struct _fileInfo *Prev;
} FileInfo;

typedef struct _massiveFileList {
    char *LocalPath;
    BOOL Complete;
    struct _massiveFileList *Next;
} MassiveFileList;

typedef struct _batchInfo {
    FileInfo *FirstFile;
    int FileCount;   // the number of transferrable files - ie. NON-PAUSED ones
    BOOL Complete;
} BatchInfo;

BatchInfo Batch;
BOOL Sleeping, WakeUpNow;
int DefaultFtpPort, DefaultHttpPort;
char RemotePassword[256];
sigjmp_buf MainJump;

void *dxmalloc(size_t size);
void *dxcalloc(size_t size);
#define dxfree(x) { /*error(E_TRACE, "Freeing memory at %d", x); */free(x); \
                    (x) = NULL; }
void Sleep(unsigned long msecs);
int Timestamp(void);

#endif
