// Global functions

#include "global.h"

void *dxmalloc(size_t size)
{
    register void *value;

    //error(E_TRACE, "Trying to malloc %d bytes", size);
    value = malloc(size);
    if (value == NULL)
        error(E_FATAL, "Out of memory!");

    memset(value, 0, size);
    //error(E_TRACE, "Allocated %d bytes at %p", size, value);
    return value;
}

void *dxcalloc(size_t size)
{
    register void *value = dxmalloc(size);

    memset(value, 0, size);
    return value;
}

// Gets and displays a timestamp - useful for profiling.
// Display format is mins : secs : msecs : usecs
// Returns the timestamp in usecs.
int Timestamp(void)
{
    struct timeval tv;
    struct timezone tz;

    if (gettimeofday(&tv, &tz) == 0)
    {
        error(E_TRACE, " === %d : %d : %d : %d ===",
              tv.tv_sec % (60 * 60) / 60, tv.tv_sec % 60, tv.tv_usec / 1000,
              tv.tv_usec % 1000);
        return (tv.tv_sec * 1000 * 1000) + tv.tv_usec;
    }
    // should NEVER get here!
    return -1;
}

// Win32-alike sleep
void Sleep(unsigned long msecs)
{
    struct timeval timeout;

    if (msecs == 0)
        return;

    if (msecs == FOREVER)
    {
        //error(E_TRACE, "Sleeping forever...");
        select(0, NULL, NULL, NULL, NULL);
        return;
    }
    
    timeout.tv_sec = msecs / 1000;
    timeout.tv_usec = (msecs - (timeout.tv_sec * 1000)) * 1000;
    //error(E_TRACE, "Sleeping for %ds, %dus...", timeout.tv_sec,
    //      timeout.tv_usec);
    select(0, NULL, NULL, NULL, &timeout);    
}
