#ifndef DAEMON_BUF_H
#define DAEMON_BUF_H

struct buf_t;
struct buf_t *buf_new(void);
void buf_free(struct buf_t *buf);
void buf_set_input_size(struct buf_t *buf, size_t size);
int buf_get_input_size(const struct buf_t *buf);
void buf_set_output_size(struct buf_t *buf, size_t size);
int buf_get_output_size(const struct buf_t *buf);
void buf_flush(struct buf_t *buf);
int buf_used(const struct buf_t *buf);
int buf_read(struct buf_t *buf, int fd);
int buf_fread(struct buf_t *buf, FILE *f);
int buf_write(struct buf_t *buf, int fd);
int buf_fwrite(struct buf_t *buf, FILE *f);
int buf_hasline(const struct buf_t *buf);
int buf_getline(struct buf_t *buf, char *str, size_t bufsize);
int buf_printf(struct buf_t *buf, const char *fmt, ...);
int buf_grab(struct buf_t *buf, char *s, size_t size);

#endif
