/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#include "setup.h"
#define LIST_INTERNAL_ACCESS
#include <stddef.h>
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# endif
#endif
#include "eventlog.h"
#include "list.h"


extern unsigned int list_get_length(t_list const * list)
{
    t_list const * curr;
    unsigned int   len;
    
    for (len=0,curr=list; curr; curr=curr->next,len++);
    
    return len;
}


extern int list_prepend_item(t_list * * list, void * data)
{
    t_list * item;
    
    if (!list)
    {
	eventlog(eventlog_level_error,"list_prepend_item","got NULL list");
	return -1;
    }
    
    if (!(item = malloc(sizeof(t_list))))
    {
	eventlog(eventlog_level_error,"list_prepend_item","could not allocate memory for item");
	return -1;
    }
    item->data = data;
    item->next = *list;
    *list = item;
    
    return 0;
}


extern int list_append_item(t_list * * list, void * data)
{
    t_list * * tail;
    
    if (!list)
    {
	eventlog(eventlog_level_error,"list_append_item","got NULL list");
	return -1;
    }
    
    for (tail=list; *tail; tail=&(*tail)->next);
    if (!(*tail = malloc(sizeof(t_list))))
    {
	eventlog(eventlog_level_error,"list_append_item","could not allocate memory for *tail");
	return -1;
    }
    (*tail)->next = NULL;
    (*tail)->data = data;
    
    return 0;
}


extern t_list * * list_find_item(t_list * * list, void const * data)
{
    t_list * * curr;
    
    if (!list)
    {
	eventlog(eventlog_level_error,"list_find_item","got NULL list");
	return NULL;
    }
    
    if (!*list)
	return NULL;
    
    curr = list;
    if ((*curr)->data==data)
	return curr;
    
    while ((*curr)->next && (*curr)->next->data!=data)
	curr = &(*curr)->next;
    
    if ((*curr)->next)
	return &(*curr)->next;
    
    return NULL;
}


extern int list_remove(t_list * * list)
{
    t_list const * curr;
    
    if (!list)
    {
	eventlog(eventlog_level_error,"list_remove_item","got NULL list");
	return -1;
    }
    
    curr = *list;
    if (!curr)
        return -1;
    
    *list = curr->next;
    pfree((void *)curr,sizeof(t_list *)); /* avoid warning */
    return 0;
}


extern int list_remove_item(t_list * * list, void const * data)
{
    t_list * * pos;
    
    if (!(pos = list_find_item(list,data)))
	return -1;
    
    return list_remove(pos);
}


extern int list_set_item(t_list * list, void * data)
{
    if (!list)
    {
	eventlog(eventlog_level_error,"list_set_item","got NULL list");
	return -1;
    }
    list->data = data;
    
    return 0;
}


extern void * list_get_item(t_list const * list)
{
    if (!list)
    {
	eventlog(eventlog_level_error,"list_get_item","got NULL list");
	return NULL;
    }
    return list->data;
}


extern void * list_get_item_by_pos(t_list const * list, unsigned int pos)
{
    t_list const * curr;
    unsigned int   len;
    
    for (len=0,curr=list; curr; curr=curr->next,len++)
	if (len==pos)
	    return curr->data;
    
    eventlog(eventlog_level_error,"list_get_item_by_pos","requested position %u but len=%u",pos,len);
    return NULL;
}


extern t_list const * const * list_get_next_const(t_list const * list)
{
    if (!list)
    {
	eventlog(eventlog_level_error,"list_get_next_const","got NULL list");
	return NULL;
    }
    return (t_list const * const *)&list->next; /* avoid warning */
}


extern t_list * * list_get_next(t_list * list)
{
    if (!list)
    {
	eventlog(eventlog_level_error,"list_get_next","got NULL list");
	return NULL;
    }
    return &list->next;
}
