/*
 * Copyright (C) 1998  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_GAME_TYPES
#define INCLUDED_GAME_TYPES

#ifdef GAME_INTERNAL_ACCESS
#ifdef JUST_NEED_TYPES
#include "account.h"
#include "connection.h"
#else
#define JUST_NEED_TYPES
#include "account.h"
#include "connection.h"
#undef JUST_NEED_TYPES
#endif
#endif

typedef enum
{
    game_type_none,
    game_type_all,
    game_type_melee,
    game_type_ffa,
    game_type_oneonone,
    game_type_ctf,
    game_type_greed,
    game_type_slaughter,
    game_type_sdeath,
    game_type_ladder,
    game_type_mapset,
    game_type_teammelee,
    game_type_teamffa,
    game_type_teamctf,
    game_type_pgl,
    game_type_diablo
} t_game_type;

typedef enum
{
    game_status_started,
    game_status_full,
    game_status_open,
    game_status_done
} t_game_status;

typedef enum
{
    game_result_none,
    game_result_win,
    game_result_loss,
    game_result_draw,
    game_result_disconnect,
    game_result_playing
} t_game_result;


typedef struct game
#ifdef GAME_INTERNAL_ACCESS
{
    char const *     name;
    char const *     pass;
    char const *     info;
    t_game_type      type;
    char const *     clienttag; /* type of client (STAR, SEXP, etc) */
    unsigned int     addr; /* host IP */
    unsigned short   port; /* host port */
    int              version;
    t_game_status    status;
    unsigned int     ref; /* current number of players */
    unsigned int     count; /* max number of players */
    unsigned int     id;
    
    t_connection * * connections;
    t_account * *    players;
    t_game_result *  results;
    char const * *   report_heads;
    char const * *   report_bodies;
    
    unsigned int     create_time;
    unsigned int     start_time;
    int              bad; /* if 1, then the results will be ignored */
}
#endif
t_game;

#endif


#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_GAME_PROTOS
#define INCLUDED_GAME_PROTOS

#define GAME_VERSION_UNKNOWN 0
#define GAME_VERSION_1 1
#define GAME_VERSION_3 3
#define GAME_VERSION_4 4

#define JUST_NEED_TYPES
#include "account.h"
#include "connection.h"
#include "list.h"
#undef JUST_NEED_TYPES

extern char const * game_type_get_str(t_game_type type);
extern char const * game_status_get_str(t_game_status status);
extern char const * game_result_get_str(t_game_result result);

extern t_game * game_create(char const * name, char const * pass, char const * info, t_game_type type, int version, char const * clienttag);
extern unsigned int game_get_id(t_game const * game);
extern char const * game_get_name(t_game const * game);
extern t_game_type game_get_type(t_game const * game);
extern char const * game_get_pass(t_game const * game);
extern char const * game_get_info(t_game const * game);
extern unsigned int game_get_version(t_game const * game);
extern unsigned int game_get_ref(t_game const * game);
extern unsigned int game_get_count(t_game const * game);
extern void game_set_status(t_game * game, t_game_status status);
extern t_game_status game_get_status(t_game const * game);
extern unsigned short game_get_port(t_game const * game);
extern int game_set_port(t_game * game, unsigned int port);
extern unsigned int game_get_addr(t_game const * game);
extern int game_set_addr(t_game * game, unsigned int addr);
extern unsigned int game_get_latency(t_game const * game);
extern char const * game_get_clienttag(t_game const * game);
extern int game_add_player(t_game * game, char const * pass, int version, t_connection * c);
extern int game_del_player(t_game * game, t_connection * c);
extern int game_check_result(t_game * game, t_account * account, t_game_result result);
extern int game_set_result(t_game * game, t_account * account, t_game_result result, char const * head, char const * body);
extern t_game_result game_get_result(t_game * game, t_account * account);
extern void gamelist_init(void);
extern int gamelist_get_length(void);
extern t_game * gamelist_find_game(char const * name, t_game_type type);
extern t_game * gamelist_get_first(t_list const * const * * save);
extern t_game * gamelist_get_next(t_list const * const * * save);
extern int gamelist_total_games(void);

#endif
#endif
