/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __SEND_H__
#define __SEND_H__

#include "bezerk.h"

#define BUFFLEN 520

typedef struct _UserCommand {
  char *name;
  char *command;
  int (*func)(char *, char *, BezBaseWindow *);
}UserCommand;

typedef struct _Alias {
  char *name;
  char *value;
}Alias;

#define USER_COMMAND(c) \
        int c(char *command, char *args, BezBaseWindow *window)    

int send_issue_command(char *text, BezWindow *window);

USER_COMMAND(bezerk_version);
USER_COMMAND(run_tcl);
USER_COMMAND(send_command);
USER_COMMAND(send_args);
USER_COMMAND(send_colon_args);

USER_COMMAND(send_away);
USER_COMMAND(send_invite);
USER_COMMAND(send_join);
USER_COMMAND(send_mode);
USER_COMMAND(send_nick);
USER_COMMAND(send_notice);
USER_COMMAND(send_part);
USER_COMMAND(send_privmsg);
USER_COMMAND(send_quit);
USER_COMMAND(send_quote);
USER_COMMAND(send_topic);

USER_COMMAND(add_alias);

#endif /* __SEND_H__ */
