/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __CALLBACK_H__
#define __CALLBACK_H__

#include "bezerk.h"

void destroy_main (GtkWidget *widget, BezChannelWindow *window);
void destroy_channel_window (GtkWidget *widget, BezChannelWindow *window);
void destroy_message_window (GtkWidget *widget, BezMessageWindow *window);
gint lag_check_callback (gpointer data);
void toolbar_copy_callback (GtkWidget *widget, BezWindow *window);
void toolbar_paste_callback (GtkWidget *widget, BezWindow *window);
void toolbar_selection_received (GtkWidget *widget, GtkSelectionData *selection_data, 
				 BezWindow *window);
void toolbar_connect_callback (GtkWidget *widget, BezWindow *window);
void file_disconnect_callback (GtkWidget *widget, gpointer data);
void file_quit_callback (GtkWidget *widget, gpointer data);
void settings_options_callback(GtkWidget *widget, gpointer data);
void settings_aliases_callback(GtkWidget *widget, gpointer data);
void settings_user_callback(GtkWidget *widget, gpointer data);
void settings_fonts_callback(GtkWidget *widget, gpointer data);
void help_about_callback(GtkWidget *widget, gpointer data);
void console_entry_callback(GtkWidget *widget, BezWindow *window);
gint entry_key_press (GtkWidget *widget, GdkEventKey *event, BezBaseWindow *window);
void channel_clist_callback (GtkWidget *widget, gint row, gint column, 
			     GdkEventButton *bevent, BezChannelWindow *window);
void nick_clist_callback (GtkWidget *widget, gint row, gint column, 
			  GdkEventButton *bevent, BezChannelWindow *window);
/* Max IRC command length is 512 bytes */
#define BUFFSIZE 520

#endif /* __CALLBACK_H__ */
