static char rcsid[] = "$Id: hines_duplic.c,v 1.1 1997/05/28 23:11:50 dhb Exp $";

/* Version EDS21e 97/05/05, Erik De Schutter, BBF-UIA 12/95-5/97 */

/*
** $Log: hines_duplic.c,v $
** Revision 1.1  1997/05/28 23:11:50  dhb
** Initial revision
**
*/

#include "hines_ext.h"

/* Contains routine that duplicates an existing hines solver, so that an
**  additional cell can be simulated.  Tries to reuse as many tables as
**  possible. */

int do_duplicate(origsolve,newname,path)
	Hsolve	*origsolve;
	char	*newname,*path;
{
	int		argc;
	char    *argv[10];
	Hsolve	*hsolve;
	ElementList *list;
	int 	ncompts;
	Element	**compts;
	int 	i,no_elminfo;
	int		*elmnum;
	char    *CopyString();
	double  *chip,*origchip;
	int     *ops,*origops;
	int     nchip,nop;

	if (!(newname) || !(path)) {
	    printf("Usage: call solve DUPLICATE duplic_name duplic_path\n");
	    return(ERR);
	}
	if (!(origsolve->path) || !(origsolve->ncompts)) {
	    Error();
	    printf(" original must be SETUP first: DUPLICATE failed.\n",Pathname(origsolve));
	    return(ERR);
	}
	hsolve = (Hsolve *)GetElement(newname);
	if (!hsolve) {
	    /* copy the origsolve to make new solve */
	    argv[0] = "c_do_copy";
	    argv[1] = origsolve->name;
	    argv[2] = newname;
	    do_copy(3,argv);
	    hsolve = (Hsolve *)GetElement(newname);
	    if (!hsolve) {
		Error();
		printf(" copy of %s failed: DUPLICATE failed.\n",Pathname(origsolve));
		return(ERR);
	    }
	}


	hsolve->path=CopyString(path);
	hsolve->readflag=HDUPLICATE_T;
	hsolve->origsolve=origsolve;

	list = WildcardGetElement(path,0);
	if (hsolve->ncompts != list->nelements)
		return(ERR);
	compts=hsolve->compts = list->element;
	ncompts = hsolve->ncompts;
	elmnum = hsolve->elmnum;
	for (i=0;i<ncompts;i++) HsolveBlock(*compts++);

	no_elminfo=hsolve->no_elminfo;
	hsolve->no_elminfo=1;	/* don't recreate this info */
	switch (hsolve->chanmode) {
	    case 0 :
		if (h_hh_init(hsolve,0)) {
			h_failed(hsolve);
			return(ERR);
		}
		break;

	    case 2 :
	    case 3 :
	    case 4 :
		hsolve->ininfo=NULL;
		hsolve->outinfo=NULL;
		if (h2_init(hsolve)) {
		    h_failed(hsolve);
		    return(ERR);
		}
		if (do_hget_children(hsolve)) {
		    h_failed(hsolve);
		    return(ERR);
		}
		/* h_hh_chip_init routines */
		nop=hsolve->nops;
		nchip=hsolve->nchips;
		chip = hsolve->chip=(double *)calloc(nchip,sizeof(double));
		ops = hsolve->ops=(int *)calloc(nop,sizeof(int));
		if (hsolve->storemode) hsolve->itotal=(double *)calloc(hsolve->nelm_names,sizeof(double));
		origops=origsolve->ops;
		for (i=0; i<nop; i++) *ops++=*origops++;
		origchip=origsolve->chip;
		for (i=0; i<nchip; i++) *chip++=*origchip++;
		if (hsolve->nconcs) {
		    if (h_init_conc_chip(hsolve)) {
			h_failed(hsolve);
			return(ERR);
		    }
		    if (h_init_conc_solve(hsolve)) {
			h_failed(hsolve);
			return(ERR);
		    }
		}
		break;

	    default :
		if (h_hh_init(hsolve)) {
		    h_failed(hsolve);
		    return(ERR);
		}
		break;
	}
	hsolve->no_elminfo=no_elminfo;	/* restore original setting */
	return(0);
}
