static char rcsid[] = "$Id: hh_update.c,v 1.5 1997/07/23 21:58:56 dhb Exp $";

/* Version EDS21d 97/03/13, Erik De Schutter, Caltech & BBF-UIA 4/92-3/97 */
/* Upinder S. Bhalla Caltech May-December 1991 */

/*
** $Log: hh_update.c,v $
** Revision 1.5  1997/07/23 21:58:56  dhb
** Added use of INLINE macro to control use of inline for
** upi_pow().  Defaults to empty resulting in no inlining.
** Set to inline to get inlining.
**
** Revision 1.4  1997/05/28 22:47:58  dhb
** Replaced with version from Antwerp GENESIS 21e
**
** Revision 1.3  1995/12/06 00:43:15  venkat
** Moved the non-hsolved channel elements into a seperately allocated
** element instead of using the int ops array. Was causing core-dumps on
** the 64-bit alpha machines - This version now uses a separately allocated
** element pointer array and the ops array indexes the right element.
**
** Revision 1.2  1995/07/18  17:56:53  dhb
** Changed all uses of struct Ca_shell_type to struct Ca_concen_type.
**
** Revision 1.1  1992/12/11  19:03:10  dhb
** Initial revision
**
*/

#include "hines_ext.h"

/* This file contains the routines for updating the coeffs of the 
** hh channels. These routines are non-object-oriented. These routines
** typically use the most cpu time.
*/ 

/*
** A utility function for do_hh_update()
*/

#ifndef INLINE
#define INLINE
#endif

INLINE double upi_pow(x,y)
	double x;
	float  y;
{
	double x1;

	if (y==2.0)
		return(x*x);
	if (y==1.0)
		return(x);
	if (y==3.0)
		return(x*x*x);
	if (y==4.0) {
		x*=x;
		return(x*x);
	}
	if (y==5.0) {
		x1=x;
		x*=x;
		x*=x*x1;
		return(x);
	}
	if (fabs(y)<VTINY) return(1.0);

	return(pow(x,y));
}


/* this is the plain vanilla, default version */

do_hh_update(hsolve)
	Hsolve	*hsolve;
{
	int	ncompts = hsolve->ncompts;
	int	*elmnum;
	struct compartment_type	**compts;
	Tcinfo	**hh;
	Tcinfo	*hentry;
	register int		i;
	double	dt;
	double	tby2;
	double	c,g,temp;
	double	TabInterp();
	Tchan	*h;
	register double v;
	double upi_pow();
	double X,Y,Z;
	float Xpow,Ypow,Zpow;

	elmnum = hsolve->elmnum;
	compts = (struct compartment_type **)hsolve->compts;
	hh=hsolve->hh;

	dt = Clockrate(hsolve);
	tby2 = dt/2.0;
	
	for(i=0;i<ncompts;i++) {
		if (!(hentry=hh[i]))
			continue;
		v = compts[elmnum[i]]->Vm;
		/* looping over all hh chans on this compt */
		for(;hentry;hentry=hentry->next) {
			h=(Tchan *)(hentry->chan);
			g=h->Gbar;
			if ((Xpow = h->Xpower) > TINY) {
				/* Trapezoid method of integration */
				temp=1.0+tby2*TabInterp(h->X_B,v);
				X=h->X=(h->X*(2.0-temp)+dt*TabInterp(h->X_A,v))/temp;
				g*=upi_pow(X,Xpow);
				h->X=X;
			}
			if ((Ypow = h->Ypower) > TINY) {
				if (h->Y_B) {
					temp=1.0+tby2*TabInterp(h->Y_B,v);
					Y=h->Y=(h->Y*(2.0-temp)+dt*TabInterp(h->Y_A,v))/temp;
				} else {
					Y=h->Y=(h->Y+dt*TabInterp(h->Y_A,v));
				}
				g*=upi_pow(Y,Ypow);
				h->Y=Y;
			}
			if ((Zpow = h->Zpower) != 0.0){
				c = MSGVALUE(hentry->conc,0);
				if (Zpow > TINY) {
					temp=1.0+tby2*TabInterp(h->Z_B,c);
					Z=(h->Z*(2.0-temp)+dt*TabInterp(h->Z_A,c))/temp;
					g*=upi_pow(Z,Zpow);
					h->Z=Z;
				} else { /* Zpow is negative */
					temp=1.0+tby2*TabInterp(h->Z_B,v);
					Z=(h->Z*(2.0-temp)+dt*(c*TabInterp(h->Z_A,v)))/
						temp;
					g*=upi_pow(Z,-Zpow);
					h->Z=Z;
				}
			}
			if(hentry->nernst) {
			    h->Ek = hentry->nernst->E;
			}
			if (g==0.0) {
				h->Gk=0.0;
				h->Ik=0.0;
			} else {
				h->Gk=g;
				h->Ik=g*(h->Ek - v);
			}
		}
	}
}

