
static char rcsid[] = "@(#)$Id: wildcards.c,v 1.2 1998/10/20 19:58:18 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*
 * Wildcard handling module for elm.
 */

#include <stdio.h>
#include "defs.h"

/*
 * Common wildcards.  Note that we count space as a wildcard, for
 * concatenation of individual unwildcarded file names.
 */

static char	sh_wildcards[] =   "[]*? " ;
static char	csh_wildcards[] =  "[]*?{} " ;

/* List of known shells and their wildcards.  Expand as needed. */

static struct	wildcard_list
{
	char	*shell_name ;
	char	*wildcard_chars ;
} known_shells[] = {
	{  "csh", csh_wildcards	},
	{  "sh", sh_wildcards },
	{  "ksh", sh_wildcards },
	{  "tcsh", csh_wildcards },
	{  "bash", sh_wildcards },
	{  "zsh", sh_wildcards },
	{  NULL, sh_wildcards }
} ;
 

/*
 * Function: has_wildcards.
 *
 * Scans the incoming file name for wildcard characters, returns
 * true if they are there and false otherwise.  Watch for escapes
 * (ie, preceeding backslash).
 *
 * One tricky part here -- different shells have different wildcarding
 * characters (yuck).  We need to examine the shell used, and set up
 * the right list.  If the shell isn't one we're familiar with, assume
 * Bourne shell.
 */


int
has_wildcards( name )
char *name ;
{
	static char		*user_wildcards = NULL ;
	char			*wildchar ;
	struct wildcard_list 	*wptr ;
	char			*user_shell ;
	char			*sh_name ;

	if ( NULL == user_wildcards )	/* Determine wildcards only once */
	{
		if ( NULL == ( user_shell = getenv( "SHELL" ) ) )
			user_wildcards = sh_wildcards ;
		else
		{
			if ( NULL != ( sh_name = rindex( user_shell, '/' ) ) )
				sh_name++ ;
			else
				sh_name = user_shell;

			for ( wptr = known_shells ; ( wptr->shell_name != NULL ) ; wptr++ )
				if ( 0 == strcmp( wptr->shell_name, sh_name ) )
					break ;
			user_wildcards = wptr->wildcard_chars ;
		}
	}

	/* If unescaped wildcard chars found, return true */

	for ( wildchar = name ; NULL != ( wildchar = strpbrk( wildchar, user_wildcards ) ) ; wildchar++ )
	{
		if ( *( wildchar - 1 ) != '\\' ) {
			if (wildchar - name < 3)
				return TRUE;
			/* elm predoubles the backslashes */
			if ( *( wildchar - 3 ) != '\\' )
				return TRUE ;
		}
	}
	return FALSE ;
}
