
static char rcsid[] = "@(#)$Id: file_util.c,v 1.6.6.1 1999/08/27 04:06:11 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.6.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** File oriented utility routines for ELM 

**/

#include "headers.h"
#include "s_elm.h"
#include <sys/stat.h>
#include <errno.h>
#include "me.h"

extern int errno;		/* system error number */

char *error_description(), *getlogin();
long  fsize();

long bytes(name)
     char *name;
{
	int err;
	/** return the number of bytes in the specified file.  This
	    is to check to see if new mail has arrived....  (also
	    see "fsize()" to see how we can get the same information
	    on an opened file descriptor slightly more quickly)
	**/

	int ok = 1;
	struct stat buffer;

	if (stat(name, &buffer) != 0)
	  if (errno != 2) {
	    err = errno;
	    MoveCursor(elm_LINES, 0);
	    Raw(OFF);
	    dprint(1,(debugfile,
		     "Error: errno %s on fstat of file %s (bytes)\n", 
		     error_description(err), name));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorFstat,
			      "\nError attempting fstat on file %s!\n"),
		      name);
	    lib_error(FRM("** %s. **\n"), 
		      error_description(err));
	    emergency_exit(0);
	  }
	  else
	    ok = 0;
	
	return(ok ? (long) buffer.st_size : 0L);
}

static int copy_to_fh P_((FILE *from, FILE *to));
static int copy_to_fh(from, to)
     FILE *from; 
     FILE *to; 
{
  char buffer[VERY_LONG_STRING];
  int  len;
  
  rewind(from);
  while ((len = fread(buffer, 1, VERY_LONG_STRING, from)) > 0) {
    if (fwrite(buffer, 1, len, to) != len) {
      int err = errno;
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedCopy,
			"Write failed in copy: %s: %s"), 
		      to, error_description(err));
      sleep_message();
      /*
       *  NEVER close anything just at whim!!
       *  If the file has been locked using fcntl() or lockf()
       *	YOU WILL DROP ALL LOCKS refering to the file.
       */
      fflush(to);
      return(1);
    }
  }

  if (ferror(from)) {
    int err = errno;
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReadFailedCopy2,
		      "Read failed in copy: %s"),
	      error_description(err));
    fflush(to);
    sleep_message();
    return(1);
  }
  
  if (fflush(to) == EOF) {
    int err = errno;
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFlushFailedCopy,
		      "Flush failed in copy: %s"), 
	      error_description(err));
    sleep_message();
    return(1);
  }
  return 0;
}

int copy_to_folder(from, to) 
     FILE * from;
     struct folder_info *to;
{
  int need_reopen = 1;
  int truncate_fh = -1;
  int code;

  dprint(10, (debugfile,
	      "copy_to_folder: folder=%X (%s)\n",
	      to,to->cur_folder));

  rewind(to->fh_folder);
#ifdef FTRUNCATE  
  if (0 == ftruncate(fileno(to->fh_folder),0)) {
    dprint(10, (debugfile,
		"copy_to_folder: truncated (ftruncate)\n"));
    need_reopen = 0;
  }
  else {
    int err = errno;
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantTruncateFolder,
		      "Sorry, can't truncate the folder %s [%s]!"),
	      to -> cur_folder, error_description(err));    
  }
#endif
  if (need_reopen) {
    truncate_fh = open(to->cur_folder,O_RDWR|O_TRUNC,0600);
    if (truncate_fh == -1) {
      int err = errno;

      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantTruncateFolder,
			"Sorry, can't truncate the folder %s [%s]!"),
		to -> cur_folder, error_description(err));    
      return 1;
    }
    dprint(10, (debugfile,
		"copy_to_folder- truncated (reopened)\n"));
  }
  code = copy_to_fh(from,to->fh_folder);

  /* In this point we may lost locks,
     but copy is already done */
  if (truncate_fh != -1)
    close(truncate_fh);

  dprint(10, (debugfile,
	      "copy_to_folder=%d\n",code));
  return code;
}

int copy1(from, to, isspool)
     FILE *from;
     char *to;
     int isspool;
{
	/** this routine copies a specified file to the destination
	  specified.  Non-zero return code indicates that something
	  dreadful happened! **/
  
  FILE  *to_file;
  int code;
  
  dprint (1, (debugfile, "Copy: to='%s'\n", to));
  
  
  if ((to_file = fopen(to, "w")) == NULL) {
    dprint(1, (debugfile, "Error: could not open %s for writing (copy)\n",
	       to));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotOpenFile,
		      "Could not open file %s."), 
	      to);
    sleep_message();
    return(1);
  }
  
  code = copy_to_fh(from,to_file);
  
  if (fclose(to_file) == EOF) {
    int err = errno;
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCloseFailedCopy,
		      "Close failed in copy: %s: %s"), 
	      to, error_description(err));
    sleep_message();
    return(1);
  }
  if (!isspool)
    (void) elm_chown( to, userid, groupid);

  return(code);
}

int
append(fd, filename, prefix_str)
FILE *fd;
char *filename;
char *prefix_str;
{
	/** This routine appends the specified file to the already
	    open file descriptor.. Returns non-zero if fails.  **/

	FILE *my_fd;
	char buffer[VERY_LONG_STRING];
	int  len;
	
	if ((my_fd = fopen(filename, "r")) == NULL) {
	  dprint(1, (debugfile,
		"Error: could not open %s for reading (append)\n", filename));
	  return(1);
	}

	if (prefix_str != NULL && fputs(prefix_str, fd) == EOF) {
	  MoveCursor(elm_LINES, 0);
	  Raw(OFF);
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedAppend,
			    "\nWrite failed to temp file in append\n"));
	  perror(filename);
	  rm_temps_exit();
	}

	while (len = fread(buffer, 1, VERY_LONG_STRING, my_fd))
	  if (fwrite(buffer, 1, len, fd) != len) {
	      MoveCursor(elm_LINES, 0);
	      Raw(OFF);
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedAppend,
				"\nWrite failed to temp file in append\n"));
	      perror(filename);
	      rm_temps_exit();
	  }

	if (fclose(my_fd) == EOF) {
	  MoveCursor(elm_LINES, 0);
	  Raw(OFF);
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCloseFailedAppend,
			    "\nClose failed on temp file in append\n"));
	  perror(filename);
	  rm_temps_exit();
	}

	return(0);
}

#define FORWARDSIGN	"Forward to "
int
check_mailfile_size(mfile)
char *mfile;
{
	/** Check to ensure we have mail.  Only used with the '-z'
	    starting option. So we output a diagnostic if there is
	    no mail to read (including  forwarding).
	    Return 0 if there is mail,
		   <0 if no permission to check,
		   1 if no mail,
		   2 if no mail because mail is being forwarded.
	 **/

	char firstline[SLEN];
	int retcode;
	struct stat statbuf;
	FILE *fp = NULL;

	/* see if file exists first */
	if (access(mfile, ACCESS_EXISTS) != 0)
	  retcode = 1;					/* no file */

	/* exists - now see if user has read access */
	else if (can_access(mfile, READ_ACCESS) != 0)
	  retcode = -1;					/* no perm */

	/* read access - now see if file has a reasonable size */
	else if ((fp = fopen(mfile, "r")) == NULL)
	  retcode = -1;		/* no perm? should have detected this above! */
	else if (fstat(fileno(fp), &statbuf) == -1) 
	  retcode = -1;					/* arg error! */
	else if (statbuf.st_size < 2)		
	  retcode = 1;	/* empty or virtually empty, e.g. just a newline */

	/* file has reasonable size - see if forwarding */
	else if (mail_gets (firstline, SLEN, fp) == 0)
	  retcode = 1;		 /* empty? should have detected this above! */
	else if (first_word_nc(firstline, FORWARDSIGN))
	  retcode = 2;					/* forwarding */

	/* not forwarding - so file must have some mail in it */
	else
	  retcode = 0;

	/* now display the appropriate message if there isn't mail in it */
	switch(retcode) {

	case -1:	printf(catgets(elm_msg_cat, ElmSet, ElmNoPermRead,
				"You have no permission to read %s!\n\r"),
				mfile);
			break;
	case 1:		printf(catgets(elm_msg_cat, ElmSet, ElmNoMail,
				"You have no mail.\n\r"));
			break;
	case 2:		no_ret(firstline) /* remove newline before using */
			printf(catgets(elm_msg_cat, ElmSet,ElmMailBeingForwarded,
				"Your mail is being forwarded to %s.\n\r"),
			  firstline + strlen(FORWARDSIGN));
			break;
	}
	if (fp)
	  fclose(fp);

	return(retcode);
}

long fsize(fd)
     FILE *fd;
{
	/** return the size of the current file pointed to by the given
	    file descriptor - see "bytes()" for the same function with
	    filenames instead of open files...
	**/

	struct stat buffer;

	/*
	 *  Make sure there is nothing in the stdio buffer
	 *  that is not also on the disk!!!!
	 */

	fflush (fd);			

	(void) fstat(fileno(fd), &buffer);

	return( (long) buffer.st_size );
}


/* Open and possible creates file for updates */

FILE *open_or_create(name)
     char *name;
{
  
  FILE *fp;
  int fd = open(name, O_RDWR | O_CREAT,0600);
  
  if (fd < 0) {
    int err = errno;
    dprint(1, (debugfile, 
	       "open_or_create: could not open file %s\n\tError: %s\n", 
	       name, error_description(err)));

    return NULL;
  }
  
  if (! (fp = fdopen(fd, "r+"))) {
    dprint(1, (debugfile, 
	       "open_or_create: could not fdopen(%d) file %s\n", 
	       fd,name));
    
    close(fd);
    return NULL;
  }  
  return fp;
}

/* Open and possible creates file for updates and seeks end of file. */
FILE *open_end_update(name)
     char *name;
{
  
  FILE *fp = open_or_create(name);
  if (!fp) {
    int err = errno;
    dprint(1, (debugfile, 
	       "open_end_update: could not open file %s\n\tError: %s\n", 
	       name, error_description(err)));

    return NULL;
  }
  
  if (0 != fseek(fp,0,SEEK_END)) {
    int err = errno;
    
    dprint(1, (debugfile, 
	       "open_end_update: could not seek to EOF %s\n\tError: %s\n", 
	       name, error_description(err)));
    
    fclose(fp);
    return NULL;
  }
  
  return fp;
}
