
static char rcsid[] = "@(#)$Id: quit.c,v 1.4.6.1 1999/08/27 04:06:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4.6.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** quit: leave the current folder and quit the program.
  
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include <errno.h>

extern int errno;		/* system error number on failure */

long bytes();
char *error_description();
extern void init_helpmsg();

void quit(prompt)
     int prompt;
{

requit:
  if (current_folder) {
    int status;

    status = leave_mbox(FALSE, TRUE, prompt);
    if ( status == -1)
      /* new mail - leave not done - can't change to another file yet
       * check for change in mailfile_size in main() will do the work
       * of calling newmbox to add in the new messages to the current
       * file and fix the sorting sequence that leave_mbox may have
       * changed for its own purposes */
      return;
    
    if (status < 0) {
      int ans;
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
			"Failed to leave folder!"));
      sleep_message();
    
      if (!prompt) 
	return;
    
    again1:
      ans = want_to("Failed to leave folder: Try to quit again ? [P]anic",
		    *def_ans_no,elm_LINES,1);
      if (ans == ('L'&31)) {
	ClearScreen();      
	goto again1;
      }
      if (ans == *def_ans_no)
	return;
      if (ans == *def_ans_yes) {
	clear_error();
	goto requit;
      }
      if (ans == 'P')
	emergency_exit(0);
      return;
    }
  }
  leave(0);
}

int
resync()
{
  /** Resync on the current folder. Leave current and read it back in.
    Return indicates whether a redraw of the screen is needed.
    **/
  int  err;

  if (current_folder) {
    int result;

    result = leave_mbox(TRUE, FALSE, TRUE);
    if( result == -1)
      /* new mail - leave not done - can't change to another file yet
       * check for change in mailfile_size in main() will do the work
       * of calling newmbox to add in the new messages to the current
       * file and fix the sorting sequence that leave_mbox may have
       * changed for its own purposes */
      return(FALSE);

    if (result < 0) {
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedResyncFolder,
			"Failed to resync folder!"));
      sleep_message();
      return FALSE;
    }
  
    if ((errno = can_access(current_folder->cur_folder, READ_ACCESS)) != 0) {
      if (strcmp(current_folder->cur_folder, defaultfile) != 0 || 
	  errno != ENOENT) {
	err = errno;
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	dprint(1, (debugfile,
		   "Error: given file %s as folder - unreadable (%s)!\n", 
		   current_folder->cur_folder, error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenFolderRead,
			  "Can't open folder '%s' for reading!\n"), 
		  current_folder->cur_folder);
	leave(0);
      }
    }
    
    newmbox(current_folder->cur_folder, FALSE);
  }
  return(TRUE);
}

char helpmsg[VERY_LONG_STRING];

change_file()
{
	  /* Prompt user for name of folder to change to.
	   * If all okay with that folder, leave the current folder.
	   * If leave goes okay (i.e. no new messages in current folder),
	   * change to the folder that the user specified.
	   *
	   * Return value indicates whether a redraw is needed.
	   */

	  int redraw = FALSE;
	  char newfile[SLEN];

	  char	*nameof();


	  /* get new file name */

	  MoveCursor(elm_LINES-3, 30);
	  CleartoEOS();
	  PutLine0(elm_LINES-3, 38, catgets(elm_msg_cat, ElmSet, ElmUseForHelp,
					    "(Use '?' for help)"));
	  PutLine0(elm_LINES-2,0, catgets(elm_msg_cat, ElmSet, 
					  ElmChangeToWhichFolder,
					  "Change to which folder: "));
	  while(1) {
	    int status;

	    newfile[0] = '\0';
	    status = optionally_enter(newfile, elm_LINES-2, 24, 
				      OE_REDRAW_MARK, sizeof newfile);
	    while (REDRAW_MARK == status) {
	      redraw = TRUE;
	      PutLine0(elm_LINES-3, 38, 
		       catgets(elm_msg_cat, ElmSet, ElmUseForHelp,
			       "(Use '?' for help)"));
	      PutLine0(elm_LINES-2,0, 
		       catgets(elm_msg_cat, ElmSet, 
			       ElmChangeToWhichFolder,
			       "Change to which folder: "));
	      status = optionally_enter(newfile, elm_LINES-2, 24, 
					OE_REDRAW_MARK|OE_APPEND_CURRENT,
					sizeof newfile);
	    }

	    clear_error();

	    if(0 != status || *newfile == '\0') {  /* if user didn't enter a file name */
	      MoveCursor(elm_LINES-3, 30);         /* abort changing file process */
	      CleartoEOS();
	      return(redraw);

	    }
	    if (strcmp(newfile, "?") == 0) {

	      /* user wants to list folders */
	      if(!*helpmsg) 	/* format helpmsg if not yet done */
		init_helpmsg( helpmsg, change_word, FALSE, sizeof helpmsg );
	      ClearScreen();
	      printf( helpmsg ) ;

	      /* reprompt */
	      PutLine0(elm_LINES-2,0,catgets(elm_msg_cat, ElmSet, 
					     ElmChangeToWhichFolder,
					     "Change to which folder: "));
	      
	      redraw = TRUE;		/* we'll need to clean the screen */
	      continue ;
	    }

	    /* if user entered wildcard, list expansions and try again */
	    if ( has_wildcards( newfile ) ) {
	      list_folders( 4, NULL, newfile ) ;

	      /* reprompt */
	      PutLine0(elm_LINES-2,0,catgets(elm_msg_cat, ElmSet, 
					     ElmChangeToWhichFolder,
					     "Change to which folder: "));
	      redraw = TRUE ;
	      continue ;  
	    }

	    /* user entered a file name - expand it */
	    if (! expand_filename(newfile, TRUE, sizeof newfile))
	      continue;	/* prompt again */

	    /* don't accept the same file as the current */
	    if (current_folder && 
		strcmp(newfile, current_folder->cur_folder) == 0) {
	      lib_error(CATGETS(elm_msg_cat, ElmSet, 
				ElmAlreadyReadingThatFolder,
				"Already reading that folder!"));
	      continue;	/* prompt again */
	    }

	    /* Make sure this is a file the user can open, unless it's the
	     * default mailfile, which is openable even if empty */
	    if ((errno = can_access(newfile, READ_ACCESS)) != 0 ) {
	      if (strcmp(newfile, defaultfile) != 0 || errno != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmCantOpenFolderReadNONL,
				  "Can't open folder '%s' for reading!"), 
			  newfile);
		continue; 	/* prompt again */
	      }
	    }
	    break;	/* exit loop - we got the name of a good file */
	  }

rechange:
	  /* All's clear with the new file to go ahead and leave the current. */
	  MoveCursor(elm_LINES-3, 30);
	  CleartoEOS();


	  if (current_folder) {
	    int result;
	    result = leave_mbox(FALSE, FALSE, TRUE);
	    if(result ==-1) {
	      /* new mail - leave not done - can't change to another file yet
	       * check for change in mailfile_size in main() will do the work
	       * of calling newmbox to add in the new messages to the current
	       * file and fix the sorting sequence that leave_mbox may have
	       * changed for its own purposes */
	      return(redraw);
	    }
	    
	    if (result < 0) {
	      int ans;
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
				"Failed to leave folder!"));
	      sleep_message();
	      
	    again1:
	      ans = want_to("Failed to leave folder: Try to change again ? [P]anic",
			    *def_ans_no,elm_LINES,1);
	      if (ans == ('L'&31)) {
		redraw = 1;
		ClearScreen();      
		goto again1;
	      }
	      if (ans == *def_ans_no)
		return redraw;
	      if (ans == *def_ans_yes) {
		clear_error();
		goto rechange;
	      }
	      if (ans == 'P')
		emergency_exit(0);
	      return redraw;
	    }
	  }

	  redraw = 1;
	  newmbox(newfile, FALSE);
	  return(redraw);
}
