
static char rcsid[] = "@(#)$Id: in_utils.c,v 1.3 1999/04/11 18:11:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Mindless I/O routines for ELM 
	
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include <errno.h>

extern int errno;		/* system error number */

unsigned alarm();

#define isstopchar(c)		(c == ' ' || c == '\t' || c == '/')
#define isslash(c)		(c == '/')
#define erase_a_char()		{ Writechar(BACKSPACE); Writechar(' '); \
			          Writechar(BACKSPACE); fflush(stdout); }

int want_to(question, dflt, where, clear_and_center)
     char *question;
     int dflt;
     int where, clear_and_center;
{
	/** Ask 'question' on 'where' left enough to just leave room for an
	    answer, returning the answer in lower case.
	    Echo answer as full "Yes" or "No".  'dflt' is the 
	    default answer if <return> is pressed. (Note: 'dflt' is also what 
	    will be returned if <return> is pressed!)
	**/
	register int ch, cols;

redraw:
	cols = elm_COLUMNS - (strlen(question) + 5 );	/* 5 for "Yes." + 1 */
	if (cols < 0) {
	    cols = 0;
	}

	MoveCursor(where, (clear_and_center || (cols < 2)) ? 0 : cols-2);
	CleartoEOLN();

	PutLineX(where, clear_and_center ? cols/2 : cols,
		 FRM("%s%c%c"), question, dflt, BACKSPACE);
	fflush(stdout);
	fflush(stdin);

	ch = ReadCh(REDRAW_MARK);
	if (ch == REDRAW_MARK)
	  goto redraw;
	if (ch == EOF) {
	  leave(0);
	}
	ch = tolower(ch);

	while (!( ch == *def_ans_yes || ch == *def_ans_no || ch == '\n' || ch == '\r')) {
	  ch = ReadCh(REDRAW_MARK);
	  if (ch == REDRAW_MARK)
	    goto redraw;
	  if (ch == EOF) {
	    leave(0);
	  }
#ifdef ASCII_CTYPE
	  if (isascii(ch))
#endif
	    ch = tolower(ch);
	}
	if(ch == '\n' || ch == '\r')
	  ch = dflt;

	if(ch == *def_ans_yes)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, "Yes."));
	else if (ch == *def_ans_no)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, "No."));
	else
	  return(ch); /* Don't write anything, just return */

	if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	MoveCursor(where, (clear_and_center || (cols < 2)) ? 0 : cols-2);
	CleartoEOLN();

	return(ch);
}

int read_number(ch, item)
     int ch;
     char *item;
{
	/** Read a number, where 'ch' is the leading digit! **/
	
	char buff[SLEN+1];
	int  num, status;

	buff[0] = ch;
	buff[1] = '\0';

redraw:
	PutLineX(elm_LINES-3, elm_COLUMNS-40,
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmSetCurrentTo,
			 "Set current %s to :"), item);
	status = optionally_enter(buff, elm_LINES-3, elm_COLUMNS-15, 
				  OE_APPEND_CURRENT|OE_REDRAW_MARK,
				  sizeof buff);
	if (status == -1)
	  return(current);
	if (status == REDRAW_MARK)
	  goto redraw;

	if (buff[0] == '\0')
	  return(current);

	sscanf(buff,"%d", &num);
	return(num);
}

int optionally_enter(string, x, y, flags, size)
     char *string;
     int  x,y,flags; 
     int size;
{
  int append_current = 0 != (flags & OE_APPEND_CURRENT);
  int passwd         = 0 != (flags & OE_PASSWD);
  int redraw         = (flags & OE_REDRAW_MARK) ? REDRAW_MARK : 0;

	/** This will display the string on the screen and allow the user to
	    either accept it (by pressing RETURN) or alter it according to
	    what the user types.   The various flags are:
	         string    is the buffer to use (with optional initial value)
	 	 x,y	   is the location we're at on the screen (-1,-1 means
			   that we can't use this info and need to find out
			   the current location)
		 append_current  means that we have an initial string and that
			   the cursor should be placed at the END of the line,
			   not the beginning (the default).
		 passwd	   accept non-printing characters and do not echo
			   entered characters.
	      
	    If we hit an interrupt or EOF we'll return non-zero.
	**/

	int ch;
	register int ch_count = 0, iindex = 0, escaped = OFF;
	register int len = strlen(string);

	if(!passwd) {
	  if(!(x >=0 && y >= 0))
	    GetXYLocation(&x, &y);
	  PutLineX(x, y, FRM("%s"), string);	
	}

	CleartoEOLN();

	if (! append_current) {
	  MoveCursor(x,y);
	}
	else
	  iindex = strlen(string);

	if (iindex > size-1) {
	  iindex = size-1;
	  string[iindex] = '\0';
	}

	/** now we have the screen as we want it and the cursor in the 
	    right place, we can loop around on the input and return the
	    string as soon as the user presses <RETURN>
	**/

	do {
	  ch = ReadCh(redraw|READCH_NOCURSOR);

	  if (ch == REDRAW_MARK) {
	    if (ch_count > 0)
	      string[iindex] = '\0';
	    return REDRAW_MARK;
	  }

	  if (ch == eof_char && !escaped
	      || ch == EOF) {		/* we've hit EOF */

	    if (ch_count > 0)
	      string[iindex] = '\0';
	    return(1);
	  }

	  if (ch_count++ == 0) {
	    if (ch == '\n' || ch == '\r') {
	      return(0);
	    }
	    else if (! append_current) {
	      CleartoEOLN();
	      iindex = (append_current? strlen(string) : 0);
	    }
	  }

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	  if (ch == backspace &&
	    (!escaped || (
			  (
#ifdef ASCII_CTYPE
			  !isascii(ch)||
#endif
			  !isprint(ch))
			  && !passwd))) {
	    /* This is tricky. Here we are dealing with all situations
	     * under which a backspace (really whatever erase char is
	     * set to, not necessarily \b) erases the previous character.
	     * It will erase unless escaped, because if it's escaped
	     * it is taken literally. There is one exception to that --
	     * if backspace would be rejected (we don't accept non-printing
	     * characters in non-passwd mode), we accept it here as an
	     * erasing character, for it if got rejected there would
	     * be no way of erasing a preceding backslash. */
	    escaped = OFF;
	    if (iindex > 0) {
	      if(!passwd)
		Writechar(BACKSPACE);
  	      iindex--;
	    }
	    if(!passwd) {
	      Writechar(' ');
	      Writechar(BACKSPACE);
	      fflush(stdout);
	    }
	  }
	  else if (ch == '\n' || ch == '\r') {
	    string[iindex] = '\0';
	    return(0);
	  }
	  else if (!passwd && ch == word_erase && !escaped) {	/* back up a word! */
	    escaped = OFF;
	    if (iindex == 0)
	      continue;		/* no point staying here.. */
	    iindex--;
	    if (isslash(string[iindex])) {
	      erase_a_char();
	    }
	    else {
	      while (iindex >= 0 && isspace(string[iindex])) {
	        iindex--;
	        erase_a_char();
	      }

	      while (iindex >= 0 && ! isstopchar(string[iindex])) {
	        iindex--;
	        erase_a_char();
	      }
	      iindex++;	/* and make sure we point at the first AVAILABLE slot */
	    }
	  }
	  else if (!passwd && ch == reprint_char && !escaped) {
	    escaped = OFF;
	    string[iindex] = '\0';
	    PutLineX(x,y, FRM("%s"), string);	
	    CleartoEOLN();
	  }
	  else if (!passwd && ch == ctrl('L') && redraw) {
	    string[iindex] = '\0';
	    ClearScreen();
	    PutLineX(x,y, FRM("%s"), string);	
	    CleartoEOLN();
	    return REDRAW_MARK;
	  }
	  else if (!escaped && ch == kill_line) {
	    /* needed to test if escaped since kill_line character could
	     * be a desired valid printing character */
	    escaped = OFF;
	    if(!passwd) {
	      MoveCursor(x,y);
	      CleartoEOLN();
	    }
	    iindex = 0;
	  }
	  else if (ch == '\0' || 
		   ch == interrupt_char && !escaped) {
	    string[0] = '\0'; /* clean up string, and... */
	    return(-1);
	  }
	  else if (!passwd && 
		   (
#ifdef ASCII_CTYPE
		    !isascii(ch) ||
#endif 
		    !isprint(ch))
		   ) {
	    /* non-printing character - warn with bell*/
	    /* don't turn off escaping backslash since current character
	     * doesn't "use it up".
	     */
	    Writechar('\007');
	  }
	  else {  /* default case */
	      if(escaped && (ch == backspace || ch == kill_line)) {
		/* if last character was a backslash,
		 * and if this character is escapable
		 * simply write this character over it even if
		 * this character is a backslash.
		 */
		if(!passwd)
		  Writechar(BACKSPACE);
		iindex--;
		string[iindex++] = ch;
		if(!passwd)
		  Writechar(ch);
	        escaped = OFF;
	      } else {
		string[iindex++] = ch;
		if(!passwd)
		  Writechar(ch);
		escaped = ( ch == '\\' ? ON : OFF);
	      }
	  }
	} while (iindex < size-1);

	string[iindex] = '\0';

	return(0);
}

int pattern_enter(string, alt_string, x, y, alternate_prompt, 
		  string_size, alt_string_size)
     char *string, *alt_string, *alternate_prompt;
     int  x,y;
     int string_size,alt_string_size;
{
	/** This function is functionally similar to the routine
	    optionally-enter, but if the first character pressed
	    is a '/' character, then the alternate prompt and string
	    are used rather than the normal one.  This routine 
	    returns 1 if alternate was used, 0 if not
	**/

	int ch;
	register int iindex = 0, escaped = OFF;

	PutLineX(x, y, FRM("%s"), string);	
	CleartoEOLN();
	MoveCursor(x,y);

	ch = ReadCh(0|READCH_NOCURSOR);

	if (ch == '\n' || ch == '\r') {
	  return(0);	/* we're done.  No change needed */
	}
	
	if (ch == '/') {
	  int status;
	  PutLineX(x, 0, FRM("%s"), alternate_prompt);
	  CleartoEOLN();
	  status = optionally_enter(alt_string, x, strlen(alternate_prompt)+1,
				    OE_REDRAW_MARK,alt_string_size);
	  while (REDRAW_MARK == status) {
	    PutLineX(x, 0, FRM("%s"), alternate_prompt);
	    status = optionally_enter(alt_string, x, 
				      strlen(alternate_prompt)+1,
				      OE_REDRAW_MARK|OE_APPEND_CURRENT,
				      alt_string_size);
	  }

	  return(1);
	}

	CleartoEOLN();

	iindex = 0;

	if (ch == kill_line) {
	  MoveCursor(x,y);
          CleartoEOLN();
	  iindex = 0;
	}
	else if (ch != backspace) {
	  if(ch == '\\') escaped = ON;
	  Writechar(ch);
	  string[iindex++] = ch;
	}
	else if (iindex > 0) {
	  iindex--;
	  erase_a_char();
	}
	else {
	  Writechar(' ');
	  Writechar(BACKSPACE);
	}

	do {
	  fflush(stdout);
	  ch = ReadCh(0);

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	    if (ch == backspace &&
	      (!escaped || 
	       (
#ifdef ASCII_CTYPE
		!isascii(ch)||
#endif
		!isprint(ch))
	       ) ) {
	      /* This is tricky. Here we are dealing with all situations
	       * under which a backspace (really whatever erase char is
	       * set to, not necessarily \b) erases the previous character.
	       * It will erase unless escaped, because if it's escaped
	       * it is taken literally. There is one exception to that --
	       * if backspace would be rejected (we don't accept non-printing
	       * characters in non-passwd mode), we accept it here as an
	       * erasing character, for it if got rejected there would
	       * be no way of erasing a preceding backslash. */
	      escaped = OFF;
              if (iindex > 0) {
		iindex--;
		erase_a_char();
	      }
	      else {
		Writechar(' ');
		Writechar(BACKSPACE);
	      }
	    }
	    else if (ch == '\n' || ch == '\r') {
	      escaped = OFF;
	      string[iindex] = '\0';
	      return(0);
	    }
	    else if (ch == word_erase && !escaped) {
	      escaped = OFF;
	      if (iindex == 0)
	        continue;		/* no point staying here.. */
	      iindex--;
	      if (isslash(string[iindex])) {
	        erase_a_char();
	      }
	      else {
	        while (iindex >= 0 && isspace(string[iindex])) {
	          iindex--;
	          erase_a_char();
	        }

	        while (iindex >= 0 && ! isstopchar(string[iindex])) {
	          iindex--;
	          erase_a_char();
	        }
	        iindex++;/* and make sure we point at the first AVAILABLE slot */
	      }
	    }
	    else if (ch == reprint_char && !escaped) {
	      escaped = OFF;
	      string[iindex] = '\0';
	      PutLineX(x,y, FRM("%s"), string);	
	      CleartoEOLN();
	    }
	    else if (!escaped && ch == kill_line) {
	      /* needed to test if escaped since kill_line character could
	       * be a desired valid printing character */
	      escaped = OFF;
	      MoveCursor(x,y);
              CleartoEOLN();
	      iindex = 0;
	    }
	    else if (ch == '\0' || 
		     ch == interrupt_char && !escaped) {
	      escaped = OFF;
	      fflush(stdin); 	/* remove extraneous chars, if any */
	      string[0] = '\0'; /* clean up string, and... */
	      return(-1);
	    }
	    else if (
#ifdef ASCII_CTYPE
		     !isascii(ch)||
#endif
		     !isprint(ch)) {
	      /* non-printing character - warn with bell*/
	      /* don't turn off escaping backslash since current character
	       * doesn't "use it up".
	       */
	      Writechar('\007');
	    }
	    else {  /* default case */
		if(escaped && (ch == backspace || ch == kill_line)) {
		  /* if last character was a backslash,
		   * and if this character is escapable
		   * simply write this character over it even if
		   * this character is a backslash.
		   */
		  Writechar(BACKSPACE);
		  iindex--;
		  string[iindex++] = ch;
		  Writechar(ch);
		  escaped = OFF;
		} else {
		  string[iindex++] = ch;
		  Writechar(ch);
		  escaped = ( ch == '\\' ? ON : OFF);
		}
	    }
	} while (iindex < string_size-1);

	string[iindex] = '\0';
	return(0);
}

int GetPrompt()
{
	/** This routine does a read/timeout for a single character.
	    The way that this was determined is that the routine to
	    read a character is called, then the "errno" is checked
	    against EINTR (interrupted call).  If they match, this
	    returns NO_OP_COMMAND otherwise it returns the normal
	    command.  On many systems, the EINTR will never be returned
	    so we instead longjmp from the signal handler.
	**/

	int ch;

	if (elm_timeout > 0) {
	  alarm((unsigned) elm_timeout);
	}
	if (SETJMP(GetPromptBuf)) {
	  InGetPrompt = 0;
	  ch = NO_OP_COMMAND;
	  alarm((unsigned) 0);
	}
	else {
	  errno = 0;
	  InGetPrompt = 1;
	  ch = ReadCh(0|READCH_CURSOR);
	  if (errno == EINTR)  ch = NO_OP_COMMAND;
#ifdef	EAGAIN
	  if (errno == EAGAIN) ch = NO_OP_COMMAND;
#endif
#ifdef	EWOULDBLOCK
	  if (errno == EWOULDBLOCK) ch = NO_OP_COMMAND;
#endif
	  InGetPrompt = 0;
	  alarm((unsigned) 0);
	}
	return(ch);
}

