static char rcsid[] = "@(#)$Id: aliaslib.c,v 1.9 1999/05/22 13:50:09 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Library of functions dealing with the alias system...

 **/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

char *get_alias_address(), *qstrpbrk();
extern int current_mail_message;

static void expand_list P_((
			    char *to,
			    struct addr_item *address,
			    int size));

struct expand {
  struct addr_item *addrs;
  int addrs_len;
};

static int add_ P_((struct expand *x, CONST char *ADR, 
		    CONST char *FN,
		    CONST char *COMMENT));
static int add_(x,ADR,FN,COMMENT)
     struct expand *x;
     CONST char *ADR;
     CONST char *FN;
     CONST char *COMMENT;
{
    x->addrs = safe_realloc(x->addrs,(x->addrs_len + 2) * 
			    sizeof (struct addr_item));
    x->addrs[x->addrs_len].addr       = safe_strdup(ADR);
    x->addrs[x->addrs_len].fullname   = safe_strdup(FN);
    x->addrs[x->addrs_len].comment    = safe_strdup(COMMENT);
    x->addrs[x->addrs_len+1].addr     = NULL;
    x->addrs[x->addrs_len+1].fullname = NULL;
    x->addrs[x->addrs_len+1].comment  = NULL;
    return x->addrs_len++;
}
#define ADD(x,ADR,FN,COMMENT) add_(&x,ADR,FN,COMMENT)

static int do_get_alias_l P_((
			      char *name,
			      struct expand *buffer,
			      int mailing,
			      int sysalias,
			      int depth,
			      int *too_longp));
/*
 * Expand the comma-delimited group of names in "group", storing the result
 * in "buffer".  Returns TRUE if expansion occurs OK, else FALSE in the
 * event of errors.
 */
static int do_expand_group_l P_((
				 char *group,
				 struct expand *buffer,
				 int sysalias,
				 int depth,
				 int *too_longp));

static int do_expand_group_l(group, buffer, sysalias, depth, too_longp)
     char *group;	     /* group list to expand			*/
     struct expand *buffer;  /* place to store result of expansion	*/
     int sysalias;	/* TRUE to suppress checks of the user's aliases*/
     int depth;	/* nesting depth					*/
     int *too_longp;	/* error code if expansion overflows buffer	*/
{
    char ** tokenized = rfc822_tokenize(group);
    char **ptr, **next = NULL;
    
    remove_space_tokenized(tokenized);  /* removes spaces and comments */
    
    for (ptr = tokenized; *ptr; ptr = next) {
	char * name = *ptr;
	int q_seen = 0;
	int q = 0;
	
	for (next = ptr; *next; next++) {
	    if (',' == (*next)[0] && !q)
		break;
	    else if ('<' == (*next)[0]) {
		q++;
		q_seen++;
	    } else if ('>' == (*next)[0])
		q--;
	}
	
	if (ptr+1 == next) {
	    /* see if this name is really an alias */
	    if (do_get_alias_l(name,buffer,TRUE,sysalias,depth,too_longp))
		continue;
	    
	    if ( *too_longp )
		return FALSE;
	    
	    /* verify it is a valid address */
	    if ( valid_name(name) ) {
		char * gecos = get_full_name(name);      
		int pos;
		
		if (!gecos)
		    gecos = "";
		
		/* Max alias expansion limit? */
		pos = add_(buffer,name,gecos,"");      
#ifdef USE_DOMAIN
		buffer->addrs[pos].addr = strmcat(buffer->addrs[pos].addr,"@");
		buffer->addrs[pos].addr = strmcat(buffer->addrs[pos].addr, hostfullname);
#endif
	    } else
		/* Max alias expansion limit? */
		add_(buffer,name,"","");      
	} else {  /* must have address .... */
	    char * buffer1 = NULL;
	    char ** scanner = NULL;
	    
	    for (scanner = ptr; scanner < next; scanner++) {
		if (buffer1 && q_seen && !q)
		    buffer1 = strmcat(buffer1," ");  /* Regenerate spaces for phrase */
		if ('<' == (*scanner)[0]) 
		    q++;
		else if ('>' == (*scanner)[0])
		    q--;
		buffer1 = strmcat(buffer1,*scanner);
	    }
	    
	    if (buffer1) {
		struct addr_item * address = 
		    break_down_address(buffer1, 
			     /* If user pastes encoded words from 
			      * somewhere decode them also.
			      */
				       is_rfc1522(buffer1) ?
				       rfc1522_decode_structured : 
				       decode_who_none);
		struct addr_item *ptr1;
		
		for (ptr1 = address; 
		     ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
		     ptr1++) {
		    /* Max alias expansion limit? */
		    add_(buffer,ptr1->addr,ptr1->fullname, ptr1->comment);
		}
		if (address)
		    free_addr_items(address);
		
		free(buffer1);
	    }      
	}
	
	if (*next &&
	    ',' == (*next)[0])
	    next++;
    }

    if (tokenized)
	free(tokenized);
    
    return TRUE;
}


static int do_get_alias_l(name, buffer, mailing, sysalias, depth, too_longp)
     char *name;	    /* name to expand as an alias		     */
     struct expand *buffer; /* place to store result of expansion	     */
     int mailing;	   /* TRUE to fully expand group names & recursive aliases	*/
     int sysalias;	   /* TRUE to suppress checks of the user's aliases  */
     int depth;	           /* recursion depth - initially call at depth=0    */
     int *too_longp;	   /* error code if expansion overflows buffer	     */
{
    char decode_buffer[VERY_LONG_STRING];  /* for MIME decoding */
    
    struct alias_rec *match = NULL;
    char * alias_address = NULL;
    char * alias_fullname = "";
    struct addr_item * address;
    int loc;
    
    /* update the recursion depth counter */
    ++depth;
    
    dprint(6, (debugfile, "%*s->attempting alias expansion on \"%s\"\n",
	       (depth*2), "", name));
    
    /* The next two blocks could be merged somewhat */
    /* check for a user alias, unless in the midst of sys alias expansion */
    if ( !sysalias &&
	 (loc = find_alias(name, USER)) >= 0)
	match = aliases[loc];

    /* check for a system alias */
    else if ( (loc = find_alias(name, SYSTEM)) >= 0 ) {
	match = aliases[loc];
	sysalias = TRUE;
    }
    
    /* nope...this name wasn't an alias */
    else
	return FALSE;
    
    alias_address = match->address;
    if ( 0 != (match->type & PERSON )) {
	alias_fullname = match->name;
	
	/* If user pastes encoded words from 
	 *	somewhere decode them also.
	 */
	
	if (is_rfc1522(alias_fullname)) {
	    strfcpy(decode_buffer,alias_fullname,sizeof decode_buffer);
	    rfc1522_decode(decode_buffer, sizeof buffer);
	    alias_fullname = decode_buffer;
	}
	
    }

    dprint(7, (debugfile, "%*s  ->expanded alias to \"%s\"\n",
	       (depth*2), "", alias_address));
    if (alias_fullname[0]) {
	dprint(7, (debugfile, "%*s  * fullname=\"%s\"\n",
		   (depth*2), "", alias_fullname));
    }
    
    /* check for an exact match */
    if (0 == strcmp(name,alias_address)) {
	add_(buffer,alias_address,alias_fullname,"");
	
	/* Max alias expansion limit? */
	return TRUE;
    }
  
    /* see if we are stuck in a loop */
    if ( depth > 12 ) {
	dprint(2, (debugfile,
		   "alias expansion loop detected at \"%s\" - bailing out\n", 
		   name));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorExpanding,
			  "Error expanding \"%s\" - probable alias definition loop."),
		  name);
	return FALSE;
    }
    
    /* see if the alias equivalence is a group name */
    if ( mailing && match->type & GROUP )
	return do_expand_group_l(alias_address,buffer,sysalias,depth,too_longp);
    
    /* see if the alias equivalence is an email address,
     * but not list of addresses. If address starts with @
     * then it is source-route address and not list of addresses
     */
    if (!(match->type & GROUP) &&
	('@' == alias_address[0] || qstrpbrk(alias_address,",") == NULL) &&
	qstrpbrk(alias_address,"!@:") != NULL ) {
	add_(buffer,alias_address,alias_fullname,"");
    
	/* Max alias expansion limit? */
	return TRUE;
    }
    
    /* see if the alias equivalence is itself an alias */
    if ( mailing && qstrpbrk(alias_address,",!@:") == NULL &&
	 do_get_alias_l(alias_address,buffer,TRUE,sysalias,depth,
			too_longp))
	return TRUE;
    
    /* the alias equivalence must just be a local address  or 
       list of addresses */
    
    address = 	  break_down_address(alias_address, 
				     /* If user pastes encoded words from 
				      *	somewhere decode them also.
				      */
				     is_rfc1522(alias_address) ?
				     rfc1522_decode_structured : 
				     decode_who_none);
    
    /* only one address -- take fullname from alias */
    if (address[0].addr && address[0].fullname &&
	!address[0].fullname[0] && !address[1].addr)
	add_(buffer,address[0].addr,alias_fullname,"");
    else {
	struct addr_item *ptr1;
	
	/* List of addresses */
	for (ptr1 = address; 
	     ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
	     ptr1++) {
	    /* Max alias expansion limit? */
	    add_(buffer,ptr1->addr,ptr1->fullname,ptr1->comment);
	}
	if (address)
	    free_addr_items(address);
    } 
    return TRUE;
}

struct addr_item *get_alias_address_l (name, mailing, too_longp)
     char *name; /* name to expand as an alias */
     int mailing; /* TRUE to fully expand group names & recursive aliases */
     int *too_longp; /* error code if expansion overflows buffer             */
{
    struct expand result;
    struct addr_item *bufptr = NULL;
    int are_in_aliases = TRUE;
    
    result.addrs_len   = 0;
    result.addrs = NULL;
    
    if (!inalias) {
	main_state();
	are_in_aliases = FALSE;
    }
    /*
     *	Reopens files iff changed since last read
     */
    open_alias_files(are_in_aliases);
    /*
     *	If name is an alias then return its expansion
     */
    
    if (do_get_alias_l(name,&result,mailing,FALSE,0,too_longp)) {
	bufptr = result.addrs;
	dprint(2, (debugfile,
		   "get_alias_address_l(%s) expands %d addresses.\n",
		   name,result.addrs_len));
    }
    else {
	/*
	 *  Nope...not an alias (or it was too long to expand)
	 */
	dprint(2, (debugfile,
		   "Could not expand alias in get_alias_address_l(%s)%s\n",
		   name, *too_longp ? "\t...alias buffer overflowed." : ""));
	if (result.addrs)
	    free_addr_items(result.addrs);
	bufptr = NULL;
    }
    
    if (! are_in_aliases)
	main_state();
    
    return(bufptr);
    
}

#if 0
/*
 * Expand "name" as an alias and return a pointer to static data containing
 * the expansion.  If "name" is not an alias, then NULL is returned.
 */
char *get_alias_address(name, mailing, too_longp)
     char *name;     /* name to expand as an alias	       		*/
     int mailing;   /* TRUE to fully expand group names & recursive aliases  */
     int *too_longp; /* error code if expansion overflows buffer       	*/
{
    static char buffer[VERY_LONG_STRING];
    char *bufptr = NULL;
    
    struct addr_item * addresses =  
	get_alias_address_l(name,mailing,too_longp);
    
    if (addresses) {
	expand_list(buffer,addresses, sizeof buffer);
	
	if (strlen(buffer) < sizeof buffer -1)
	    bufptr = buffer;
	else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmAliasExpTooLong,
			      "Alias expansion is too long."));
	    *too_longp = TRUE;
	}    
	free_addr_items(addresses);
    }
    
    if (!bufptr) {
	/*
	 *  Nope...not an alias (or it was too long to expand)
	 */
	dprint(2, (debugfile,
		   "Could not expand alias in get_alias_address()%s\n",
		   *too_longp ? "\t...alias buffer overflowed." : ""));
    }
    
    return(bufptr);
}

static void expand_list(to,address,size)
     char *to;
     struct addr_item *address;
     int size;
{
    struct addr_item *ptr;
    
    dprint(20,(debugfile,"expand_list - size=%d\n",size)); 
    
    to[0] = '\0';
    for (ptr = address; 
	 ptr && ptr -> addr && ptr->fullname; 
	 ptr++) {
	char buffer1[STRING];
        
	if (to[0] != '\0')
	    strfcat(to,", ", size);
	strfcat(to,buffer1, size);
	
	if (ptr->fullname[0] != '\0') {
	    elm_sfprintf(to + strlen(to), size - strlen(to),
			 FRM(" (%s)"), 
			 ptr->fullname);
	}
    }
    dprint(20,(debugfile,"expand_list - to=%s\n",to)); 
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */


