
static char rcsid[] = "@(#)$Id: pmalloc.c,v 1.2 1998/10/20 19:57:47 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine contains a cheap permanent version of the malloc call to 
    speed up the initial allocation of the weedout headers and the uuname 
    data.  

      This routine is originally from Jim Davis of HP Labs, with some 
    mods by me.
**/

#include <stdio.h>
#include "headers.h"
#include "s_elm.h"

extern nl_catd elm_msg_cat;	/* message catalog	    */
/*VARARGS0*/

#define MIN_BOUNDARY 8 /* power to 2 */

char *pmalloc(size)
int size; 
{
	/** return the address of a specified block **/

	static char *our_block = NULL;
	static int   free_mem  = 0;

	char   *return_value;

	/** if bigger than our threshold, just do the real thing! **/

	if (size > PMALLOC_THRESHOLD) 
	   return((char *) safe_malloc(size));

	/** if bigger than available space, get more, tossing what's left **/

	dprint(20, (debugfile,"pmalloc(size=%d)",size));

	size = ((size+(MIN_BOUNDARY-1)+4)/
		MIN_BOUNDARY)*MIN_BOUNDARY;	
	/* Go to MIN_BOUNDARY byte boundary, fill */

	dprint(20, (debugfile," rounding size to %d, free_mem=%d",size,
		    free_mem));

	if (size > free_mem-4) {
	  if ((our_block = (char *) malloc(PMALLOC_BUFFER_SIZE)) == NULL) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntMallocBytes,
			      "Couldn't malloc %d bytes!!"),
		      PMALLOC_BUFFER_SIZE);
	    (*safe_malloc_fail_handler)("pmalloc", PMALLOC_BUFFER_SIZE);
	    return NULL;
          }
	  dprint(20, (debugfile,", allocating=%lX (%d bytes)",
		      (long)our_block, PMALLOC_BUFFER_SIZE));;
	  our_block += 4;  /* just for safety, don't give back true address */
	  free_mem = PMALLOC_BUFFER_SIZE-4;

	}

	if (((long)our_block&(MIN_BOUNDARY-1)) != 0) {
	  int		drek;

	  drek = ((long)our_block&(MIN_BOUNDARY-1)); /* round to minimum */
	  our_block += (MIN_BOUNDARY-drek);
	  free_mem -= (MIN_BOUNDARY-drek);
	}

	return_value  = our_block;	/* get the memory */
	our_block += size;		/* use it up      */
	free_mem  -= size;		/*  and decrement */

	dprint(20, (debugfile,", returning=%lX (free_mem=%d)\n",
		    (long)return_value,free_mem));

	return( (char *) return_value);
}
