/********************************************************************************
*                                                                               *
*                         OpenGL Application coding sample                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: glviewer.cpp,v 1.3 1999/09/24 18:59:45 jeroen Exp $                     *
********************************************************************************/
#include "fx.h"
#include "fx3d.h"
#include <stdio.h>


#ifdef HAVE_OPENGL

// Front view
const unsigned char frontview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x64,0x00,0xf4,0xa4,0x60,0x00,0xff,0x00,0xff,0xff,0xff,0x00,0x80,0x00,0xff,
  0xff,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0x0a,0x11,0xfb,0xb0,0xc9,0x29,0x5f,0x10,0x4d,0xe8,0x8d,0x2d,0xbe,0x9c,
  0xe6,0x2c,0x60,0xb8,0x8d,0x24,0x35,0x41,0x43,0x40,0xbc,0xf0,0x8b,0x02,0x43,0x1b,
  0xc7,0xe8,0x44,0x48,0xbb,0x3b,0x15,0x40,0xdf,0xae,0xb7,0x03,0x1a,0x0b,0x42,0x17,
  0x2c,0x70,0x0c,0xaa,0x24,0x4d,0xa3,0x61,0x1a,0xad,0x4e,0x0d,0xd5,0xe8,0x35,0xdb,
  0xdc,0x56,0x13,0x00,0x3b
  };

// Back view
const unsigned char backview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x64,0x00,0xf4,0xa4,0x60,0x00,0xff,0x00,0xff,0xff,0xff,0x00,0x80,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x41,0x08,0xba,0x1c,0xc1,0xca,0xc9,0x29,0x9b,0xb8,0x38,0xbf,0x15,0xb2,0x17,0x5b,
  0xf4,0x69,0x10,0x35,0x0d,0x10,0x10,0x10,0x6c,0x4b,0x0c,0x70,0xe9,0xb2,0x70,0xad,
  0x4a,0x84,0x93,0xaf,0xb5,0x53,0xfc,0x2b,0x9d,0xae,0xf6,0x2b,0xae,0x66,0x30,0x01,
  0xac,0x58,0x30,0x49,0x04,0xcc,0xa8,0x14,0x2a,0xad,0x16,0xa8,0xd6,0x28,0x36,0x5b,
  0x4d,0x00,0x00,0x3b
  };
  
// Top view
const unsigned char topview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0x00,0x80,0x00,
  0x00,0xff,0x00,0x00,0x00,0x00,0xf4,0xa4,0x60,0xa5,0x2a,0x2a,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x1b,0x2e,0x82,0x40,0x25,0xa3,0xd8,0x3e,0xc1,0xbb,0xe7,0x8c,
  0x30,0x8c,0x64,0x29,0x84,0x65,0x3a,0x9c,0x8b,0x40,0xbc,0x70,0xcc,0x2a,0x2e,0x17,
  0xc3,0x33,0x20,0x72,0xea,0x8a,0xf6,0xa3,0xdc,0x67,0x98,0x5b,0x14,0x8e,0x1a,0x23,
  0x32,0x09,0x38,0x16,0x98,0xcd,0xa5,0x23,0x01,0x00,0x3b
  };
  
// Bottom view
const unsigned char bottomview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0x80,0x80,0x80,
  0xa9,0xa9,0xa9,0x00,0x64,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x2f,0x84,0x11,0x79,0xcb,0xa8,0xdd,0x52,0x80,0xf1,0x51,0x20,
  0xb2,0xde,0x79,0x09,0x09,0x4a,0x82,0x17,0x86,0xe3,0xf1,0x95,0x22,0xa9,0x26,0xe7,
  0x94,0xb6,0x2f,0xd6,0xba,0x47,0xc0,0xe5,0xa7,0x73,0x2d,0x13,0xd2,0x33,0xfc,0x7e,
  0xc1,0xe2,0xa1,0x00,0x00,0x3b
  };
  
// Left view
const unsigned char leftview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x64,0x00,0xf4,0xa4,0x60,0x00,0xff,0x00,0xff,0xff,0xff,0x00,0x80,0x00,0xff,
  0xff,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0x1b,0xfc,0x2c,0x48,0x08,0x83,0x10,0x8e,0xb6,0x7b,0x33,0xb5,0x5c,
  0x07,0x0d,0x80,0x64,0x9a,0xcf,0xa0,0x06,0x44,0xeb,0x7a,0x80,0x2a,0x13,0x66,0x0b,
  0x07,0x32,0xab,0xdb,0x67,0x91,0xd3,0x12,0x5b,0x61,0xe8,0x93,0x0d,0x5c,0x2f,0x22,
  0x51,0x50,0x38,0x9d,0x0c,0x50,0xc3,0x90,0xa9,0xac,0x56,0xa9,0xd6,0x2c,0x36,0xcb,
  0xed,0x0e,0x13,0x00,0x3b
  };
  
// Right view
const unsigned char rightview[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x64,0x00,0xf4,0xa4,0x60,0x00,0xff,0x00,0xff,0xff,0xff,0x00,0x80,0x00,0xff,
  0xff,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xb1,0xfe,0x2c,0x34,0x08,0x83,0x10,0x93,0x2a,0x7b,0xb1,0x1a,0x55,
  0xd7,0x05,0x43,0xf9,0x48,0x28,0x5a,0x82,0x4e,0x40,0xbc,0x30,0x29,0xb0,0xcc,0x8b,
  0x12,0x8d,0xb0,0xa5,0x36,0x8e,0x5b,0x92,0x82,0xb0,0xe0,0xfa,0xb9,0x02,0x05,0xc1,
  0x70,0x58,0x84,0xe1,0x96,0x86,0xa8,0x21,0x95,0x5a,0x5a,0xaf,0xd8,0xac,0x76,0xcb,
  0xcd,0x26,0x00,0x00,0x3b
  };


const unsigned char foxicon[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xa9,0xa9,0xa9,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x37,0x08,0xba,0xdc,0xfe,0x30,0xae,0x40,0x29,0xa8,0xca,0xd6,0xb0,0x04,0x0f,0x02,
  0x30,0x7c,0x23,0x27,0x9a,0xd7,0x70,0xad,0x98,0x37,0x85,0xeb,0x65,0xba,0x19,0x6c,
  0x5a,0xe7,0xa4,0x7e,0x72,0xf7,0x85,0xa3,0x14,0x2e,0x83,0xd3,0xa0,0x24,0x0f,0x82,
  0x72,0x49,0x40,0x3a,0x9f,0xd0,0x45,0x02,0x00,0x3b
  };


// Palette of colors
const unsigned char colorpal[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0x80,0x80,0x80,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0x00,0xff,0x00,0xff,0x00,0x00,0x00,
  0x00,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x47,0x08,0x0a,0xd1,0xfb,0x30,0x88,0xe9,0xe0,0x92,0x33,0x07,0xcb,0xf2,0xf8,0xd4,
  0xd3,0x64,0xc2,0x37,0x48,0x55,0x83,0x11,0x04,0x83,0x09,0x9b,0x23,0xb1,0x2d,0x49,
  0x6d,0xdd,0x42,0xc6,0x68,0x67,0xdf,0x23,0x58,0xa7,0x40,0x7c,0x05,0x85,0x12,0x62,
  0xe1,0x65,0xc3,0xa1,0x24,0x86,0x68,0x54,0x73,0xc9,0x48,0x0d,0x54,0xd1,0xf1,0x66,
  0x91,0xa9,0x70,0x11,0x30,0x07,0x90,0x00,0x00,0x3b
  };

// Save as
const unsigned char filesaveas[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf3,0x00,0x00,0x80,0x80,0x80,
  0xb2,0xc0,0xdc,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,
  0x00,0xff,0x00,0xff,0xff,0x00,0x00,0x80,0xc0,0xc0,0xc0,0x00,0x80,0x80,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x04,0x5a,0x10,0xc8,0x19,0xaa,0xbd,0x40,0x0c,
  0x91,0xc1,0xfd,0xc0,0x36,0x10,0x24,0xf1,0x59,0x99,0x58,0x4c,0x2c,0xba,0x19,0x5a,
  0x26,0xcc,0x9c,0x17,0x64,0xc6,0x01,0xcb,0x74,0x77,0xe7,0x07,0x9d,0x0c,0xc6,0x99,
  0x49,0x04,0x40,0x1d,0x12,0xd1,0x29,0x85,0x90,0x41,0xdd,0x81,0x39,0x4b,0x24,0x08,
  0x29,0x68,0x94,0x4a,0xc3,0x8a,0xb4,0x53,0x9e,0x00,0x5b,0x4a,0x86,0x69,0xe3,0x89,
  0x01,0xc1,0x6e,0x8b,0x4d,0x16,0x85,0x02,0x3b,0x41,0xc3,0x31,0x68,0xfb,0x09,0x50,
  0xea,0x93,0x22,0x00,0x3b
  };

// File Save
const unsigned char filesave[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x80,0x80,0x80,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xaa,0xb1,0xfe,0x4c,0x34,0x06,0xa3,0x90,0x20,0xcc,0x1a,0xae,0xc4,0x95,
  0x75,0x6d,0x8f,0xa6,0x79,0x64,0xa6,0x0d,0x44,0x87,0x9a,0x0c,0xc1,0x9a,0xb4,0x3c,
  0x05,0x33,0xad,0xd7,0x43,0x50,0x0c,0xbf,0x20,0x10,0xb8,0x6a,0x0d,0x85,0x42,0x8d,
  0x11,0x79,0xec,0x65,0x7a,0x4c,0x64,0x23,0xb0,0x6c,0x26,0x55,0xd6,0xe6,0x6d,0xc7,
  0x55,0x24,0x00,0x00,0x3b
  };


// File Open
const unsigned char fileopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0xff,0x00,0xff,0xff,0x00,0x80,0x80,0x80,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x45,0x08,0xba,0x1c,0xfe,0x2c,0xae,0x20,0x44,0x90,0x91,0xd6,0x8b,0x95,0xb6,0x1c,
  0x00,0x79,0x95,0x25,0x3e,0x03,0x31,0x3c,0xa5,0x73,0xaa,0xf0,0xda,0xae,0x5e,0xfa,
  0xdc,0xb8,0xa3,0x06,0xc5,0xd0,0xff,0x3e,0x9f,0xc3,0x16,0x04,0x02,0x75,0x81,0xa2,
  0xb2,0x77,0x49,0xf2,0x96,0xc5,0x26,0x21,0x69,0x54,0x36,0xa9,0x50,0xa6,0xe7,0x59,
  0xfd,0x71,0x72,0x60,0x4e,0x02,0x00,0x3b
  };

// Print
const unsigned char print[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x80,0x80,0x80,0x00,0x80,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x49,0x08,0x0a,0xd1,0xbd,0x10,0x06,0x41,0x5f,0x94,0x62,0xea,0xbb,0x66,0x75,0x1c,
  0x93,0x09,0x43,0x19,0x84,0x1e,0x55,0x5d,0x8e,0x40,0x04,0x6f,0x66,0x29,0x41,0x91,
  0xaa,0xf5,0x49,0x3b,0x7c,0x7f,0x06,0x25,0x92,0x70,0x30,0x24,0x35,0x0a,0xc8,0xa4,
  0x52,0x79,0xb4,0x39,0x99,0x35,0x5b,0x74,0x49,0x95,0xfa,0xae,0x8f,0x1a,0xa1,0xb0,
  0xed,0x72,0xb9,0xba,0x17,0xd6,0x41,0x00,0x24,0x00,0x00,0x3b
  };


// Zoom
const unsigned char zoom[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x4a,0x08,0x1a,0xd2,0x1d,0x2a,0xc6,0x17,0x46,0x60,0x42,0x2a,0x51,0x89,0x1d,0x20,
  0x23,0x31,0x03,0x61,0x82,0x28,0x37,0x05,0xa6,0x87,0x96,0xe2,0x66,0xb9,0x2f,0x98,
  0x6d,0x55,0x0d,0x7a,0x37,0x20,0x7c,0x3a,0xde,0x4a,0x57,0x22,0xc4,0x00,0xa4,0xda,
  0x49,0x35,0x6c,0x9d,0x18,0x10,0xc9,0x03,0x85,0x81,0x6a,0x30,0x8e,0x0b,0x87,0xa9,
  0xb9,0x0a,0x08,0xdc,0x6e,0x84,0x01,0x16,0x77,0xa1,0x09,0x00,0x3b
  };



// File new
const unsigned char filenew[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0xff,0xff,0x00,0xff,0xff,0xff,0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x48,0x08,0x0a,0xb1,0xfe,0xab,0x41,0x28,0x18,0xa8,0xd3,0x85,0x3d,0xfa,0x80,0x5b,
  0x28,0x0e,0x44,0x16,0x16,0x82,0x30,0x08,0xe5,0xa3,0x06,0x68,0xba,0xb2,0xd0,0x10,
  0x08,0x31,0x49,0xec,0x8f,0x9d,0xfe,0x85,0x20,0xe1,0xb3,0xf0,0xfd,0x8e,0x43,0xc7,
  0xec,0xf8,0x4b,0x16,0x99,0x48,0xa2,0x62,0x09,0x75,0x4e,0xa1,0x4d,0x29,0x40,0xb7,
  0xeb,0x76,0xb5,0x5b,0x8f,0xd8,0x03,0x48,0x00,0x00,0x3b
  };

// Cut
const unsigned char cut[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x29,0x84,0x8f,0xa9,0x10,0xd7,0xeb,0x22,0x34,0x8f,0x4d,0xda,
  0x42,0x9d,0xf9,0x3a,0xed,0x49,0xa1,0x10,0x08,0x21,0x60,0x0a,0xea,0xa4,0xa6,0x86,
  0xa9,0xc0,0x2e,0xba,0xc8,0xf4,0x9d,0xd8,0x28,0x5c,0xf3,0xe7,0x54,0x00,0x00,0x3b
  };
  
// Copy
const unsigned char copy[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x80,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x38,0x84,0x8f,0x69,0xc1,0xad,0x18,0x84,0x14,0xec,0xad,0x49,
  0xa9,0x8d,0x8c,0x8e,0x0f,0x42,0x98,0x30,0x60,0xdf,0xc1,0x35,0xe5,0x54,0x0e,0x97,
  0x49,0x45,0xa0,0x9b,0x32,0xeb,0x48,0xe3,0x71,0x43,0x02,0x8d,0x3a,0x92,0xb8,0x14,
  0xa5,0x9f,0xec,0x71,0x33,0x21,0x67,0x33,0x8b,0xf3,0x99,0x28,0x00,0x00,0x3b
  };
  
  
// Paste
const unsigned char paste[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xc0,0xc0,0xc0,0x80,0x80,0x00,0x80,0x80,0x80,0x00,
  0x00,0x80,0xff,0xff,0xff,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x4b,0x08,0xba,0xdc,0x1e,0x30,0x38,0x15,0xa1,0x10,0x55,0x52,0x52,0x48,0xc0,0x5f,
  0xd0,0x15,0x9a,0x48,0x0e,0x68,0x2a,0x7a,0x1b,0x99,0x41,0x05,0x49,0x8d,0x5c,0x4d,
  0x97,0x36,0x61,0xec,0xbc,0x51,0xd2,0x05,0xc3,0x61,0x38,0xdc,0xb5,0x6a,0x42,0xe2,
  0x41,0x68,0x00,0xac,0x46,0xc2,0xc8,0x92,0x17,0xc8,0x25,0x95,0xc5,0x27,0x27,0x9a,
  0x59,0x3a,0x2b,0x57,0x6c,0xb3,0xd1,0x2b,0x8f,0x27,0x93,0x04,0x00,0x3b
  };

  
// Property  
const unsigned char prop[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0x80,0xc0,0xc0,0xc0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0xae,0x21,0x4a,0x20,0x84,0x0b,0x23,0xeb,0x50,0x1b,0xc6,0x5a,
  0x56,0x49,0xd1,0xf0,0x85,0xc3,0x48,0x10,0xe7,0x99,0x71,0x42,0xc0,0x9a,0xf3,0x17,
  0x51,0x31,0x2b,0xaf,0x1f,0xcb,0xec,0xab,0xe0,0x2e,0xf0,0x0b,0x1a,0x85,0xc5,0x88,
  0x4e,0xe2,0x5b,0x00,0x8f,0xbc,0xa4,0x8c,0x34,0x2d,0x42,0x91,0x4e,0xaa,0xf6,0xc1,
  0x6d,0x24,0x00,0x00,0x3b
  };

// Delete
const unsigned char kill[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0xff,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x02,0x24,0x84,
  0x8f,0x79,0xc1,0xba,0xcb,0x82,0x6a,0x28,0x4a,0xe8,0x40,0x34,0x34,0xdb,0x9b,0x71,
  0x5d,0xf8,0x85,0x1a,0x35,0x56,0x63,0x7a,0x82,0x8f,0xca,0x6a,0xb0,0x59,0x99,0x2e,
  0x8d,0x2b,0x05,0x00,0x3b
  };

// No shading
const unsigned char nolight[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xc0,0xc0,0xc0,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x33,0x08,0x1a,0xac,0xfe,0x2e,0x88,0x19,0x20,0x94,0x02,0x57,0xbb,0xb2,0xdf,0x9c,
  0x24,0x66,0x5c,0x24,0x82,0x25,0xc0,0xa0,0x69,0x30,0xb0,0x0f,0x11,0xbd,0x1c,0x61,
  0x9b,0xb0,0x7d,0x3b,0x85,0xa5,0xef,0xa5,0x1f,0xb0,0x26,0x4c,0x09,0x87,0x90,0xa3,
  0x2c,0x65,0x49,0x00,0x00,0x3b
  };

// Shading
const unsigned char light[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0x80,0x80,0x00,0x00,0x00,0xff,0x80,
  0x80,0x80,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x34,0x08,0x10,0xac,0xfe,0x2e,0x88,0x19,0x20,0x94,0x62,0x50,0x1b,0xb3,0xaf,0xdc,
  0xe2,0x69,0x60,0xc8,0x08,0x4d,0x18,0xa5,0xaa,0x12,0x10,0xa5,0x55,0x14,0x2e,0xcc,
  0xcd,0xb3,0xcb,0x3a,0x78,0xae,0x18,0xb2,0x1e,0x2d,0x24,0xf4,0xdd,0x8a,0xc4,0xe2,
  0x30,0x88,0x6c,0x41,0x12,0x00,0x3b
  };
  
// Smooth shading
const unsigned char smoothlight[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x80,0x80,0x00,0x00,
  0x00,0xff,0x80,0x80,0x80,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x41,0x08,0x10,0xac,0xfe,0x2e,0x88,0x19,0x20,0x94,0x62,0x50,0x1b,0xb3,0xaf,0x16,
  0xb1,0x78,0x1a,0xf8,0x10,0xe8,0x22,0x35,0x9c,0xa8,0x30,0x20,0xea,0x2a,0x73,0x50,
  0xc4,0xb3,0x62,0x18,0xef,0x4d,0x03,0xae,0xdd,0xee,0xc5,0x72,0x10,0x84,0x43,0xc5,
  0xc1,0x82,0x4c,0x72,0x9a,0xce,0x9f,0x0e,0x7a,0x92,0x41,0xa3,0xc0,0x29,0x95,0xc3,
  0x4d,0x00,0x00,0x3b
  };

// Parallel projection
const unsigned char parallel[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x31,0x84,0x6f,0x11,0xc8,0xa7,0xa0,0x56,0x83,0x12,0xa6,0x4a,
  0x19,0x8e,0x6f,0x66,0x25,0x08,0x9d,0x53,0x81,0xa1,0xb8,0x8c,0xd7,0x79,0x62,0x24,
  0x1b,0x4a,0xa3,0xc9,0x6e,0x69,0x00,0x8b,0x0d,0x07,0xdb,0x08,0x2d,0x73,0xbd,0x22,
  0x9e,0x9f,0xb0,0x58,0x2c,0x00,0x00,0x3b
  };
  
// Perspective projection
const unsigned char perspective[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x2d,0x84,0x8f,0xa9,0x10,0xbb,0x01,0xa1,0x33,0xad,0x51,0x9b,
  0x2c,0xbe,0x08,0x6f,0x26,0x31,0xdd,0x11,0x56,0x1f,0x38,0x06,0x42,0x79,0x56,0xc2,
  0x1b,0xa2,0x14,0xf3,0xae,0x8a,0xa4,0xa9,0x27,0x47,0x46,0xbe,0x3f,0x09,0x0a,0x87,
  0x8b,0x02,0x00,0x3b
  };

// New folder
const unsigned char newfolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x30,0x84,0x8f,0xa9,0x19,0xeb,0xbf,0x1a,0x04,0xf2,0x54,0x1a,
  0xb2,0x69,0x1c,0x05,0x31,0x80,0x52,0x67,0x65,0xe6,0xb9,0x51,0x54,0xc8,0x82,0xe2,
  0xf5,0xb5,0x2d,0xb9,0xba,0xf2,0xb8,0xd9,0xfa,0x55,0xcb,0x22,0xa3,0x9b,0x31,0x4e,
  0x44,0xde,0x24,0x51,0x00,0x00,0x3b
  };
  
const unsigned char penguin[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x12,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x10,0x10,0x10,0xff,0xff,0xff,0xe0,
  0xa0,0x08,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x12,0x00,0x00,0x03,
  0x53,0x08,0xba,0x21,0x12,0x2b,0xc6,0xe6,0x9e,0x94,0x62,0x64,0x77,0xa3,0x20,0x4e,
  0x21,0x74,0x8b,0x60,0x9c,0x1a,0xa9,0x98,0xa8,0x45,0xb2,0x85,0x38,0x76,0x4f,0x6c,
  0xbb,0x93,0x60,0xdb,0x0d,0xe4,0xd9,0x83,0x1d,0xe7,0x57,0x18,0x04,0x6f,0xb8,0x4c,
  0xec,0x88,0x9c,0x01,0x0c,0x47,0x66,0xac,0xa2,0x38,0x19,0x76,0x36,0x83,0xc3,0xf0,
  0xb4,0x5e,0x77,0x03,0xaf,0xf8,0x7b,0x13,0x77,0xad,0xd3,0xad,0x75,0x61,0xa5,0x54,
  0x02,0x27,0x45,0x02,0x00,0x3b
  };


// Application icon
const unsigned char winapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x10,0x30,0xca,0x09,0x85,0xbd,0xf8,0x86,0x11,0x04,0xf9,0x60,
  0xf8,0x6d,0x9d,0x48,0x14,0x03,0x8a,0x92,0x02,0xe5,0x72,0x42,0x21,0xcf,0xb4,0xcc,
  0xd6,0x78,0x71,0xe7,0xf4,0xce,0xdb,0xb0,0xdf,0xcc,0xf7,0x23,0xf2,0x48,0xae,0xd7,
  0x60,0xc9,0x6c,0x3a,0x07,0x8e,0xe8,0x22,0x01,0x00,0x3b
  };

  
// Camera picture  
const unsigned char camera[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0x00,0x00,0x00,
  0xc0,0xc0,0xc0,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x29,0x18,0xba,0xdc,0xfe,0x8d,0xc8,0x49,0x60,0x00,0x38,0xe7,0xa7,0x3b,0x07,0x42,
  0x07,0x2c,0x98,0x82,0x85,0xa2,0x66,0xa6,0xe2,0x8a,0x0d,0xec,0x78,0x65,0xf0,0xb6,
  0xba,0xad,0x13,0x7f,0xb9,0xe5,0xff,0xc0,0x5f,0x02,0x00,0x3b
  };

/*******************************************************************************/


// Main Window
class GLViewWindow : public FXMainWindow {
  FXDECLARE(GLViewWindow)
private:
  FXHorizontalFrame *toolbar;                 // Tool bar
  FXMenuBar         *menubar;                 // Menu bar
  FXMDIClient       *mdiclient;               // MDI Client area
  FXGLViewer        *viewer;                  // GL Viewer to draw into
  FXStatusbar       *statusbar;               // Status bar
  FXGLGroup         *scene;                   // Scene to watch
  FXGIFIcon         *mdiicon;                 // MDI Child window icon
  FXMenuPane        *mdimenu;                 // MDI Window Menu
  FXGLVisual        *glvisual;                // Visual for OpenGL
protected:
  GLViewWindow(){}
public:
  
  // We define additional ID's, starting from the last one used by the base class+1.
  // This way, we know the ID's are all unique for this particular target.
  enum{
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_OPEN,
    ID_NEWVIEWER,
    ID_QUERY_MODE
    };

  // Message handlers
  long onCmdOpen(FXObject*,FXSelector,void*);
  long onCmdNewViewer(FXObject*,FXSelector,void*);
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onUpdMode(FXObject*,FXSelector,void*);

public:

  // GLViewWindow constructor
  GLViewWindow(FXApp* a);
  
  // Initialize
  virtual void create();
  
  // GLViewWindow destructor
  virtual ~GLViewWindow();
  };

  
/*******************************************************************************/


// Message Map GLViewWindow class
FXDEFMAP(GLViewWindow) GLViewWindowMap[]={

  //__Message_Type_____________ID________________________Message_Handler_____
  FXMAPFUNC(SEL_COMMAND,     GLViewWindow::ID_ABOUT,      GLViewWindow::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,     GLViewWindow::ID_OPEN,       GLViewWindow::onCmdOpen),
  FXMAPFUNC(SEL_COMMAND,     GLViewWindow::ID_NEWVIEWER,  GLViewWindow::onCmdNewViewer),
  FXMAPFUNC(SEL_UPDATE,      GLViewWindow::ID_QUERY_MODE, GLViewWindow::onUpdMode),
  };



// Macro for the GLViewWindow class hierarchy implementation
FXIMPLEMENT(GLViewWindow,FXMainWindow,GLViewWindowMap,ARRAYNUMBER(GLViewWindowMap))

  
/*******************************************************************************/


// Construct a GLViewWindow
GLViewWindow::GLViewWindow(FXApp* a):FXMainWindow(a,"OpenGL Test Application",NULL,NULL,DECOR_ALL,0,0,800,600){
  FXIcon *peng=new FXGIFIcon(getApp(),penguin);
  
  setIcon(peng);

  FXColorDialog *colordlg=new FXColorDialog(this,"Color Dialog",DECOR_TITLE|DECOR_BORDER);
  
  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // Tool bar
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  toolbar=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 4,4,0,0, 0,0);
  
  // Make status bar
  statusbar=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  
  // The good old penguin, what would we be without it?
  new FXButton(statusbar,"\tHello, I'm Tux...\nThe symbol for the Linux Operating System.\nAnd all it stands for.",new FXGIFIcon(getApp(),penguin),NULL,0,LAYOUT_RIGHT);
  
  // Contents
  FXHorizontalFrame *frame=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0, 0,0);
  
  // Nice sunken box around GL viewer
  FXVerticalFrame *box=new FXVerticalFrame(frame,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  
  // MDI Client
  mdiclient=new FXMDIClient(box,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // MDI buttons in menu:- note the message ID's!!!!!
  // Normally, MDI commands are simply sensitized or desensitized;
  // Under the menubar, however, they're hidden if the MDI Client is
  // not maximized.  To do this, they must have different ID's.
  new FXMDIWindowButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENUWINDOW,LAYOUT_LEFT);
  new FXMDIDeleteButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENUCLOSE,FRAME_RAISED|LAYOUT_RIGHT);
  new FXMDIRestoreButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENURESTORE,FRAME_RAISED|LAYOUT_RIGHT);
  new FXMDIMinimizeButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENUMINIMIZE,FRAME_RAISED|LAYOUT_RIGHT);

  // Icon for MDI Child
  mdiicon=new FXGIFIcon(getApp(),winapp);
  
  // Make MDI Window Menu
  mdimenu=new FXMDIMenu(this,mdiclient);
  
  // Make an MDI Child
  FXMDIChild* mdichild=new FXMDIChild(mdiclient,"FOX GL Viewer",mdiicon,mdimenu,MDI_NORMAL,30,30,300,200);

  //FXDebugTarget *dbg=new FXDebugTarget;
  
  // A visual to drag OpenGL in double-buffered mode; note the glvisual is
  // shared between all windows which need the same depths and numbers of buffers
  // Thus, while the first visual may take some time to initialize, each subsequent
  // window can be created very quickly; we need to determine grpaphics hardware
  // characteristics only once.
  glvisual=new FXGLVisual(getApp(),VISUAL_DOUBLEBUFFER);
  
  // Drawing gl canvas
  //viewer=new FXGLViewer(mdichild,dbg,1,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);
  viewer=new FXGLViewer(mdichild,glvisual,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);

  // Tab book with switchable panels
  FXTabBook* panels=new FXTabBook(frame);

  new FXTabItem(panels,"Angles\tCamera Angles\tSwitch to camera angles panel.");

  // Angles
  FXMatrix *angles=new FXMatrix(panels,2,FRAME_THICK|FRAME_RAISED|MATRIX_BY_COLUMNS|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);
  new FXLabel(angles,"X:");
  FXDial* x_dial=new FXDial(angles,mdiclient,FXGLViewer::ID_DIAL_X,FRAME_SUNKEN|FRAME_THICK|DIAL_CYCLIC|DIAL_HORIZONTAL|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT|LAYOUT_CENTER_Y,0,0,150,14,0,0,0,0);
  x_dial->setTipText("Rotate about X");
  
  new FXLabel(angles,"Y:");
  FXDial* y_dial=new FXDial(angles,mdiclient,FXGLViewer::ID_DIAL_Y,FRAME_SUNKEN|FRAME_THICK|DIAL_CYCLIC|DIAL_HORIZONTAL|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT|LAYOUT_CENTER_Y,0,0,150,14,0,0,0,0);
  y_dial->setTipText("Rotate about Y");
  
  new FXLabel(angles,"Z:");
  FXDial* z_dial=new FXDial(angles,mdiclient,FXGLViewer::ID_DIAL_Z,FRAME_SUNKEN|FRAME_THICK|DIAL_CYCLIC|DIAL_HORIZONTAL|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT|LAYOUT_CENTER_Y,0,0,150,14,0,0,0,0);
  z_dial->setTipText("Rotate about Z");
  
  new FXLabel(angles,"FOV:");
  FXTextField* fov=new FXTextField(angles,10,mdiclient,FXGLViewer::ID_FOV,JUSTIFY_RIGHT|FRAME_SUNKEN|FRAME_THICK);
  fov->setTipText("Field of view");
  
  new FXLabel(angles,"Zoom:");
  FXTextField* zz=new FXTextField(angles,10,mdiclient,FXGLViewer::ID_ZOOM,JUSTIFY_RIGHT|FRAME_SUNKEN|FRAME_THICK);
  zz->setTipText("Zooming");
  
  // Colors
  new FXTabItem(panels,"Colors\tColors\tSwitch to color panel.");
  FXMatrix *colors=new FXMatrix(panels,2,MATRIX_BY_COLUMNS|FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_CENTER_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);
  new FXLabel(colors,"Background:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|JUSTIFY_RIGHT);
  new FXColorWell(colors,0,mdiclient,FXGLViewer::ID_BACK_COLOR,LAYOUT_TOP|LAYOUT_LEFT, 0,0,0,0 ,0,0,0,0);
  new FXLabel(colors,"Ambient:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|JUSTIFY_RIGHT);
  new FXColorWell(colors,0,mdiclient,FXGLViewer::ID_AMBIENT_COLOR,LAYOUT_TOP|LAYOUT_LEFT, 0,0,0,0 ,0,0,0,0);
  

  new FXLabel(colors,"Light Amb:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|JUSTIFY_RIGHT);
  new FXColorWell(colors,0,mdiclient,FXGLViewer::ID_LIGHT_AMBIENT,LAYOUT_TOP|LAYOUT_LEFT, 0,0,0,0 ,0,0,0,0);
  new FXLabel(colors,"Light Diff:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|JUSTIFY_RIGHT);
  new FXColorWell(colors,0,mdiclient,FXGLViewer::ID_LIGHT_DIFFUSE,LAYOUT_TOP|LAYOUT_LEFT, 0,0,0,0 ,0,0,0,0);
  new FXLabel(colors,"Light Spec:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|JUSTIFY_RIGHT);
  new FXColorWell(colors,0,mdiclient,FXGLViewer::ID_LIGHT_SPECULAR,LAYOUT_TOP|LAYOUT_LEFT, 0,0,0,0 ,0,0,0,0);
  
  // Switches
  new FXTabItem(panels,"Settings\tSettings\tSwitche to settings panel.");
  FXVerticalFrame *settings=new FXVerticalFrame(panels,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_CENTER_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);
  new FXCheckButton(settings,"Lighting",mdiclient,FXGLViewer::ID_LIGHTING,ICON_BEFORE_TEXT);
  new FXCheckButton(settings,"Fog",mdiclient,FXGLViewer::ID_FOG,ICON_BEFORE_TEXT);
  new FXCheckButton(settings,"Dither",mdiclient,FXGLViewer::ID_DITHER,ICON_BEFORE_TEXT);
  new FXCheckButton(settings,"Lock",mdiclient,FXGLViewer::ID_LOCK,ICON_BEFORE_TEXT);
  new FXCheckButton(settings,"Turbo",mdiclient,FXGLViewer::ID_TURBO,ICON_BEFORE_TEXT);
 
  
  FXIcon *newdoc=new FXGIFIcon(getApp(),filenew);
  FXIcon *opendoc=new FXGIFIcon(getApp(),fileopen);
  FXIcon *savedoc=new FXGIFIcon(getApp(),filesave);
  FXIcon *saveasdoc=new FXGIFIcon(getApp(),filesaveas,0,IMAGE_ALPHAGUESS);

  // File Menu
  FXMenuPane *filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  new FXMenuCommand(filemenu,"&New...\tCtl-N\tCreate new document.",newdoc);
  new FXMenuCommand(filemenu,"&Open...\tCtl-O\tOpen document file.",opendoc,this,ID_OPEN);
  new FXMenuCommand(filemenu,"&Save\tCtl-S\tSave document.",savedoc);
  new FXMenuCommand(filemenu,"Save &As...\t\tSave document to another file.",saveasdoc);
  new FXMenuCommand(filemenu,"&Print Image...\t\tPrint snapshot image.",NULL,mdiclient,FXGLViewer::ID_PRINT_IMAGE);
  new FXMenuCommand(filemenu,"&Print Vector...\t\tPrint geometry.",NULL,mdiclient,FXGLViewer::ID_PRINT_VECTOR);
  new FXMenuCommand(filemenu,"&Dump...\t\tDump widgets.",NULL,getApp(),FXApp::ID_DUMP);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q\tQuit the application.",NULL,getApp(),FXApp::ID_QUIT,MENU_DEFAULT);
  
  // Edit Menu
  FXMenuPane *editmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Edit",NULL,editmenu);
  new FXMenuCommand(editmenu,"Undo");
  new FXMenuCommand(editmenu,"Copy",NULL,mdiclient,FXGLViewer::ID_COPY_SEL,MENU_AUTOGRAY);
  new FXMenuCommand(editmenu,"Cut",NULL,mdiclient,FXGLViewer::ID_CUT_SEL,MENU_AUTOGRAY);
  new FXMenuCommand(editmenu,"Paste",NULL,mdiclient,FXGLViewer::ID_PASTE_SEL,MENU_AUTOGRAY);
  new FXMenuCommand(editmenu,"Delete",NULL,mdiclient,FXGLViewer::ID_DELETE_SEL,MENU_AUTOGRAY);
  
  // File manipulation
  new FXButton(toolbar,"\tNew\tCreate new document.",newdoc,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tOpen\tOpen document file.",opendoc,this,ID_OPEN,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tSave\tSave document.",savedoc,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tSave As\tSave document to another file.",saveasdoc,this,ID_OPEN,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tNew Folder\tNo comment",new FXGIFIcon(getApp(),newfolder),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Print
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,4,20);
  new FXButton(toolbar,"\tPrint Image\tPrint shapshot image.",new FXGIFIcon(getApp(),print),mdiclient,FXGLViewer::ID_PRINT_IMAGE,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Editing
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,4,20);
  new FXButton(toolbar,"\tCut",new FXGIFIcon(getApp(),cut),mdiclient,FXGLViewer::ID_CUT_SEL,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tCopy",new FXGIFIcon(getApp(),copy),mdiclient,FXGLViewer::ID_COPY_SEL,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tPaste",new FXGIFIcon(getApp(),paste),mdiclient,FXGLViewer::ID_PASTE_SEL,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Projections
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,8,20);
  new FXButton(toolbar,"\tPerspective\tSwitch to perspective projection.",new FXGIFIcon(getApp(),perspective),mdiclient,FXGLViewer::ID_PERSPECTIVE,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tParallel\tSwitch to parallel projection.",new FXGIFIcon(getApp(),parallel),mdiclient,FXGLViewer::ID_PARALLEL,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Shading model
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,8,20);
  new FXButton(toolbar,"\tNo shading\tTurn light sources off.",new FXGIFIcon(getApp(),nolight),mdiclient,FXGLShape::ID_SHADEOFF,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tFlat shading\tTurn on faceted (flat) shading.",new FXGIFIcon(getApp(),light),mdiclient,FXGLShape::ID_SHADEON,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tSmooth shading\tTurn on smooth shading.",new FXGIFIcon(getApp(),smoothlight),mdiclient,FXGLShape::ID_SHADESMOOTH,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,8,20);
  new FXToggleButton(toolbar,"\tToggle Light\tToggle light source.",NULL,new FXGIFIcon(getApp(),nolight),new FXGIFIcon(getApp(),light),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // View orientation
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,8,20);
  new FXButton(toolbar,"\tFront View\tView objects from the front.",new FXGIFIcon(getApp(),frontview),mdiclient,FXGLViewer::ID_FRONT,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tBack View\tView objects from behind.",new FXGIFIcon(getApp(),backview),mdiclient,FXGLViewer::ID_BACK,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tLeft View\tView objects from the left.",new FXGIFIcon(getApp(),leftview),mdiclient,FXGLViewer::ID_LEFT,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tRight View\tView objects from the right.",new FXGIFIcon(getApp(),rightview),mdiclient,FXGLViewer::ID_RIGHT,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tTop View\tView objects from the top.",new FXGIFIcon(getApp(),topview,0,IMAGE_OPAQUE),mdiclient,FXGLViewer::ID_TOP,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tBottom View\tView objects from below.",new FXGIFIcon(getApp(),bottomview,0,IMAGE_OPAQUE),mdiclient,FXGLViewer::ID_BOTTOM,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Miscellaneous buttons
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,8,20);
  new FXButton(toolbar,(FXchar*)0,new FXGIFIcon(getApp(),zoom),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tColors\tDisplay color dialog.",new FXGIFIcon(getApp(),colorpal),colordlg,FXWindow::ID_SHOW,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,(FXchar*)0,new FXGIFIcon(getApp(),camera,0,IMAGE_OPAQUE),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,(FXchar*)0,new FXGIFIcon(getApp(),foxicon),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Dangerous delete a bit on the side
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,10,20);
  new FXButton(toolbar,"\tDelete\tDelete the selected object.",new FXGIFIcon(getApp(),kill),mdiclient,FXGLViewer::ID_DELETE_SEL,BUTTON_AUTOGRAY|FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // View menu
  FXMenuPane *viewmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&View",NULL,viewmenu);
  new FXMenuCommand(viewmenu,"Parallel\t\tSwitch to parallel projection.",NULL,mdiclient,FXGLViewer::ID_PARALLEL,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"Perspective\t\tSwitch to perspective projection.",NULL,mdiclient,FXGLViewer::ID_PERSPECTIVE,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Front\t\tFront view.",NULL,mdiclient,FXGLViewer::ID_FRONT,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Back\t\tBack view.",NULL,mdiclient,FXGLViewer::ID_BACK,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Left\t\tLeft view.",NULL,mdiclient,FXGLViewer::ID_LEFT,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Right\t\tRight view.",NULL,mdiclient,FXGLViewer::ID_RIGHT,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Top\t\tTop view.",NULL,mdiclient,FXGLViewer::ID_TOP,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"&Bottom\t\tBottom view.",NULL,mdiclient,FXGLViewer::ID_BOTTOM,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"F&it\t\tFit to view.",NULL,mdiclient,FXGLViewer::ID_FITVIEW,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"R&eset\t\tReset all viewing parameters",NULL,mdiclient,FXGLViewer::ID_RESETVIEW,MENU_AUTOGRAY);
  new FXMenuCommand(viewmenu,"Lock\t\tLock view orientation",NULL,mdiclient,FXGLViewer::ID_LOCK,MENU_AUTOGRAY);
  
  // Rendering menu
  FXMenuPane *rendermenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Rendering",NULL,rendermenu);
  new FXMenuCommand(rendermenu,"Points\t\tRender as points.",NULL,mdiclient,FXGLShape::ID_STYLE_POINTS,MENU_AUTOGRAY);
  new FXMenuCommand(rendermenu,"Wire Frame\t\tRender as wire frame.",NULL,mdiclient,FXGLShape::ID_STYLE_WIREFRAME,MENU_AUTOGRAY);
  new FXMenuCommand(rendermenu,"Surface \t\tRender solid surface.",NULL,mdiclient,FXGLShape::ID_STYLE_SURFACE,MENU_AUTOGRAY);
  new FXMenuCommand(rendermenu,"Bounding Box\t\tRender bounding box only.",NULL,mdiclient,FXGLShape::ID_STYLE_BOUNDINGBOX,MENU_AUTOGRAY);

  // Window menu
  FXMenuPane *windowmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Windows",NULL,windowmenu);
  new FXMenuCommand(windowmenu,"New Viewer\t\tCreate new viewer window.",NULL,this,ID_NEWVIEWER);
  new FXMenuCommand(windowmenu,"Tile Horizontally\t\tTile windows horizontally.",NULL,mdiclient,FXWindow::ID_MDI_TILEHORIZONTAL);
  new FXMenuCommand(windowmenu,"Tile Vertically\t\tTile windows vertically.",NULL,mdiclient,FXWindow::ID_MDI_TILEVERTICAL);
  new FXMenuCommand(windowmenu,"Cascade\t\tCascade windows.",NULL,mdiclient,FXWindow::ID_MDI_CASCADE);
  new FXMenuCommand(windowmenu,"Toolbar",NULL,toolbar,FXWindow::ID_TOGGLESHOWN);
  new FXMenuCommand(windowmenu,"Control panel",NULL,panels,FXWindow::ID_TOGGLESHOWN);
  new FXMenuCommand(windowmenu,"Delete\t\tDelete current viewer window.",NULL,mdiclient,FXMDIClient::ID_MDI_CLOSE);

  // Help menu
  FXMenuPane* helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About FOX...\t\tDisplay FOX about panel.",NULL,this,ID_ABOUT,0);
  
  // Make a tool tip
  new FXTooltip(getApp(),0);
  
  // The status bar shows our mode
  statusbar->getStatusline()->setTarget(this);
  statusbar->getStatusline()->setSelector(ID_QUERY_MODE);
    
  // Make a scene!
  scene=new FXGLGroup;
  scene->append(new FXGLPoint(2,0,0));
  scene->append(new FXGLPoint(0,2,0));
  scene->append(new FXGLPoint(2,2,0));
  scene->append(new FXGLPoint(0,0,0));
  scene->append(new FXGLLine(0,0,0, 1,0,0));
  scene->append(new FXGLLine(0,0,0, 0,1,0));
  scene->append(new FXGLLine(0,0,0, 0,0,1));
  scene->append(new FXGLLine(0,0,0, 1,1,1));
  FXGLGroup *gp2=new FXGLGroup;
  scene->append(gp2);
  FXGLSphere *sphere=new FXGLSphere(1.0, 1.0, 0.0, 0.5);
  sphere->setTipText("Sphere");
  gp2->append(new FXGLCube(-1.0, 0.0, 0.0,  0.5, 0.5, 0.5));
  gp2->append(new FXGLCube( 1.0, 0.0, 0.0,  0.5, 0.5, 0.5));
  gp2->append(new FXGLCube( 0.0,-1.0, 0.0,  0.5, 0.5, 0.5));
  gp2->append(new FXGLCube( 0.0, 1.0, 0.0,  0.5, 0.5, 1.5));
  gp2->append(new FXGLCone(1.0,-1.5, 0.0, 1.0, 0.5));
  gp2->append(new FXGLCylinder(-1.0, 0.5, 0.0, 1.0, 0.5));
  gp2->append(sphere);
  
  // Add scene to GL viewer
  viewer->setScene(scene);
  }
    

// Destructor
GLViewWindow::~GLViewWindow(){
  }

 

// Create and initialize 
void GLViewWindow::create(){
  FXMainWindow::create();
  show();
  }


// About
long GLViewWindow::onCmdAbout(FXObject*,FXSelector,void*){
  FXMessageBox::information(this,MBOX_OK,"About FOX","FOX OpenGL Example.\nCopyright (C) 1998 Jeroen van der Zijp");
  return 1;
  }


// Open
long GLViewWindow::onCmdOpen(FXObject*,FXSelector,void*){
  const FXchar *patterns[]={
    "All Files",          "*",
    "C++ Source Files",   "*.[Cc][Pp][Pp]",
    "C++ Header Files",   "*.[Hh]",
    "Object Files",       "*.o",
    "HTML Header Files",  "*.[Hh][Tt][Mm][Ll]",NULL};
  FXFileDialog open(this,"Open some file");
  open.setPatternList(patterns);
  if(open.execute()){
    fxmessage("File=%s\n",open.getFilename().text());
    }
  return 1;
  }



// Make new viewer
long GLViewWindow::onCmdNewViewer(FXObject*,FXSelector,void*){
  
  // Make new MDI child widget
  FXMDIChild* mdichild=new FXMDIChild(mdiclient,"FOX GL Viewer",mdiicon,mdimenu,MDI_NORMAL,30,30,300,200);

  // Drawing gl canvas
  FXGLViewer *view=new FXGLViewer(mdichild,glvisual,NULL,0);
  
  // Change of scenery
  view->setScene(scene);
  
  // Create the new window
  mdichild->create();
  
  return 1;
  }


// Statusbar wanted to know about mode
// We fake it here for the purpose of demonstration...
long GLViewWindow::onUpdMode(FXObject* sender,FXSelector,void*){
  FXStatusline *statusline=(FXStatusline*)sender;
  statusline->setText("Ready.");
  return 1;
  }


// Here we begin
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("GLViewer","Test");
  
  // Open the display
  application->init(argc,argv);

  // Make window
  new GLViewWindow(application);
  
  // Create the application's windows
  application->create();
  
  // Run the application
  application->run();
  
  return 0;
  }



#else


// Here we begin
int main(int argc,char *argv[]){
  fxmessage("The FOX Library was compiled without OpenGL\n");
  return 0;
  }


#endif
