/********************************************************************************
*                                                                               *
*                           O p e n G L   O b j e c t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLObject.cpp,v 1.1 1999/09/14 13:41:23 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXVec.h"
#include "FXHVec.h"
#include "FXQuat.h"
#include "FXHMat.h"
#include "FXRange.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXCursor.h"
#include "FXGLCanvas.h"
#include "FXDC.h"
#include "FXDCPrint.h"
#include "FXGLViewer.h"
#include "FXGLObject.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXTooltip.h"


// GLU versions prior to 1.1 have GLUquadric
#if !defined(GLU_VERSION_1_1) && !defined(GLU_VERSION_1_2) && !defined(GLU_VERSION_1_3)
#define GLUquadricObj GLUquadric
#endif

/*
  Notes:
  - Leaf objects don't push any names!
  - Group objects should do focus traversal.
  
  - Suggestion for transform nodes... "Mike Fletcher" <mcfletch@vrtelecom.com>
  class FXGLTransform( FXGLGroup ):
  
 def draw( self, viewer):
         # The transform node sets up a transformation matrix
         # then renders all children
         # then removes that transformation matrix
         # from the stack.
         GL.PushMatrix () # store previous
         if self.translation: # three tupple
                 apply (GL.glTranslatef, self.translation )
         if self.center: #three tupple
                 apply (GL.glTranslatef, self.center )
         # rotation of angle ra around axis rx,ry,rz
         if self.rotation: # 4 tupple
                 rx,ry,rz,ra = self.rotation
                 apply (GL.glRotatef, (saa*self.radtodeg, sax,say,saz) )
         if self.scale: # three tupple
                 if self.scaleOrientation: # 4 tupple
                         sax,say,saz,saa = self.scaleOrientation
                         apply (GL.glRotatef, (saa*self.radtodeg, sax,say,saz) )
                 apply (GL.glScalef, tuple( self.scale ) )
                 # reverse the scaleOrientation
                 if self.scaleOrientation:
                         apply (GL.glRotatef, (-saa*self.radtodeg, sax,say,saz) )
         # now reverse center offset
         if self.center:
                 cx,cy,cz = self.center
                 apply (GL.glTranslatef, ( -cx,-cy,-cz) )
         # draw children here...
         FXGLGroup.draw( self, viewer)
         # now remove the transformation matrix
         PopMatrix()

Needs to do the same calculation for the pick pass as well...  Note that it
is fairly easy to calculate the entire matrix at one go whenever it changes,
thereby saving the system most of the work of calculation per-frame (a
single matrix multiply with the current "surrounding" matrix
 GL.glGetFloatv(GL_MODELVIEW_MATRIX, ModelView) ).  I have not profiled the
difference between them, but I would assume a cached matrix would be faster.


*/

/*******************************************************************************/


// Object implementation
FXIMPLEMENT(FXGLObject,FXObject,NULL,0)

  
// Construct
FXGLObject::FXGLObject(){
  }


// Get bounding box
void FXGLObject::bounds(FXRange& box){
  box[0][0]=box[0][1]=box[1][0]=box[1][1]=box[2][0]=box[2][1]=0.0;
  }


// Draw the GL scene
void FXGLObject::draw(FXGLViewer*){ }


// Hit objects
void FXGLObject::hit(FXGLViewer* viewer){ draw(viewer); }


// Identify object by its path
FXGLObject* FXGLObject::identify(FXuint*){ return this; }


// Return true if it can be dragged
FXbool FXGLObject::canDrag() const { return FALSE; }

// Return true if OK to delete object
FXbool FXGLObject::canDelete() const { return FALSE; }

// Drag the object
FXbool FXGLObject::drag(FXGLViewer*,FXint,FXint,FXint,FXint){ return FALSE; }


// Destruct
FXGLObject::~FXGLObject(){ }


/*******************************************************************************/

// Drop
FXDEFMAP(FXGLGroup) FXGLGroupMap[]={
  FXMAPFUNC(SEL_FOCUSIN,0,FXGLGroup::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXGLGroup::onFocusOut),
  };

  
// Object implementation
FXIMPLEMENT(FXGLGroup,FXGLObject,FXGLGroupMap,ARRAYNUMBER(FXGLGroupMap))



// Contruct
FXGLGroup::FXGLGroup(){
  current=-1;
  }


// Get bounding box
void FXGLGroup::bounds(FXRange& box){
  if(list.no()==0){
    box[0][0]=box[0][1]=box[1][0]=box[1][1]=box[2][0]=box[2][1]=0.0;
    }
  else{
    box=FXRange(FLT_MAX,-FLT_MAX,FLT_MAX,-FLT_MAX,FLT_MAX,-FLT_MAX);
    for(FXint i=0; i<list.no(); i++){
      FXRange r;
      list[i]->bounds(r);
      box.include(r);
      }
    }
  }


// Gained focus
long FXGLGroup::onFocusIn(FXObject*,FXSelector,void* ptr){
  FXTRACE((250,"%s::onFocusIn %08x\n",getClassName(),this));
  return (0<=current)&&(list[current]->handle(list[current],MKUINT(0,SEL_FOCUSIN),ptr));
  }


// Lost focus
long FXGLGroup::onFocusOut(FXObject*,FXSelector,void* ptr){
  FXTRACE((250,"%s::onFocusOut %08x\n",getClassName(),this));
  return (0<=current)&&(list[current]->handle(list[current],MKUINT(0,SEL_FOCUSOUT),ptr));
  }


// Draw
void FXGLGroup::draw(FXGLViewer* viewer){
  for(FXint i=0; i<list.no(); i++) list[i]->draw(viewer);
  }


// Draw for hit
void FXGLGroup::hit(FXGLViewer* viewer){
#ifdef HAVE_OPENGL
  glPushName(0xffffffff);
  for(FXint i=0; i<list.no(); i++){
    glLoadName(i);
    list[i]->hit(viewer);
    }
  glPopName();
#endif
  }


// Identify object by its path
FXGLObject* FXGLGroup::identify(FXuint* path){ 
  FXASSERT(path);
  FXASSERT((FXint)path[0]<list.no());
  return list[path[0]]->identify(path+1);
  }


// Return true if it can be dragged
FXbool FXGLGroup::canDrag() const { return TRUE; }


// Drag group object
FXbool FXGLGroup::drag(FXGLViewer* viewer,FXint fx,FXint fy,FXint tx,FXint ty){
  for(FXint i=0; i<list.no(); i++){
    list[i]->drag(viewer,fx,fy,tx,ty);
    }
  return TRUE;
  }


// Save object to stream
void FXGLGroup::save(FXStream& store) const {
  FXGLObject::save(store);
  list.save(store);
  store << current;
  }

      
// Load object from stream
void FXGLGroup::load(FXStream& store){
  FXGLObject::load(store);
  list.load(store);
  store >> current;
  }


// Delete members of the group
FXGLGroup::~FXGLGroup(){
  for(FXint i=0; i<list.no(); i++) delete list[i];
  }


/*******************************************************************************/

#define HANDLE_SIZE 4.0


// Object implementation
FXIMPLEMENT(FXGLPoint,FXGLObject,NULL,0)


// Create point
FXGLPoint::FXGLPoint():
  pos(0.0,0.0,0.0){
  }


// Create initialized point
FXGLPoint::FXGLPoint(FXfloat x,FXfloat y,FXfloat z):
  pos(x,y,z){
  }


// Get bounding box
void FXGLPoint::bounds(FXRange& box){
  box[0][0]=box[0][1]=pos[0];
  box[1][0]=box[1][1]=pos[0];
  box[2][0]=box[2][1]=pos[0];
  }


// Draw
void FXGLPoint::draw(FXGLViewer* ){
#ifdef HAVE_OPENGL
  glColor3f(0.0,0.0,1.0);
  glPointSize(HANDLE_SIZE);
  glBegin(GL_POINTS);
  glVertex3fv(pos);
  glEnd();
#endif
  }


// Draw for hit
void FXGLPoint::hit(FXGLViewer* ){
#ifdef HAVE_OPENGL
  glBegin(GL_POINTS);
  glVertex3fv(pos);
  glEnd();
#endif
  }


// Save object to stream
void FXGLPoint::save(FXStream& store) const {
  FXGLObject::save(store);
  store << pos;
  }

      
// Load object from stream
void FXGLPoint::load(FXStream& store){
  FXGLObject::load(store);
  store >> pos;
  }


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXGLLine,FXGLObject,NULL,0)


// Create line
FXGLLine::FXGLLine():fm(-0.5,0.0,0.0),to(0.5,0.0,0.0){
  }


// Create inittialized line
FXGLLine::FXGLLine(FXfloat fx,FXfloat fy,FXfloat fz,FXfloat tx,FXfloat ty,FXfloat tz):
  fm(fx,fy,fz),to(tx,ty,tz){
  }


// Get bounding box
void FXGLLine::bounds(FXRange& box){
  FXMINMAX(box[0][0],box[0][1],fm.pos[0],to.pos[0]);
  FXMINMAX(box[1][0],box[1][1],fm.pos[1],to.pos[1]);
  FXMINMAX(box[2][0],box[2][1],fm.pos[2],to.pos[2]);
  }


// Draw
void FXGLLine::draw(FXGLViewer* ){
#ifdef HAVE_OPENGL
  glColor3f(1.0,0.0,0.0);
  glPointSize(HANDLE_SIZE);
  glBegin(GL_LINES);
  glVertex3fv(fm.pos);
  glVertex3fv(to.pos);
  glEnd();
#endif
  }


// Draw for hit
void FXGLLine::hit(FXGLViewer* ){
#ifdef HAVE_OPENGL
  glBegin(GL_LINES);
  glVertex3fv(fm.pos);
  glVertex3fv(to.pos);
  glEnd();
#endif
  }


// Save object to stream
void FXGLLine::save(FXStream& store) const {
  FXGLObject::save(store);
  fm.save(store);
  to.save(store);
  }

      
// Load object from stream
void FXGLLine::load(FXStream& store){
  FXGLObject::load(store);
  fm.load(store);
  to.load(store);
  }

