/********************************************************************************
*                                                                               *
*                       M e n u   C a p t i o n   W i d g e t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCaption.h,v 1.3 1999/09/27 12:41:19 jeroen Exp $                   *
********************************************************************************/
#ifndef FXMENUCAPTION_H
#define FXMENUCAPTION_H


// Button masks for menu buttons
enum FXMenuStyle {
  MENU_DEFAULT  = 0x00008000,
  MENU_AUTOGRAY = 0x00010000,
  MENU_AUTOHIDE = 0x00020000
  };


// Text menu item
class FXAPI FXMenuCaption : public FXFrame {
  FXDECLARE(FXMenuCaption)
protected:
  FXString     label;
  FXString     help;
  FXIcon      *icon;
  FXFont      *font;
  FXint        hotoff;
  FXHotKey     hotkey;
  FXColor      textColor;
  FXColor      selbackColor;
  FXColor      seltextColor;
protected:
  FXMenuCaption(){}
private:
  FXMenuCaption(const FXMenuCaption&);
  FXMenuCaption &operator=(const FXMenuCaption&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
public:
  FXMenuCaption(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXuint opts=0);
  virtual void create();
  virtual void detach();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setText(const FXString& text);
  FXString getText() const { return label; }
  void setIcon(FXIcon* ic);
  FXIcon* getIcon() const { return icon; }
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXMenuCaption();
  };


#endif
