/********************************************************************************
*                                                                               *
*                  S t r i n g   D i c t i o n a r y    C l a s s               *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDict.h,v 1.3 1999/11/16 18:29:25 jeroen Exp $                         *
********************************************************************************/
#ifndef FXDICT_H
#define FXDICT_H



// Pointer dictionary
class FXAPI FXDict : public FXObject {
  FXDECLARE(FXDict)
protected:
  struct FXDictEntry {
    FXchar *key;              // Key string
    void   *data;             // Data
    FXint   hash;             // Hash value of key
    FXbool  mark;             // Entry is marked
    };
protected:
  FXDictEntry  *dict;         // Dictionary
  FXint        total;         // Dictionary size
  FXint        number;        // Number of entries
protected:
  virtual void *createData(const void*);
  virtual void deleteData(void*);
private:
  FXDict(const FXDict&);
  FXDict &operator=(const FXDict&);
public:
  FXDict();
  FXint size() const { return total; }
  void size(FXint m);
  FXint no() const { return number; }
  void* insert(const FXchar* ky,const void* ptr,FXbool mrk=FALSE);
  void* replace(const FXchar* ky,const void* ptr,FXbool mrk=FALSE);
  void* remove(const FXchar* ky);
  void* find(const FXchar* ky);
  const FXchar* key(FXuint pos) const { return dict[pos].key; }
  void* data(FXuint pos) const { return dict[pos].data; }
  FXbool mark(FXuint pos) const { return dict[pos].mark; }
  FXint first() const;
  FXint last() const;
  FXint next(FXint pos) const;  
  FXint prev(FXint pos) const;  
  void clear();
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXDict();
  };


// String dictionary
class FXAPI FXStringDict : public FXDict {
  FXDECLARE(FXStringDict)
protected:
  virtual void *createData(const void*);
  virtual void deleteData(void*);
private:
  FXStringDict(const FXStringDict&);
  FXStringDict &operator=(const FXStringDict&);
public:
  FXStringDict();
  FXchar* insert(const FXchar* ky,const FXchar* str,FXbool mrk=FALSE){ return (FXchar*)FXDict::insert(ky,str,mrk); }
  FXchar* replace(const FXchar* ky,const FXchar* str,FXbool mrk=FALSE){ return (FXchar*)FXDict::replace(ky,str,mrk); }
  FXchar* remove(const FXchar* ky){ return (FXchar*)FXDict::remove(ky); }
  FXchar* find(const FXchar* ky){ return (FXchar*)FXDict::find(ky); }
  FXchar* data(FXuint pos) const { return (FXchar*)dict[pos].data; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXStringDict();
  };


// Section dictionary
class FXAPI FXSectionDict : public FXDict {
  FXDECLARE(FXSectionDict)
protected:
  virtual void *createData(const void*);
  virtual void deleteData(void*);
private:
  FXSectionDict(const FXSectionDict&);
  FXSectionDict &operator=(const FXSectionDict&);
public:
  FXSectionDict();
  FXStringDict* insert(const FXchar* ky){ return (FXStringDict*)FXDict::insert(ky,NULL); }
  FXStringDict* remove(const FXchar* ky){ return (FXStringDict*)FXDict::remove(ky); }
  FXStringDict* find(const FXchar* ky){ return (FXStringDict*)FXDict::find(ky); }
  FXStringDict* data(FXuint pos) const { return (FXStringDict*)dict[pos].data; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXSectionDict();
  };

#endif
