/********************************************************************************
*                                                                               *
*                       C o m b o   B o x   W i d g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXComboBox.h,v 1.4 1999/11/09 23:58:37 jeroen Exp $                      *
********************************************************************************/
#ifndef FXCOMBOBOX_H
#define FXCOMBOBOX_H




// ComboBox styles
enum FXComboBoxStyle {
  COMBOBOX_NORMAL         = 0,                  // Can type text but list is not changed
  COMBOBOX_NO_REPLACE     = 0,                  // Leave the list the same
  COMBOBOX_REPLACE        = 0x00020000,         // Replace current item with typed text
  COMBOBOX_INSERT_BEFORE  = 0x00040000,         // Typed text inserted before current
  COMBOBOX_INSERT_AFTER   = 0x00060000,         // Typed text inserted after current
  COMBOBOX_INSERT_FIRST   = 0x00080000,         // Typed text inserted at begin of list
  COMBOBOX_INSERT_LAST    = 0x00090000,         // Typed text inserted at end of list
  COMBOBOX_STATIC         = 0x00100000          // Unchangable text box
  };


// Combobox
class FXAPI FXComboBox : public FXPacker {
  FXDECLARE(FXComboBox)
protected:
  FXTextField   *text;
  FXMenuButton  *button;
  FXList        *list;
  FXPopup       *pane;
protected:
  FXComboBox(){}
  virtual void layout();
private:
  FXComboBox(const FXComboBox&);
  FXComboBox &operator=(const FXComboBox&);
public:
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onTextButton(FXObject*,FXSelector,void*);
  long onTextChanged(FXObject*,FXSelector,void*);
  long onTextCommand(FXObject*,FXSelector,void*);
  long onListClicked(FXObject*,FXSelector,void*);
  long onFwdToText(FXObject*,FXSelector,void*);
  long onUpdFmText(FXObject*,FXSelector,void*);
public:
  enum{
    ID_LIST=FXPacker::ID_LAST,
    ID_TEXT,
    ID_LAST
    };
public:
  FXComboBox(FXComposite *p,FXint cols,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXbool isEditable() const;
  void setEditable(FXbool edit=TRUE);
  void setText(const FXString& txt);
  FXString getText() const;
  void setNumColumns(FXint cols);
  FXint getNumColumns() const;
  FXint getNumItems() const;
  FXint getNumVisible() const;
  void setNumVisible(FXint nvis);
  FXbool isItemCurrent(FXint index) const;
  void setCurrentItem(FXint index);
  FXint getCurrentItem() const;
  void insertItem(FXint index,const FXString& text,void* ptr=NULL);
  void replaceItem(FXint index,const FXString& text,void* ptr=NULL);
  void appendItem(const FXString& text,void* ptr=NULL);
  void removeItem(FXint index);
  void clearItems();
  void setItemText(FXint index,const FXString& text);
  FXString getItemText(FXint index) const;
  void setItemData(FXint index,void* ptr) const;
  void* getItemData(FXint index) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const;
  void setComboStyle(FXuint mode);
  FXuint getComboStyle() const;
  void setHelpText(const FXString& txt);
  FXString getHelpText() const;
  void setTipText(const FXString& txt);
  FXString getTipText() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXComboBox();
  };

  

#endif
