/********************************************************************************
*                                                                               *
*                         I c o n   L i s t   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldIconList.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                   *
********************************************************************************/
#ifndef FXOLDOLDICONLIST_H
#define FXOLDOLDICONLIST_H



//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////


// Icon List options
enum FXOldIconListStyle {
  OLDICONLIST_EXTENDEDSELECT = 0,                // Extended selection mode
  OLDICONLIST_SINGLESELECT   = 0x00100000,       // At most one selected item
  OLDICONLIST_BROWSESELECT   = 0x00200000,       // Always exactly one selected item
  OLDICONLIST_MULTIPLESELECT = OLDICONLIST_SINGLESELECT|OLDICONLIST_BROWSESELECT,  // Multiple selection mode
  OLDICONLIST_AUTOSELECT     = 0x00400000,       // Automatically select under cursor
  OLDICONLIST_DETAILED       = 0,                // List mode
  OLDICONLIST_MINI_ICONS     = 0x00800000,       // Mini Icon mode
  OLDICONLIST_BIG_ICONS      = 0x01000000,       // Big Icon mode
  OLDICONLIST_ROWS           = 0,                // Row-wise mode
  OLDICONLIST_COLUMNS        = 0x02000000,       // Column-wise mode
  OLDICONLIST_RANDOM         = 0x04000000,       // Random arrangement
  OLDICONLIST_WANTSELECTION  = 0x08000000        // Claim the selection
  };

  
// Opaque item type
enum FXOldIconItemState {
  OLDICONITEM_CURRENT   = 1,
  OLDICONITEM_SELECTED  = 2,
  OLDICONITEM_HISTORY   = 4,
  OLDICONITEM_MARK      = 8,
  OLDICONITEM_DRAGGABLE = 16
  };
     

struct FXOldIconItem {
  FXOldIconItem *prev;
  FXOldIconItem *next;
  FXString       label;
  FXIcon        *icon;
  FXIcon        *miniIcon;
  FXuint         state;
  void          *data;
  FXint          x,y;
  };


// Item collate function
typedef FXbool (*FXOldIconItemSortFunc)(const FXOldIconItem*,const FXOldIconItem*);


// Icon List object
class FXAPI FXOldIconList : public FXScrollArea {
  FXDECLARE(FXOldIconList)
protected:
  FXOldHeader       *header;
  FXOldIconItem     *firstitem;
  FXOldIconItem     *lastitem;
  FXOldIconItem     *anchoritem;
  FXOldIconItem     *currentitem;
  FXFont            *font;
  FXOldIconItemSortFunc sortfunc;
  FXColor            textColor;
  FXColor            selbackColor;
  FXColor            seltextColor;
  FXint              iconWidth;             // Size of big icon
  FXint              iconHeight;
  FXint              miniIconWidth;         // Size of mini icon
  FXint              miniIconHeight;
  FXint              itemSpace;             // Space for item label
  FXint              itemWidth;             // Item size
  FXint              itemHeight;
  FXint              totalWidth;
  FXint              totalHeight;
  FXint              anchorx;               // Rectangular selection
  FXint              anchory;
  FXint              currentx;
  FXint              currenty;
  FXTimer           *timer;
  FXString           help;
protected:
  FXOldIconList();
  virtual FXOldIconItem* createItem();
  virtual void deleteItem(FXOldIconItem*);
  void drawFocusRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawBigIcon(FXDCWindow& dc,FXint x,FXint y,FXOldIconItem* item);
  void drawMiniIcon(FXDCWindow& dc,FXint x,FXint y,FXOldIconItem* item);
  void drawDetails(FXDCWindow& dc,FXint x,FXint y,FXOldIconItem* item);
  static FXbool before(FXOldIconItem* a,FXOldIconItem* b);
  FXbool performSelectionChange(FXOldIconItem* item,FXuint code);
  FXbool performSelectionRectangle(FXint lx,FXint ty,FXint rx,FXint by,FXuint in,FXuint out);
  void sort(FXOldIconItem*& f1,FXOldIconItem*& t1,FXOldIconItem*& f2,FXOldIconItem*& t2,int n);
  void drawLasso(FXint x0,FXint y0,FXint x1,FXint y1);
  void recompute();
  virtual void layout();
private:
  FXOldIconList(const FXOldIconList&);
  FXOldIconList &operator=(const FXOldIconList&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onTipTimer(FXObject*,FXSelector,void*);
  long onCmdSelectAll(FXObject*,FXSelector,void*);
  long onCmdDeselectAll(FXObject*,FXSelector,void*);
  long onCmdSelectInverse(FXObject*,FXSelector,void*);
  long onCmdArrangeByRows(FXObject*,FXSelector,void*);
  long onUpdArrangeByRows(FXObject*,FXSelector,void*);
  long onCmdArrangeByColumns(FXObject*,FXSelector,void*);
  long onUpdArrangeByColumns(FXObject*,FXSelector,void*);
  long onCmdArrangeAtRandom(FXObject*,FXSelector,void*);
  long onUpdArrangeAtRandom(FXObject*,FXSelector,void*);
  long onCmdShowDetails(FXObject*,FXSelector,void*);
  long onUpdShowDetails(FXObject*,FXSelector,void*);
  long onCmdShowBigIcons(FXObject*,FXSelector,void*);
  long onUpdShowBigIcons(FXObject*,FXSelector,void*);
  long onCmdShowMiniIcons(FXObject*,FXSelector,void*);
  long onUpdShowMiniIcons(FXObject*,FXSelector,void*);
  long onHeaderChanged(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onDoubleClicked(FXObject*,FXSelector,void*);
  long onTripleClicked(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onSelected(FXObject*,FXSelector,void*);
  long onDeselected(FXObject*,FXSelector,void*);
public:
  enum {
    ID_SHOW_DETAILS=FXScrollArea::ID_LAST,
    ID_SHOW_MINI_ICONS,
    ID_SHOW_BIG_ICONS,
    ID_ARRANGE_BY_ROWS,
    ID_ARRANGE_BY_COLUMNS,
    ID_ARRANGE_AT_RANDOM,
    ID_HEADER_CHANGE,
    ID_TIPTIMER,
    ID_SELECT_ALL,
    ID_DESELECT_ALL,
    ID_SELECT_INVERSE,
    ID_LAST
    };
public:
  FXOldIconList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void recalc();
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  virtual FXbool canFocus() const;
  virtual FXint getViewportHeight();
  virtual void moveContents(FXint x,FXint y);
  FXOldHeader* getHeader() const { return header; }
  FXint getNumItems() const;
  FXint getNumSelectedItems() const;
  FXOldIconItem** getSelectedItems() const;
  FXOldIconItem* getFirstItem() const { return firstitem; }
  FXOldIconItem* getLastItem() const { return lastitem; }
  FXOldIconItem* getNextItem(const FXOldIconItem* item) const;
  FXOldIconItem* getPrevItem(const FXOldIconItem* item) const;
  virtual FXOldIconItem* addItemFirst(const char* text,FXIcon* ic=NULL,FXIcon* mi=NULL,void* ptr=NULL);
  virtual FXOldIconItem* addItemLast(const char* text,FXIcon* ic=NULL,FXIcon* mi=NULL,void* ptr=NULL);
  virtual FXOldIconItem* addItemAfter(FXOldIconItem* other,const char* text,FXIcon* ic=NULL,FXIcon* mi=NULL,void* ptr=NULL);
  virtual FXOldIconItem* addItemBefore(FXOldIconItem* other,const char* text,FXIcon* ic=NULL,FXIcon* mi=NULL,void* ptr=NULL);
  virtual void removeItem(FXOldIconItem* item);
  virtual void removeItems(FXOldIconItem* fm,FXOldIconItem* to);
  virtual void removeAllItems();
  virtual FXOldIconItem* getItemAt(FXint x,FXint y) const;
  virtual FXint getItemX(const FXOldIconItem* item) const;
  virtual FXint getItemY(const FXOldIconItem* item) const;
  virtual FXint getItemWidth(const FXOldIconItem* item) const;
  virtual FXint getItemHeight(const FXOldIconItem* item) const;
  void updateItem(FXOldIconItem* item);
  void makeItemVisible(FXOldIconItem* item);
  FXbool isItemSelected(const FXOldIconItem* item) const;
  FXbool isItemCurrent(const FXOldIconItem* item) const;
  FXbool isItemVisible(const FXOldIconItem* item) const;
  FXbool hitItem(const FXOldIconItem* item,FXint x,FXint y) const;
  FXbool hitItemIcon(const FXOldIconItem* item,FXint x,FXint y) const;
  void markItems();
  FXbool selectInRectangle(FXint x,FXint y,FXint w,FXint h);
  FXbool deselectInRectangle(FXint x,FXint y,FXint w,FXint h);
  FXbool toggleInRectangle(FXint x,FXint y,FXint w,FXint h);
  FXbool restoreInRectangle(FXint x,FXint y,FXint w,FXint h);
  FXbool selectItemRange(FXOldIconItem* beg,FXOldIconItem* end);
  FXbool deselectItemRange(FXOldIconItem* beg,FXOldIconItem* end);
  FXbool toggleItemRange(FXOldIconItem* beg,FXOldIconItem* end);
  FXbool restoreItemRange(FXOldIconItem* beg,FXOldIconItem* end);
  FXbool selectItem(FXOldIconItem* item);
  FXbool deselectItem(FXOldIconItem* item);
  FXbool toggleItem(FXOldIconItem* item);
  FXbool restoreItem(FXOldIconItem* item);
  FXint indexOfItem(const FXOldIconItem* item) const;
  FXOldIconItem* itemAtIndex(FXint index) const;
  void sortItems();
  void setCurrentItem(FXOldIconItem* item);
  FXOldIconItem* getCurrentItem() const { return currentitem; }
  void setAnchorItem(FXOldIconItem* item);
  FXOldIconItem* getAnchorItem() const { return anchoritem; }
  FXbool extendSelection(FXOldIconItem* item);
  FXOldIconItem* findItem(const FXString& text,FXuint len=2147483647) const;
  void setItemText(FXOldIconItem* item,const FXString& text);
  FXString getItemText(const FXOldIconItem* item) const;
  void setItemMiniIcon(FXOldIconItem* item,FXIcon* icon);
  FXIcon* getItemMiniIcon(const FXOldIconItem* item) const;
  void setItemIcon(FXOldIconItem* item,FXIcon* icon);
  FXIcon* getItemIcon(const FXOldIconItem* item) const;
  void setItemData(FXOldIconItem* item,void* ptr) const;
  void* getItemData(const FXOldIconItem* item) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  FXOldIconItemSortFunc getSortFunc() const { return sortfunc; }
  void setSortFunc(FXOldIconItemSortFunc func){ sortfunc=func; }
  void setItemSpace(FXint s);
  FXint getItemSpace() const { return itemSpace; }
  void setIconWidth(FXint w);
  FXint getIconWidth() const { return iconWidth; }
  void setIconHeight(FXint h);
  FXint getIconHeight() const { return iconHeight; }
  void setMiniIconWidth(FXint w);
  FXint getMiniIconWidth() const { return miniIconWidth; }
  void setMiniIconHeight(FXint h);
  FXint getMiniIconHeight() const { return miniIconHeight; }
  FXuint getListStyle() const;
  void setListStyle(FXuint style);
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOldIconList();
  };



#endif
