/********************************************************************************
*                                                                               *
*                       S c r o l l   B a r   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXScrollbar.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                    *
********************************************************************************/
#ifndef FXSCROLLBAR_H
#define FXSCROLLBAR_H



// Scrollbar options
enum FXScrollbarOrientation {
  SCROLLBAR_HORIZONTAL = 0x00020000,
  SCROLLBAR_VERTICAL   = 0x00040000
  };


// Scroll bar
class FXAPI FXScrollbar : public FXWindow {
  FXDECLARE(FXScrollbar)
protected:
  FXTimer   *timer;
  FXColor    hiliteColor;
  FXColor    shadowColor;
  FXColor    borderColor;
  FXint      barsize;
  FXint      thumbsize;
  FXint      thumbpos;
  FXint      dragpoint;
  FXint      range;
  FXint      page;
  FXint      line;
  FXint      pos;
  FXuchar    pressed;
protected:
  FXScrollbar();
  void drawButton(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down);
  void drawLeftArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down);
  void drawRightArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down);
  void drawUpArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down);
  void drawDownArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down);
  void autoScrollInc();
  void autoScrollDec();
  void autoScrollLineInc();
  void autoScrollLineDec();
  void autoScrollPageInc();
  void autoScrollPageDec();
  void stopAutoScroll();
private:
  FXScrollbar(const FXScrollbar&);
  FXScrollbar &operator=(const FXScrollbar&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onTimeIncPix(FXObject*,FXSelector,void*);
  long onTimeIncLine(FXObject*,FXSelector,void*);
  long onTimeIncPage(FXObject*,FXSelector,void*);
  long onTimeDecPix(FXObject*,FXSelector,void*);
  long onTimeDecLine(FXObject*,FXSelector,void*);
  long onTimeDecPage(FXObject*,FXSelector,void*);
public:
  enum{
    ID_AUTOINC_LINE=FXWindow::ID_LAST,
    ID_AUTODEC_LINE,
    ID_AUTOINC_PAGE,
    ID_AUTODEC_PAGE,
    ID_AUTOINC_PIX,
    ID_AUTODEC_PIX,
    ID_LAST
    };
public:
  FXScrollbar(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=SCROLLBAR_VERTICAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setRange(FXint r);
  FXint getRange() const { return range; }
  void setPage(FXint p);
  FXint getPage() const { return page; }
  void setLine(FXint l);
  FXint getLine() const { return line; }
  void setPosition(FXint p);
  FXint getPosition() const { return pos; }
  FXint isAutoScrolling();
  FXColor getHiliteColor() const { return hiliteColor; }
  FXColor getShadowColor() const { return shadowColor; }
  FXColor getBorderColor() const { return borderColor; }
  void setHiliteColor(FXColor clr);
  void setShadowColor(FXColor clr);
  void setBorderColor(FXColor clr);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXScrollbar();
  };


// Corner between scroll bars
class FXAPI FXScrollCorner : public FXWindow {
  FXDECLARE(FXScrollCorner)
protected:
  FXScrollCorner();
private:
  FXScrollCorner(const FXScrollCorner&);
  FXScrollCorner &operator=(const FXScrollCorner&);
public:
  long onPaint(FXObject*,FXSelector,void*);
public:
  FXScrollCorner(FXComposite* p);
  virtual void enable();
  virtual void disable();
  };

  
#endif
