/********************************************************************************
*                                                                               *
*                               H e a d e r   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldHeader.cpp,v 1.1 1999/09/14 13:40:08 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXOldHeader.h"


#define FUDGE   8


/*
  To do:
  - Ability to have button behaviour
  - Icon drawing
  - Justify modes
  - Honor frame border styles
  - Need to have font class
  - Should probably derive from FXCell!!
  - FXOldHeaderItem should perhaps derive from FXItem.
  - Should be able to be driven by keyboard.
*/



/*******************************************************************************/

// Map
FXDEFMAP(FXOldHeader) FXOldHeaderMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXOldHeader::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXOldHeader::onMotion),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXOldHeader::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXOldHeader::onLeftBtnRelease),
  FXMAPFUNC(SEL_UNGRABBED,0,FXOldHeader::onUngrabbed),
  };


// Object implementation
FXIMPLEMENT(FXOldHeader,FXFrame,FXOldHeaderMap,ARRAYNUMBER(FXOldHeaderMap))

  
// Make a Header
FXOldHeader::FXOldHeader(){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  firstitem=NULL;
  lastitem=NULL;
  before=NULL;
  font=(FXFont*)-1;
  textColor=0;
  split=0;
  off=0;
  }


// Make a Header
FXOldHeader::FXOldHeader(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXFrame(p,opts,x,y,w,h){
  defaultCursor=getApp()->arrowCursor;
  dragCursor=getApp()->hsplitCursor;
  font=getApp()->normalFont;
  textColor=getApp()->foreColor;
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  target=tgt;
  message=sel;
  firstitem=NULL;
  lastitem=NULL;
  before=NULL;
  split=0;
  off=0;
  }


// Create window
void FXOldHeader::create(){
  FXOldHeaderItem* item;
  FXFrame::create();
  font->create();
  for(item=firstitem; item; item=item->next){
    if(item->icon){item->icon->create();}
    }
  }


// Detach window
void FXOldHeader::detach(){
  FXOldHeaderItem* item;
  FXFrame::detach();
  font->detach();
  for(item=firstitem; item; item=item->next){
    if(item->icon){item->icon->detach();}
    }
  }


// Get default width
FXint FXOldHeader::getDefaultWidth(){
  FXOldHeaderItem* item;
  FXint wmax;
  for(item=firstitem,wmax=0; item; item=item->next){
    wmax+=item->size;
    }
  return wmax;
  }


// Get default height
FXint FXOldHeader::getDefaultHeight(){
  FXOldHeaderItem* item;
  FXint th,ih,hmax;
  for(item=firstitem,hmax=0; item; item=item->next){
    if(item->label.text()){ th=font->getFontHeight(); if(th>hmax) hmax=th; }
    if(item->icon){ ih=item->icon->getHeight(); if(ih>hmax) hmax=ih; }
    }
  return 4+hmax+(border<<1);
  }


// Create item
FXOldHeaderItem* FXOldHeader::createItem(){ 
  return new FXOldHeaderItem; 
  }


// Destroy item
void FXOldHeader::deleteItem(FXOldHeaderItem* item){ 
  delete item; 
  }


// Get number of items
FXint FXOldHeader::getNumItems() const {
  register FXOldHeaderItem *item=firstitem;
  register FXint n=0;
  while(item){
    item=item->next;
    n++;
    }
  return n;
  }


// Get item X
FXint FXOldHeader::getItemX(const FXOldHeaderItem* item) const {
  return item->pos;
  }


// Get item Y
FXint FXOldHeader::getItemY(const FXOldHeaderItem* item) const {
  return 0;
  }


// Get item width
FXint FXOldHeader::getItemWidth(const FXOldHeaderItem* item) const {
  return item->size;
  }


// Get Item height
FXint FXOldHeader::getItemHeight(const FXOldHeaderItem*) const {
  return height;
  }


// Get next item
FXOldHeaderItem* FXOldHeader::getNextItem(const FXOldHeaderItem* item) const {
  return item->next;
  }


// Get previous item
FXOldHeaderItem* FXOldHeader::getPrevItem(const FXOldHeaderItem* item) const {
  return item->prev;
  }


// Add item as first
FXOldHeaderItem* FXOldHeader::addItemFirst(const FXString& text,FXIcon* icon,FXint size,FXObject* tgt,FXSelector sel){
  FXOldHeaderItem *item=createItem();
  item->prev=NULL;
  item->next=firstitem;
  if(item->next) item->next->prev=item; else lastitem=item;
  firstitem=item;
  item->label=text;
  item->icon=icon;
  item->target=tgt;
  item->message=sel;
  item->size=size;
  item->pos=0;
  recalc();
  return item;
  }


// Add item as last
FXOldHeaderItem* FXOldHeader::addItemLast(const FXString& text,FXIcon* icon,FXint size,FXObject* tgt,FXSelector sel){
  FXOldHeaderItem *item=createItem();
  item->prev=lastitem;
  item->next=NULL;
  if(item->prev) item->prev->next=item; else firstitem=item;
  lastitem=item;
  item->label=text;
  item->icon=icon;
  item->target=tgt;
  item->message=sel;
  item->size=size;
  item->pos=0;
  recalc();
  return item;
  }


// Remove node from list
void FXOldHeader::removeItem(FXOldHeaderItem* item){
  if(item){
    if(item->prev) item->prev->next=item->next; else firstitem=item->next;
    if(item->next) item->next->prev=item->prev; else lastitem=item->prev;
    deleteItem(item);
    recalc();
    }
  }


// Remove all items from [fm,to]
void FXOldHeader::removeItems(FXOldHeaderItem* fm,FXOldHeaderItem* to){
  if(fm && to){
    register FXOldHeaderItem *item;
    if(fm->prev) fm->prev->next=to->next; else firstitem=to->next;
    if(to->next) to->next->prev=fm->prev; else lastitem=fm->prev;
    do{
      item=fm;
      fm=fm->next;
      deleteItem(item);
      }
    while(item!=to);
    recalc();
    }
  }


// Remove all items
void FXOldHeader::removeAllItems(){
  register FXOldHeaderItem *item;
  while(firstitem){
    item=firstitem;
    firstitem=firstitem->next;
    deleteItem(item);
    }
  firstitem=NULL;
  lastitem=NULL;
  recalc();
  }


void FXOldHeader::setItemText(FXOldHeaderItem* item,const FXString& text){
  if(item==NULL){ fxerror("%s::setItemText: item is NULL\n",getClassName()); }
  item->label=text;
  update(item->pos,0,item->pos+item->size,height);
  }


FXString FXOldHeader::getItemText(const FXOldHeaderItem* item) const {
  if(item==NULL){ fxerror("%s::getItemText: item is NULL\n",getClassName()); }
  return item->label;
  }

void FXOldHeader::setItemTarget(FXOldHeaderItem* item,FXObject* tgt){
  if(item==NULL){ fxerror("%s::setItemTarget: item is NULL\n",getClassName()); }
  item->target=tgt;
  }


FXObject* FXOldHeader::getItemTarget(const FXOldHeaderItem* item) const {
  if(item==NULL){ fxerror("%s::getItemTarget: item is NULL\n",getClassName()); }
  return item->target;
  }


void FXOldHeader::setItemSelector(FXOldHeaderItem* item,FXSelector sel){
  if(item==NULL){ fxerror("%s::setItemSelector: item is NULL\n",getClassName()); }
  item->message=sel;
  }


FXSelector FXOldHeader::getItemSelector(const FXOldHeaderItem* item) const{
  if(item==NULL){ fxerror("%s::getItemSelector: item is NULL\n",getClassName()); }
  return item->message;
  }


void FXOldHeader::setItemIcon(FXOldHeaderItem* item,FXIcon* icon){
  if(item==NULL){ fxerror("%s::setItemIcon: item is NULL\n",getClassName()); }
  item->icon=icon;
  update(item->pos,0,item->pos+item->size,height);
  }


FXIcon* FXOldHeader::getItemIcon(const FXOldHeaderItem* item) const {
  if(item==NULL){ fxerror("%s::getItemIcon: item is NULL\n",getClassName()); }
  return item->icon;
  }


// Do layout
void FXOldHeader::layout(){
  FXOldHeaderItem* item;
  FXint pos;
  
  // Recompute item positions
  for(item=firstitem,pos=0; item; item=item->next){
    item->pos=pos;
    pos+=item->size;
    }
  
  // Force repaint
  update();
  
  // No more dirty
  flags&=~FLAG_DIRTY;
  }


// Adjust horizontal layout
void FXOldHeader::adjustLayout(){
  FXOldHeaderItem* item;
  FXint pos;
  if(before){
    before->size=split+border-before->pos;
    for(item=before->next,pos=before->pos+before->size; item; item=item->next){
      item->pos=pos;
      pos+=item->size;
      }
    update(before->pos,0,width,height);
    }
  }


// Move the horizontal split intelligently
void FXOldHeader::moveSplit(FXint pos){
  FXint smin=before->pos;
  FXint smax=width-(border<<1);
  split=pos;
  if(split<smin) split=smin;
  if(split>smax) split=smax;
  }


// Handle repaint 
long FXOldHeader::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXOldHeaderItem* item;
  FXint x,dw,tw,rs,num,space,s;
  FXDCWindow dc(this,ev);
  dw=font->getTextWidth("...",3);
  space=(border<<1);
  rs=0;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  dc.setTextFont(font);
  for(item=firstitem; item && item->pos<width; item=item->next){
    x=item->pos+border+3;
    s=item->size-space-6;
    if(item->icon){
      if(item->icon->getWidth()<=s){
        dc.drawIcon(item->icon,x,2+border);
        x+=item->icon->getWidth()+4;
        }
      s-=item->icon->getWidth()+4;
      }
    if(item->label.text() && s>0){
      num=item->label.length();
      if(font->getTextWidth(item->label.text(),num)>s){
        while(num>0 && (tw=font->getTextWidth(item->label.text(),num))>(s-dw)) num--;
        if(num>0){
          dc.setForeground(textColor);
          dc.drawText(x,2+border+font->getFontAscent(),item->label.text(),num);
          dc.drawText(x+tw,2+border+font->getFontAscent(),"...",3);
          }
        else{
          if(font->getTextWidth(item->label.text(),1)<=s){
            dc.setForeground(textColor);
            dc.drawText(x,2+border+font->getFontAscent(),item->label.text(),1);
            }
          }
        }
      else{
        dc.setForeground(textColor);
        dc.drawText(x,2+border+font->getFontAscent(),item->label.text(),num);
        }
      }
    drawFrame(dc,item->pos,0,item->size,height);
    rs=item->pos+item->size;
    }
  if(rs<width){
    drawFrame(dc,rs,0,width-rs,height);
    }
  return 1;
  }


// Button being pressed
long FXOldHeader::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  for(before=firstitem; before; before=before->next){
    if(before->pos+before->size-FUDGE<=ev->win_x && ev->win_x<=before->pos+before->size+FUDGE){
      split=before->pos+before->size-border;
      off=ev->win_x-split;
      grab();
      drawSplit(split);
      return 1;
      }
    }
  return 1;
  }
  

// Button being released
long FXOldHeader::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  FXOldHeaderItem* item;
  if(before){
    ungrab();
    drawSplit(split);
    adjustLayout();
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),before);
    before=NULL;
    }
  else{
    for(item=firstitem; item; item=item->next){
      if(item->pos+FUDGE<=ev->win_x && ev->win_x<=item->pos+item->size-FUDGE){
        if(item->target){
          item->target->handle(this,MKUINT(item->message,SEL_COMMAND),(void*)item);
          break;
          }
        }
      }
    }
  return 1;
  }


// The widget lost the grab for some reason
long FXOldHeader::onUngrabbed(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onUngrabbed(sender,sel,ptr);
  flags&=~FLAG_PRESSED;
  flags&=~FLAG_CHANGED;
  flags|=FLAG_UPDATE;
  before=NULL;
  return 1;
  }


// Button being moved
long FXOldHeader::onMotion(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  FXOldHeaderItem* item;
  if(before){
    FXint cur,oldsplit;
    oldsplit=split;
    cur=ev->win_x;
    moveSplit(cur-off);
    if(split!=oldsplit){
      drawSplit(oldsplit);
      drawSplit(split);
      if(target){
        target->handle(this,MKUINT(message,SEL_DRAGGED),before);
        }
      }
    }
  else{
    for(item=firstitem; item; item=item->next){
      if(item->pos+item->size-FUDGE <= ev->win_x && ev->win_x <= item->pos+item->size+FUDGE){
        setDefaultCursor(getApp()->hsplitCursor);
        return 1;
        }
      }
    setDefaultCursor(getApp()->arrowCursor);
    }
  return 1;
  }


// Draw the horizontal split
void FXOldHeader::drawSplit(FXint pos){
  if(border){
    FXDCWindow dc(getParent());
    FXint b=border<<1;
    FXint px,py;
    translateCoordinatesTo(px,py,getParent(),pos,0);
    dc.clipChildren(FALSE);
    dc.setFunction(BLT_NOT_DST);
    dc.fillRectangle(px,0,b,getParent()->getHeight());
    }
  }


// Change the font
void FXOldHeader::setFont(FXFont* fnt){
  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
  font=fnt;
  recalc();
  update();
  }


// Set text color
void FXOldHeader::setTextColor(FXColor clr){
  textColor=clr;
  update();
  }


// Clean up
FXOldHeader::~FXOldHeader(){
  removeAllItems();
  firstitem=(FXOldHeaderItem*)-1;
  lastitem=(FXOldHeaderItem*)-1;
  before=(FXOldHeaderItem*)-1;
  font=(FXFont*)-1;
  }


