/*
 * afos.h
 *
 * afosd header files
 *
 * $Id: afos.h,v 1.12 1996/08/31 05:02:46 ron Exp $
 *
 */
#ifndef _AF_H_
#define _AF_H_

#define AF_VERSION		1
#define PORT_CONFIG_FILE "/etc/wxd/ports"
#define PORT_FILTER_FILE "/etc/wxd/filter"
#define WXD_LOG_FILE	 "/var/log/wxd/wxd.log"

#define AFFILT_BUFSIZE	(16 * 1024)
#define AFHIST_PRODUCT_SIZE 16
#define AFCHAN_NAME_SIZE	32
#define AF_MAX_FILES		32
#define DISPLAY_UPDATE_INTERVAL  5
/* TCP connect retry time in seconds */
#define AFTCP_CONNECT_RETRY_TIME  10



#define AFEVENT_READ	1
#define AFEVENT_WRITE	2
#define AFEVENT_EXCEPT  3
#define AFEVENT_TIMEOUT 4

#define AFOS_PORT_TRACE_BYTE	0x01

extern char af_link_time[] ;
extern char af_link_date[] ;
extern char af_release_version[] ;
extern char afos_in_channel_name[];


typedef struct _AF_CHANNEL_LINK_ {
	struct _AF_CHANNEL_LINK_  *next ;
	struct _AF_CHANNEL_ *channel ;
	} AF_CHANNEL_LINK ;

typedef struct _AF_HIST_ {
	struct _AF_HIST_  *next ;
	char name[AFHIST_PRODUCT_SIZE];
	int count ;
	AF_CHANNEL_LINK *chanlist ;
	} AF_HIST ;

typedef struct _AF_FILT_STATS_ {
	int char_count ;
	int zczc_count ;
	int nnnn_count ;
	int buffer_count ;
	int incomplete_buffers ;
	int match_count ;
	int buffer_overruns ;
	int errchar_count ;
	} AF_FILT_STATS ;

typedef struct _AF_SELECT_ENTRY_ {
	 struct _AF_SELECT_ENTRY_ *next ;
	 int	fd ;
	 void (*handler)(void* private, int event ) ;
	 void *private ;
	 } AF_SELECT_ENTRY ;

#define PORT_CHANNEL 1
#define FILE_CHANNEL 2
#define LOG_CHANNEL  3
#define TCP_CHANNEL  4
#define PROC_CHANNEL 5
#define PIPE_CHANNEL 6
#define AFOS_CHANNEL 7
#define APRS_CHANNEL 8

extern char *Channel_description[] ;

typedef struct _AF_CHANNEL_ {
	struct _AF_CHANNEL_ *next ;
	char name[AFCHAN_NAME_SIZE];
	void *private ;
	int fd ;
	int channel_type ;
	int write_count ;
	int bytes_read ;
	int bytes_written ;
	int (*init)();
	int (*chanwrite)();
	int (*changetchar)();
	} AF_CHANNEL ;

typedef struct _PORT_STRUCT_ {
	void (*read_callback)();
	char device_name[AFCHAN_NAME_SIZE];
	int baud ;
	int parity ;
	int stops ;
	int bits ;
	} PORT_STRUCT ;

typedef struct _ECHO_CHANNEL_ {
	AF_CHANNEL *from ;
	AF_CHANNEL *to ;
	int *from_tally ;
	} ECHO_CHANNEL ;

typedef struct _APRS_STRUCT_ {
	char tnc_name[AFCHAN_NAME_SIZE];
	char pc_name[AFCHAN_NAME_SIZE];
	AF_CHANNEL *aprs_tnc ;
	AF_CHANNEL *aprs_pc ;
	ECHO_CHANNEL *from_pc ;
	ECHO_CHANNEL *from_tnc ;
	int		aprs_out_count ;
	int		from_tnc_echo_count ;  
	int 	from_pc_echo_count ;
	} APRS_STRUCT ;

extern AF_FILT_STATS filter_stats ;
extern AF_CHANNEL *channel_list ;
extern AF_CHANNEL *afos_in_channel ;
extern AF_HIST *history_list ;
extern AF_CHANNEL_LINK *aprs_list ;

void afhist_display( void ) ;
AF_HIST *afhistlog( char *prod, int size ) ;
void ifconfigports ( char *filename ) ;
int verify_unique_portname( char *name ) ;
extern AF_CHANNEL *find_channel_by_name ( char *name );
void process_filter_buffer( unsigned char *s, int size ) ;
void af_timeout_set_handler ( void *p ) ;

#endif
