/* Copyright (C) 1999 Rafal Wierzbicki <rafal@mcss.mcmaster.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static char *cvsident = "$Id: gtk_listi.c,v 1.18 1999/01/31 10:00:19 rafal Exp
                        $";
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "Pictorial.xpm"

#include "wallp.h"

/*Prototypes*/

/*local*/
static void file_selection ();
static gint list_show ();
static void list_remove (gint selection, GtkWidget *list);

GtkEntry *entry = NULL;
unsigned int no_of_list_items = 0;
static int current = 0;
static int pcurrent = 0;
static int timer = 0;
static int ptimer = 0;
static int calls = 0;

GtkWidget *list = NULL;
GtkWidget *progressbar = NULL;
GtkWidget *tbutton = NULL;
GtkWidget *window = NULL;

extern GSList *simple_list;

static int RADIO = 0;
static char last_visit[64];

static gint wharf_list_show ();

void select_row (int selection)
{
    gtk_clist_select_row (GTK_CLIST(list), selection, 0);
    gtk_clist_moveto (GTK_CLIST(list), selection, 0, 0, 0);
}

static char *
get_row_text (int row)
{
    char *item_data[1];

    gtk_clist_get_text (GTK_CLIST(list), row, 0, item_data);
    return item_data[0];
}

unsigned int
random_image ()
{
    unsigned int j;

    j = 0+(int) ( (float) no_of_list_items * rand()/(RAND_MAX+1.0));
    return j;
}

static void
next_image ()
{
    char *item_data;

    if (current == (no_of_list_items - 1) )
        return;
    current = current + 1;
    select_row (current);
    item_data = get_row_text (current);
    if (put_image_on_root (item_data, STYLE))
    {
        list_remove (current, list);
    }
}

static void
previous_image ()
{
    char *item_data;

    if (current <= 0)
        return;
    current = current - 1;
    select_row (current);
    item_data = get_row_text (current);
    if (put_image_on_root (item_data, STYLE)){
        list_remove (current, list);
    }

}

static void
start_idle (GtkWidget *w, GtkEntry *entry)
{
    if (!timer){
        timer = gtk_timeout_add (1000, (GtkFunction) list_show, entry);
    }
}

void static
stop_idle ()
{
    if (timer){
        gtk_timeout_remove (timer);
        timer = 0;
    }
}

void list_add (gchar *buffer)
{
    gint row;
    if (current < 0) {
        current = 0;
    }

    row = gtk_clist_append (GTK_CLIST(list), &buffer);
    gtk_clist_set_row_data (GTK_CLIST(list), row, buffer);
    no_of_list_items = no_of_list_items + 1;
}

static void
remove_all ()
{
    gtk_clist_clear (GTK_CLIST (list));
    no_of_list_items = 0;
    current = -1;
}

static void
list_remove (gint selection,
             GtkWidget *list)
{

    if (no_of_list_items > 1){
        gtk_clist_unselect_row (GTK_CLIST(list), selection, 0);
        gtk_clist_remove (GTK_CLIST(list), selection);
        if (selection!=0)
        {
            select_row (current -1);
            current = current - 1;
        }
        else
        {
            select_row (0);
            if (no_of_list_items - 1 < 0)
                current = -1;
            else
                current = 0;
        }
        no_of_list_items = no_of_list_items - 1;
    }
    else
        remove_all ();
}

static void
list_remove_s (GtkWidget *widget, GtkWidget *list)
{
    gtk_clist_remove (GTK_CLIST(list), current);
    if (no_of_list_items > 0)
    {
        if (current > 0)
            current = current - 1;
        else
            current = 0;
        no_of_list_items=no_of_list_items-1;
        select_row (current);
    }
    else
    {
        no_of_list_items=0;
        current = -1;
    }
}

static void
quit (GtkWidget *widget)
{
    gdk_flush();
    write_control_file();
    dump_list_to_file();
    gtk_widget_destroy (widget);
    gtk_main_quit();
    exit(0);
}

/* Deprecated, not use the ~/.wallp functions in wallp.c */
void read_list_from_file (char *oldstyle)
{
    FILE *fp;
    char tmp[128];

    fp = fopen (oldstyle, "r");
    if (fp)
    {
        fgets (tmp, 127, fp);
        tmp[strlen(tmp)-1] = '\0';
        gtk_entry_set_text (entry, tmp);
        while (1)
        {
            fgets (tmp, 127, fp);
            tmp[strlen(tmp)-1] = '\0';
            if (!feof(fp))
                list_add (tmp);
            else
                break;
        }
        select_row (0);
        fclose (fp);
    }
}

static
gint stop_all ()
{
    calls = 0;
    gtk_progress_bar_update (GTK_PROGRESS_BAR(progressbar), 0.0);
    stop_idle ();
    return FALSE;
}

static void
toggle_idle (GtkWidget *w, gpointer data)
{
    if (GTK_TOGGLE_BUTTON (w)->active) {
        start_idle(w, NULL);
    } else {
        stop_all();
    }
}

static
gint list_show ()
{
    char *item_data;
    static int sleep_time;
    static time_t time_start;
    time_t time_now;
    gint selection;
    gfloat percentage = 0.0;

    time_now = time (NULL);

    if (calls == 0)
    {
        calls = 1;
        selection = (gint) random_image ();
        select_row (selection);
        pcurrent = (gint) random_image ();
        item_data = get_row_text (pcurrent);
        current = selection;
        dump_list_to_file();
        percentage = 0.0;

        if (!PREVIEW_ONLY)
        {
            PREVIEW_ONLY = 1;
            preview (item_data, STYLE);
            PREVIEW_ONLY = 0;
        }
        item_data = get_row_text (selection);
        if (put_image_on_root (item_data, STYLE))
        {
            list_remove (selection, list);
        }

        time_start = time (NULL);
    }

    if (entry)
    {
        sleep_time = atoi (gtk_entry_get_text (entry)) * 60;
        if (sleep_time == 0)
        {
            gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (tbutton),
                                         GTK_STATE_NORMAL);
            stop_all ();
            fprintf (stderr, "Sleep time is 0 minutes Enter new time and press OK in the main window");
            return FALSE;
        }
        gtk_progress_bar_update (GTK_PROGRESS_BAR(progressbar), 0.0);
    }
    else
    {
        stop_all ();
        return FALSE;
    }

    percentage =  ((float)time_now - (float)time_start)/(float)sleep_time;
    /* strange manouvers here to make the progress bar as accurate as possible */
    if (percentage > 1.0)
        percentage = 1.0;
    else if (percentage < 0.0)
        percentage = 0.0;
    gtk_progress_bar_update (GTK_PROGRESS_BAR(progressbar), percentage);

    if ((time_now - time_start) >= sleep_time )
    {

        if (no_of_list_items == 0)
        {
            stop_all ();
            return FALSE;
        }
        selection = pcurrent;
        pcurrent = (gint) random_image ();
        select_row (selection);
        current = selection;
        item_data = get_row_text (pcurrent);
        percentage = 1.0;
        gtk_progress_bar_update (GTK_PROGRESS_BAR(progressbar), percentage);
        if (!PREVIEW_ONLY)
        {
            PREVIEW_ONLY = 1;
            preview (item_data, STYLE);
            PREVIEW_ONLY = 0;
        }
        item_data = get_row_text (selection);
        if (put_image_on_root (item_data, STYLE))
        {
            list_remove (selection, list);
        }
        time_start = time (NULL);
    }
    return TRUE;
}

static
void change_now ()
{
    char *item_data;
    gint selection;

    selection = pcurrent;
    pcurrent = (gint) random_image();
    current = selection;
    select_row (selection);

    item_data = get_row_text (pcurrent);
    /*dump_list_to_file();*/

    if (!PREVIEW_ONLY)
    {
        preview (item_data, STYLE);
    }

    item_data = get_row_text (selection);
    if (put_image_on_root (item_data, STYLE))
    {
        list_remove (selection, list);
    }
}

static void
sig_button_event (GtkWidget *list, GdkEventButton *event)
{
    char *item_data;

    if (current < 0)
        return;
    if (event->type==GDK_BUTTON_RELEASE && event->button==3)
    {
        gtk_clist_get_selection_info (GTK_CLIST(list),
                                      event->x, event->y,
                                      &current, NULL);
        item_data = get_row_text (current);
        gtk_clist_select_row (GTK_CLIST(list), current, 0);
        if (put_image_on_root (item_data, STYLE))
            list_remove (current, list);
    }
    else if (event->type==GDK_BUTTON_RELEASE && event->button==1)
    {
        gtk_clist_get_selection_info (GTK_CLIST(list),
                                      event->x, event->y,
                                      &current, NULL);
    }
}

void auto_start (GtkWidget *w, gpointer data)
{
    static int ncalls=0;

    if (ncalls == 0 && AUTO_START !=0)
    {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (w),
                                     GTK_STATE_ACTIVE);
        start_idle (w, NULL);
    }
}

static void
radio_button (GtkWidget *w, gint style)
{
    if (RADIO)
        STYLE = style;
}

void create_list (void)
{
    GtkWidget *vbox1, *vbox2, *vbox3;
    GtkWidget *hbox1, *hbox2, *hbox3, *rbox;
    GtkWidget *scrolled_win;
    GtkWidget *button;
    GtkWidget *separator;
    GtkWidget *frame1, *frame2;
    GdkPixmap *pixmap = NULL;
    GdkBitmap *mask = NULL;
    GtkStyle *style;
    GtkWidget *darea, *viewport;
    GSList *rgroup;
    GtkTooltips *tooltips;

    if (!window)
    {
        window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title (GTK_WINDOW (window), "WallP");
        /*gtk_widget_set_usize (window, 530, 275);*/
        gtk_widget_set_uposition (window, 20, 20);
        gtk_widget_realize (window);

        gtk_signal_connect (GTK_OBJECT (window), "destroy",
                            GTK_SIGNAL_FUNC(gtk_main_quit),
                            NULL);
        gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                            GTK_SIGNAL_FUNC (gtk_false),
                            NULL);

        /* Initialize tooltips */
        tooltips = gtk_tooltips_new ();

        vbox1 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (window), vbox1);
        gtk_widget_show (vbox1);

        hbox1 = gtk_hbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox1), 0);
        gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);
        gtk_widget_show (hbox1);

        separator = gtk_hseparator_new ();
        gtk_box_pack_start (GTK_BOX (vbox1), separator, FALSE, FALSE, 0);
        gtk_widget_show (separator);


        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (vbox2), 0);
        gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 0);
        gtk_widget_show (vbox2);


        /* timer stuff goes in here */
        frame1 = gtk_frame_new ("Sleep period\n(mins)");
        gtk_container_border_width (GTK_CONTAINER (frame1), 0);
        gtk_box_pack_start (GTK_BOX (vbox2), frame1, FALSE, FALSE, 0);
        gtk_widget_show (frame1);

        entry = GTK_ENTRY (gtk_entry_new ());
        if (init_entry)
            gtk_entry_set_text (GTK_ENTRY (entry), init_entry);
        else
            gtk_entry_set_text (GTK_ENTRY (entry), "15");
        gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
        gtk_container_add (GTK_CONTAINER (frame1), GTK_WIDGET (entry));
        gtk_widget_show (GTK_WIDGET (entry));

        /* Entry tooltip */
        gtk_tooltips_set_tip (tooltips, GTK_WIDGET(entry),
                              "Enter the time here (in minutes)", NULL);

        /* preview area */
        vbox3 = gtk_vbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 0);
        gtk_box_pack_start (GTK_BOX (vbox2), vbox3, FALSE, FALSE,0);
        gtk_widget_show (vbox3);

        /* viewing area test_area */
        viewport = gtk_viewport_new (NULL, NULL);
        gtk_widget_set_usize(viewport, 1024 /4, 768 / 4);
        gtk_box_pack_start(GTK_BOX(vbox2),viewport,FALSE,FALSE,0);
        gtk_widget_show(viewport);

        darea=gtk_drawing_area_new();
        gtk_drawing_area_size (GTK_DRAWING_AREA(darea), 1024 / 4, 768 /4);
        gtk_widget_set_usize(darea, 1024 / 4, 768 / 4);
        gtk_container_add(GTK_CONTAINER(viewport),darea);
        gtk_widget_show(darea);
        preview_area = darea;

        /* progress bar */
        progressbar = gtk_progress_bar_new ();
        gtk_widget_set_usize (progressbar, 10, 0);
        gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(progressbar),
                                          GTK_PROGRESS_TOP_TO_BOTTOM);
        gtk_box_pack_start (GTK_BOX(hbox1), progressbar, FALSE, FALSE,0);
        gtk_widget_show (progressbar);

        vbox3 = gtk_vbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 0);
        gtk_box_pack_start (GTK_BOX(hbox1), vbox3, FALSE, FALSE, 0);
        gtk_widget_show (vbox3);

        /* scrolled list goes in here */

        frame2 = gtk_frame_new ("Images");
        gtk_container_border_width (GTK_CONTAINER (frame1), 0);
        gtk_box_pack_start (GTK_BOX (vbox3), frame2, FALSE, FALSE, 0);
        gtk_widget_show (frame2);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                                        GTK_POLICY_NEVER,
                                        GTK_POLICY_AUTOMATIC);
        gtk_widget_set_usize (scrolled_win, 250, 175);
        gtk_container_add (GTK_CONTAINER (frame2), scrolled_win);
        gtk_widget_show (scrolled_win);

        list = gtk_clist_new (1);
        gtk_clist_set_selection_mode (GTK_CLIST(list), GTK_SELECTION_BROWSE);
        gtk_container_add (GTK_CONTAINER (scrolled_win), list);
        gtk_widget_show (list);
        gtk_signal_connect(GTK_OBJECT(list),
                           "button_release_event",
                           GTK_SIGNAL_FUNC(sig_button_event),
                           NULL);


        hbox3 = gtk_hbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox3), 0);
        gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, FALSE, 0);
        gtk_widget_show (hbox3);

        /* -------------------------Add button----------------------------------------- */
        button = gtk_button_new_with_label ("Add");
        GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
        gtk_signal_connect ( GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (file_selection),
                             NULL);
        gtk_box_pack_start (GTK_BOX (hbox3), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Add images", NULL);
        gtk_widget_show (button);
        /* ------------------------Add button done--------------------------------- */

        /*------------------------Remove button------------------------------------*/
        button = gtk_button_new_with_label ("Remove");
        GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (list_remove_s),
                            list);
        gtk_tooltips_set_tip (tooltips, button, "Remove selected image", NULL);
        gtk_box_pack_start (GTK_BOX (hbox3), button, TRUE, TRUE, 0);
        gtk_widget_show (button);
        /*--------------------------Remove button done----------------------------*/

        /* -------------------------radio buttons------------------------------------ */
        rbox = gtk_hbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (rbox), 0);
        gtk_box_pack_start (GTK_BOX(vbox3), rbox, FALSE, FALSE, 0);
        gtk_widget_show (rbox);

        /* Tile radiobutton */
        button = gtk_radio_button_new_with_label (NULL, "Tile");
        rgroup = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
        if (STYLE == TILE || STYLE == 0)
            gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button),
                                         GTK_STATE_ACTIVE);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (radio_button),
                            (gpointer) TILE);
        gtk_box_pack_start (GTK_BOX(rbox), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Set style to Tile", NULL);
        gtk_widget_show (button);

        /* Scale radiobutton */
        rgroup = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
        button = gtk_radio_button_new_with_label (rgroup, "Scale");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (radio_button),
                            (gpointer) SCALE);
        if (STYLE == SCALE)
            gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button),
                                         GTK_STATE_ACTIVE);
        gtk_box_pack_start (GTK_BOX(rbox), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Set style to Scale", NULL);
        gtk_widget_show (button);
        /* done */

        /* Scale with aspect radiobutton */
        rgroup = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
        button = gtk_radio_button_new_with_label (rgroup, "Scale (aspect)");
        if (STYLE == ASPECT)
            gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button),
                                         GTK_STATE_ACTIVE);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (radio_button),
                            (gpointer) ASPECT);
        gtk_box_pack_start (GTK_BOX(rbox), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Set style to Scale with aspect", NULL);
        gtk_widget_show (button);
        /* done */

        /* Center radiobutton */
        rgroup = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
        button = gtk_radio_button_new_with_label (rgroup, "Center");
        if (STYLE == CENTER)
            gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button),
                                         GTK_STATE_ACTIVE);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (radio_button),
                            (gpointer) CENTER);
        gtk_box_pack_start (GTK_BOX(rbox), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Set style to Center", NULL);
        gtk_widget_show (button);
        /* done */
        RADIO = 1;
        /* Close ok buttons in here */
        hbox2 = gtk_hbox_new (FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 0);
        gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);
        gtk_widget_show (hbox2);

        /*Close button - End program */
        button = gtk_button_new_with_label ("Quit");
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC(quit),
                                   GTK_OBJECT (window));
        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_tooltips_set_tip (tooltips, button, "End program", NULL);
        gtk_widget_show (button);

        /*Save button - Save list to file */
        button = gtk_button_new_with_label ("Save");
        GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC(dump_list_to_file),
                            NULL);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Save the current list of images", NULL);
        gtk_widget_show (button);

        /* Remove all button - clear the list */
        button = gtk_button_new_with_label ("Clear");
        GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC(remove_all),
                            NULL);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Clear the list of images", NULL);
        gtk_widget_show (button);

        /* Next image */
        button = gtk_button_new_with_label ("Next");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (next_image),
                            NULL);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Load next image from the list", NULL);
        gtk_widget_show (button);

        /* Previous image */
        button = gtk_button_new_with_label ("Previous");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (previous_image),
                            NULL);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        gtk_tooltips_set_tip (tooltips, button, "Load previous image from the list", NULL);
        gtk_widget_show (button);

        /* Change now button */
        button = gtk_button_new_with_label ("Cycle");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (change_now),
                            NULL);

        gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
        gtk_tooltips_set_tip (tooltips, button, "Display a random image from the list", NULL);
        gtk_widget_show (button);

        /* Active toggle button */
        tbutton = gtk_toggle_button_new_with_label ("Running");
        gtk_signal_connect (GTK_OBJECT (tbutton), "toggled",
                            GTK_SIGNAL_FUNC (toggle_idle),
                            NULL);
        gtk_signal_connect (GTK_OBJECT (tbutton), "map_event",
                            GTK_SIGNAL_FUNC (auto_start),
                            NULL);
        gtk_box_pack_start (GTK_BOX (hbox2), tbutton, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS (tbutton, GTK_CAN_DEFAULT);
        gtk_widget_grab_default (button);
        /*   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE); */
        gtk_tooltips_set_tip (tooltips, tbutton, "Toggle random mode off and on", NULL);
        gtk_widget_show(tbutton);


        /*Window manager hints*/
        style = gtk_widget_get_style (window);
        pixmap = gdk_pixmap_create_from_xpm_d(window->window, &mask,
                                              &style->bg[GTK_STATE_NORMAL],
                                              (gchar **)Pictorial_xpm);

        gdk_window_set_icon (window->window, NULL, pixmap, mask);
        gdk_window_set_icon_name (window->window, "WallP 0.64");
        gdk_window_set_functions (window->window, GDK_FUNC_ALL);
        gdk_window_set_decorations (window->window, GDK_DECOR_ALL);
    }

    if (!GTK_WIDGET_VISIBLE (window))
        gtk_widget_show (window);
    else
        gtk_widget_destroy (window);
}

/*GtkWidget *xpm_label_box (GtkWidget *parent,
  gchar **data, gchar *label_text)
  {
  GtkWidget *box;
  GtkWidget *label1;
  GtkWidget *pixmapwid;
  GdkBitmap *mask=NULL;
  GdkPixmap *pixmap=NULL;
  GtkStyle *style;

  box = gtk_hbox_new (FALSE,0);
  gtk_container_border_width (GTK_CONTAINER (box), 2);
  style = gtk_widget_get_style (parent);
  pixmap = gdk_pixmap_create_from_xpm_d (parent-window, &mask
  &style->bg[GTK_STATE_NORMAL],
  data);
  pixmapwid = gtk_pixmap_new (pixmap, mask);
  label1 = gtk_label_new (label_text);
  gtk_box_pack_start (GTK_BOX (box),
  pixmapwid, FALSE, FALSE, 3);
  
  gtk_box_pack_start (GTK_BOX (box), label1, FALSE, FALSE, 3);
  
  gtk_widget_show(pixmapwid);
  gtk_widget_show(label1);
  
  return (box);
  }*/

static void
file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
    sprintf (last_visit, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
    list_add (last_visit);
    gtk_widget_destroy (GTK_WIDGET(fs));
}

static void
add_all_files (GtkWidget *widget, GtkFileSelection *fs)
{
    DIR *dp;
    char buff[255];
    char tmp [255];
    struct stat st;
    struct dirent *dir;
    int pos;

    memset (buff, '\0', 255);
    memset (tmp, '\0', 255);

    snprintf (buff, 254, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION(fs)));
    if (!(dp = opendir (buff)))
    {
        pos = strlen(buff) - strlen(strrchr(buff, '/'));
        buff[pos]='\0';
        dp = opendir (buff);
    }

    while ((dir=readdir(dp)))
    {
        strcpy (tmp, buff);
        if (tmp[strlen(tmp)-1] != '/')
            strcat (tmp, "/");
        strcat (tmp, dir->d_name);
        stat (tmp, &st);
        if (!S_ISDIR (st.st_mode))
            list_add (tmp);
    }
    closedir (dp);
    gtk_widget_destroy (GTK_WIDGET(fs));
}

static void
file_selection ()
{
    static GtkWidget *filew=NULL;
    GtkWidget *button;

    if (!filew)
    {
        /* Create a new file selection widget */
        filew = gtk_file_selection_new ("Select an image");
        gtk_window_position (GTK_WINDOW (filew), GTK_WIN_POS_MOUSE);

        gtk_signal_connect (GTK_OBJECT (filew), "destroy",
                            GTK_SIGNAL_FUNC(gtk_widget_destroyed)
                            , &filew);

        /* Connect the ok_button to file_ok_sel function */
        gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                        (filew)->ok_button),
                            "clicked", GTK_SIGNAL_FUNC (file_ok_sel),
                            filew);

        /* Connect the cancel_button to destroy the widget */
        gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
                                               (filew)->cancel_button),
                                   "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (filew));

        gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew),
                                         last_visit);
        /* Add all files button */
        button = gtk_button_new_with_label ("Add all");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                            (GtkSignalFunc) add_all_files,
                            (gpointer) filew);
        gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (filew)->action_area),
                            button, FALSE, FALSE, 0);
        gtk_widget_show (button);
    }
    if (!GTK_WIDGET_VISIBLE (filew))
        gtk_widget_show(filew);
    else
        gtk_widget_destroy (filew);
}

